/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: NearStoreRequest
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/14 9:32
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;

@Data
public class NearStoreRequest {

    // 版本号
    private String version;

    //商户编号
    @NotEmpty(message = "partnerId不能为空")
    private String partnerId;

    @NotEmpty(message = "appId 不能为空")
    private String appId;

    //纬度
    @NotEmpty(message = "纬度不能为空")
    private String latitude;

    //经度
    @NotEmpty(message = "经度不能为空")
    private String longitude;

    //页码，不传默认为1
    @NotNull(message = "页码不能为空")
    private Integer pageNo;

    //每页显示条数，不传默认为10
    @NotNull(message = "每页显示数量不能为空")
    private Integer pageSize;

    /**
     * 门店ID非必传
     */
    private String shopId;

    /**
     * 默认距离
     */
    private String distance;

    private String sessionId;

}
