package cn.freemud.order.entity;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Data
@Table(name = "open_platform_partner_payment_auth")
public class OpenPlatformPartnerPaymentAuth implements Serializable {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 间连渠道:10007:微信小程序,10094:微信扫码支付,10204:优赋小程序支付,10216:扫呗公众号支付,10213:易宝支付
     */
    @Column(name = "pay_code")
    private String payCode;

    @Column(name = "sp_mchid")
    private String spMtchid;

    @Column(name = "sp_appid")
    private String spAppid;

    /**
     * 序列号
     */
    @Column(name = "serial_no")
    private String serialNo;

    /**
     * 密钥
     */
    @Column(name = "private_key")
    private String privateKey;

    @Column(name = "type")
    private Byte type;

    @Column(name = "remark")
    private String remark;

    /**
     * 状态，0:不可用，1：可用
     */
    @Column(name = "status")
    private Byte status;

    /**
     * 创建者
     */
    @Column(name = "creator")
    private String creator;

    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;



}