package com.freemud.application.sdk.api.ordercenter.adapter;

import com.freemud.application.sdk.api.ordercenter.response.OrderDownloadResp;
import com.freemud.application.sdk.api.ordercenter.response.orderInfo.*;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
public class OrderCenterSdkAdapter {

    public List<OrderDownloadResp> convent2OrderDownloads(List<OrderInfoReqs> orderDtos) {
        List<OrderDownloadResp> downloads = new ArrayList<>();
        orderDtos.forEach(orderDto -> {
            OrderDownloadResp download = new OrderDownloadResp();
            download.setOid(orderDto.getOrderCode());
            download.setShopId(orderDto.getStoreId());
            download.setShopName(orderDto.getStoreName());
            download.setUserName(orderDto.getUserName());
            download.setSource("saas");
            download.setSource("i点餐");
            download.setType(orderDto.getOrderType().intValue());
            download.setTypeStr("");
            download.setStatus(orderDto.getOrderState().intValue());
//            download.setStatusStr(OrderStatus.getByIndex(orderDto.getOrderState()).getName());
            download.setOrderAmount(orderDto.getOriginalAmount().intValue());
            download.setOrderAmountYuan(new Double(orderDto.getOriginalAmount().doubleValue() / 100));
            download.setAmount(orderDto.getActualPayAmount().intValue());
            download.setAmountYuan(orderDto.getActualPayAmount().doubleValue() / 100);

            Integer productAmount = 0;
            for (OrderItemResp orderItemDto : orderDto.getOrderItemList()) {
                download.setProductId(orderItemDto.getProductId());
                download.setProductName(orderItemDto.getProductName());
                download.setProductPrice(orderItemDto.getProductPrice().intValue());
                download.setProductPriceYuan(orderItemDto.getProductPrice().doubleValue() / 100);
//                download.setProductDiscountAmountYuan(orderItemDto.getProductPrice().subtract(orderItemDto.getSalePrice()).doubleValue()/100);
                productAmount += orderItemDto.getProductPrice().intValue() * orderItemDto.getProductQuantity();
            }
            download.setProductAmount(productAmount);
            download.setProductAmountYuan(productAmount.doubleValue() / 100);

            for (OrderCostResp detail : orderDto.getOrderCostDetailList()) {
//                if(detail.getCostType() .equals(OrderCostType.PACKING_CHARGES.getIndex())) {
//                    download.setPackageFee(detail.getCostAmount().intValue());
//                    download.setPackageFeeYuan(detail.getCostAmount().doubleValue()/100);
//                }

//                if(detail.getCostType().equals(OrderCostType.CARRIAGE.getIndex())){
//                    download.setDeliveryFee(detail.getCostAmount().intValue());
//                    download.setDeliveryFeeYuan(detail.getCostAmount().doubleValue()/100);
//                }
            }

            Integer activyPrice = 0;
            String activeItem = "";
            for (OrderSettlementResp dto : orderDto.getOrderSettlementDetailList()) {
                activyPrice += dto.getSettlementAmount().intValue();
//                activeItem += OrderSettlementType.getByIndex(dto.getSettlementType()).getName();
            }
            download.setAcitviyCost(activyPrice);
            download.setAcitviyCostYuan(activyPrice.doubleValue() / 100);
            download.setAcivityItems(activeItem);

//            download.setGmtCreate(orderDto.getCreateTime());
//            download.setGmtPay(orderDto.getPayTime());

            download.setPayNo(orderDto.getPayRequestNo());
//            download.setPayStatus(PayStatus.getByIndex(orderDto.getPayState()).getName());

            for (DeliveryContactInfoResp info : orderDto.getDeliveryContactInfoList()) {
//                if(RelateObjectType.ORDER_ADDRESS.equals(info.getRelateObjectType())){
//                    download.setPhone(info.getMobile());
//                    download.setAddress(info.getAddressDetail());
//                }

//                if (RelateObjectType.COURIER.equals(info.getRelateObjectType())){
//                    download.setRiderName(info.getContactsName());
//                    download.setRiderPhone(info.getMobile());
//                }
            }

            download.setExpress(orderDto.getExpressChannelName());
            download.setDeliveryId(orderDto.getExpressNo());
            downloads.add(download);
        });
        return downloads;
    }
}
