package cn.freemud.order.entity;

import lombok.Data;

import javax.persistence.*;
import java.util.Date;

@Data
@Table(name = "open_platform_parntner_report_detail")
public class OpenPlatformPartnerReportDetail {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;


    /**
     * 开个店商户号
     */
    @Column(name = "partner_id")
    private String partnerId;

    /**
     * 品牌名称
     */
    @Column(name = "brand_name")
    private String brandName;

    /**
     * 门店编号
     */
    @Column(name = "store_id")
    private String storeId;

    /**
     * 门店名称
     */
    @Column(name = "store_name")
    private String storeName;

    /**
     * 上报类型，1:预支付，2：支付完成
     */
    @Column(name = "report_type")
    private Byte reportType;

    /**
     * 上报状态，0:失败，1：成功
     */
    @Column(name = "status")
    private Byte status;

    /**
     * 订单编号
     */
    @Column(name = "order_id")
    private String orderId;

    /**
     * 交易流水号
     */
    @Column(name = "deal_no")
    private String dealNo;


    /**
     * 第三方交易流水号
     */
    @Column(name = "third_deal_no")
    private String thirdDealNo;


    /**
     * 微信订单id
     */
    @Column(name = "wx_order_id")
    private String wxOrderId;


    /**
     * 微信订单id
     */
    @Column(name = "pay_amount")
    private Integer payAmount;


    /**
     * 商户小程序id
     */
    @Column(name = "subAppid")
    private String subAppid;

    /**
     * 支付渠道商户号
     */
    @Column(name = "sub_mchid")
    private String subMchid;


    /**
     * 创建时间
     */
    @Column(name = "gmt_created")
    private Date gmtCreated;

    /**
     * 修改时间
     */
    @Column(name = "gmt_updated")
    private Date gmtModified;
}