package cn.freemud.service.thirdparty;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.pos.PosBaseRequestDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.5.1
 * @Title: PosClient
 * @Package cn.freemud.service.thirdparty
 * @Description: 简单描述下这个类是做什么用的
 * @author: hang.chai
 * @date: 2018/12/13 15:27
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

@FeignClient(name = "POS-BACKEND-SERVICE",url="${saas.posbackend.feign.url}")
@RequestMapping(produces = {"application/json;charset=UTF-8"})
public interface PosClient {

    /**
     * 配送
     */
    @PostMapping("/order/order/Send")
    BaseResponse posSend(@RequestBody PosBaseRequestDto requestDto);

    /**
     * 完成
     */
    @PostMapping("/order/order/Affirm")
    BaseResponse posAffirm(@RequestBody PosBaseRequestDto requestDto);

    /**
     * 骑手接单推送POS服务
     */
    @PostMapping("/order/delivery/riderStatus")
    BaseResponse deliveryRiderStatus(@RequestBody PosBaseRequestDto request);
}
