package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.5.1
 * @Title: OrderStatusTrackingInfoDto
 * @Package cn.freemud.entities.dto
 * @Description: 简单描述下这个类是做什么用的
 * @author: hang.chai
 * @date: 2018/12/24 10:59
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class OrderStatusTrackingInfoDto {

    private List<OrderStatusTrackingInfo> data;
    private Integer errcode;
    private String errmsg;

    @NoArgsConstructor
    @Data
    public static class OrderStatusTrackingInfo {

        private String desc;
        /**
         * 订单状态
         */
        private Integer status;
        /**
         * 订单状态描述
         */
        private String statusName;
        /**
         * 订单状态操作时间
         */
        private String statusTime;
    }
}
