/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartInfoRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/21 21:03
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.NotEmpty;

import javax.validation.constraints.NotNull;
import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Data
@Builder
@ApiModel(description = "查询&结算购物车请求参数")
public class ShoppingCartInfoRequestVo extends BaseRequestVo {

    @NotEmpty(message = "sessionId不能为空")
    @ApiModelProperty(name = "sessionId", required = true)
    private String sessionId;

    private String version;
    /**
     * 购物车版本号（围餐）
     */
    @ApiModelProperty(name = "围餐版本号（围餐版本使用）")
    private Integer carVer;

    @NotEmpty(message = "appId不能为空")
    @ApiModelProperty(value = "appId", required = true)
    private String appId;
    /**
     * 是否为结算页
     *  1：结算页 0：点餐页
     * 结算页会查询用户优惠券，点餐页不会查询用户优惠券
     */
    @ApiModelProperty(value = "是否为结算页：1=结算页，0=点餐页（结算页会查询用户优惠券，点餐页不会查询用户优惠券）")
    private Integer flag;
    /**
     * 优惠券code
     */
    @ApiModelProperty(value = "优惠券code")
    private String couponCode;
    /**
     * 优惠券对应的活动号
     */
    @ApiModelProperty(value = "优惠券对应的活动号")
    private String activityCode;

    /**
     * 到店类型  orderType 传1的时候    如果reachStoreTyp为空转成订单类型4  如果不为空存储4(打包带走)和5（店内就餐）
     */
    @ApiModelProperty(value = "到店类型：4=打包带走，5=店内就餐")
    private Integer reachStoreType;

    /**
     * 加价购商品
     */
    @ApiModelProperty(value = "加价购商品列表")
    private List<SendGoods> sendGoods;
    /**
     * 是否使用用户积分
     * 1=不显示积分
     * 2=显示积分但不扣减
     * 3=显示积分且扣减
     */
    @ApiModelProperty(value = "是否使用用户积分：1=不显示积分，2=显示积分但不扣减，3=显示积分且扣减")
    private Integer useCustomerScore;
    /**
     * svc 卡支付使用
     */
    @ApiModelProperty(value = "svc卡卡号")
    private String cardCode;
    /**
     * 收货地址ID、svc卡支付外卖订单必传
     */
    @ApiModelProperty(value = "收货地址ID，svc卡支付外卖订单必传")
    private String receiveId;
    /**
     * 会员卡信息
     */
    @ApiModelProperty(value = "会员卡信息")
    private BuyMemberCard buyMemberCard;

    /**
     * 业务类型： 0 : 自提 1：外卖 2：微商城
     */
    @ApiModelProperty(value = "业务类型： 0=自提，1=外卖，2=微商城")
    private String menuType ;

    @Data
    @ApiModel(description = "加价购商品描述")
    public final static class SendGoods {
        /**
         * 商品Id
         */
        @NotNull
        @ApiModelProperty(value = "加价购商品ID", required = true)
        private String goodsId;

        @ApiModelProperty(value = "加价购商品原价")
        private Long originalPrice;
        /**
         * 商品数量
         */
        @NotNull
        @ApiModelProperty(value = "加价购商品数量", required = true)
        private Integer qty;
    }

    @Data
    @ApiModel(description = "会员卡信息")
    public final static class BuyMemberCard {
        /**
         * 付费会员卡ID
         */
        @ApiModelProperty(value = "付费会员卡ID")
        private String paidId;
        /**
         * 规则ID
         */
        @ApiModelProperty(value = "规则ID")
        private String ruleId;
    }

}
