/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartUpdateRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/22 10:42
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(description = "查询购物车响应参数")
@Data
public class ShoppingCartGoodsResponseVo  extends ShoppingCartGoodsBaseResponseVo{

    /**
     * 商品额外的属性
     */
    @ApiModelProperty(value = "商品行列表")
    List<CartGoods> products;
    /**
     * 商品总数
     */
    @ApiModelProperty(value = "商品总数")
    private Integer productsCount;
    /**
     * 活动信息
     */
    @ApiModelProperty(value = "活动信息")
    private ActivityTip activityTip;

    /**
     * 原总价
     */
    @ApiModelProperty(value = "原总价,单位：分")
    private Long originalTotalAmount;
    /**
     * 现总价
     */
    @ApiModelProperty(value = "现总价,单位：分")
    private Long totalAmount;
    /**
     * 总折扣价
     */
    @ApiModelProperty(value = "总折扣价,单位：分")
    private Long totalDiscountAmount;
    /**
     * 包装费
     */
    @ApiModelProperty(value = "包装费,单位：分")
    private Long packAmount;

    /**
     * 新包装费（该字段给新版本前端展示，使其好计算）
     */
    @ApiModelProperty(value = "新包装费（该字段给新版本前端展示，使其好计算）,单位：分")
    private Long newPackAmount;

    /**
     * 优惠券折扣
     */
    @ApiModelProperty(value = "优惠券折扣")
    private Long couponDiscount;

    /**
     * 满减折扣
     */
    @ApiModelProperty(value = "满减折扣")
    private Long fullDiscount;
    /**
     * svc卡支付描述
     */
    @ApiModelProperty(value = "svc卡支付描述")
    private String svcDiscountDesc;

    /**
     * 可用优惠券列表
     */
    @ApiModelProperty(value = "可用优惠券列表")
    private ActivityClassifyCouponBean availableCoupon;

    @ApiModelProperty(value = "活动信息")
    private ActivityTip buyOneGetActivity;
    /**
     * 积分抵扣优惠
     */
    @ApiModelProperty(value = "积分抵扣优惠")
    private ShoppingCartCustomerScoreVo customerScoreVo;
    /**
     * 起送费
     */
    @ApiModelProperty(value = "起送费,单位：分")
    private Long freeDeliveryPrice;
    /**
     * 会员卡原价
     */
    @ApiModelProperty(value = "会员卡原价,单位：分")
    private Integer cardOriginalAmount;

    /**
     * 会员卡优惠金额
     */
    @ApiModelProperty(value = "会员卡优惠金额,单位：分")
    private Integer cardDiscountAmount;
}
