package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.hibernate.validator.constraints.NotEmpty;

@Data
public class BaseRequestVo {

    @ApiModelProperty(value = "sessionId")
    private String sessionId;
    /**
     * 商户Id
     */
    @NotEmpty(message = "partnerId不能为空")
    @ApiModelProperty(value = "商户ID", required = true)
    private String partnerId;
    /**
     * 门店Id
     * 商城没有门店id，如果需要门店id必传在业务中进行校验
     */
    //@NotEmpty(message = "shopId不能为空")
    @ApiModelProperty(value = "店铺ID")
    private String shopId;

    /**
     * 下单类型 CreateOrderType 外卖、到店、商城
     */
    @ApiModelProperty(value = "下单类型：1=到店，2=外卖")
    private Integer orderType;

    /**
     * 渠道类型 OrderChannelType
     */
    @ApiModelProperty(value = "渠道类型：saas=saas小程序，img=爱马哥小程序，saasmall=商城")
    private String channelType;
}
