package cn.freemud.entities.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ActivityClassifyCouponBean {
    /**
     * 优惠券总数量
     */
    @ApiModelProperty(value = "优惠券总数量")
    private Integer couponNum;
    /**
     * 可用优惠券信息
     */
    @ApiModelProperty(value = "可用优惠券个数")
    private Integer usableCouponNum;
    @ApiModelProperty(value = "可用优惠券信息")
    private List<ActivityCouponBean> usableCoupons;

    /**
     * 不可用优惠券信息
     */
    @ApiModelProperty(value = "不可用优惠券个数")
    private Integer disableCouponNum;
    @ApiModelProperty(value = "不可用优惠券信息")
    private List<ActivityCouponBean>  disableCoupons;
}
