package cn.freemud.config;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: AppContextAware
 * @Package cn.freemud.log
 * @Description: 简单描述下这个类是做什么用的
 * @author: canlong.wu
 * @date: 2019/5/22 20:43
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
@Component
public class AppContextAware implements ApplicationContextAware {
    private static ApplicationContext context;

    public AppContextAware() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }

    public static String getAppName() {
        return context.getEnvironment().getProperty("spring.application.name");
    }

}
