package cn.freemud.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.entities.vo.encircle.CreateReserveOrderVo;
import cn.freemud.enums.OrderChannelType;
import cn.freemud.enums.ResponseResult;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.service.EncircleOrderService;
import cn.freemud.service.OrderAdapterService;
import cn.freemud.service.Orderservice;
import cn.freemud.utils.ResponseUtil;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.api.assortment.datamanager.enums.IappIdType;
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: OrderAdapterServiceImpl
 * @Description: 订单业务适配
 * @author: qin.zhou
 * @date: 2019/9/818:22
 * @Copyright: ${DATE.YARE} www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class OrderAdapterServiceImpl implements OrderAdapterService {

    @Autowired
    private EncircleOrderService encircleOrderService;
    @Autowired
    private Orderservice orderservice;
    @Autowired
    private AssortmentCustomerInfoManager assortmentCustomerInfoManager;

    @Override
    public BaseResponse createOrderNew(CreateOrderVo createOrderVo) {
        AssortmentCustomerInfoVo assortmentCustomerInfoVo = assortmentCustomerInfoManager.getCustomerInfoByObject(createOrderVo.getSessionId());
        if (assortmentCustomerInfoVo == null || StringUtils.isEmpty(assortmentCustomerInfoVo.getMemberId())) {
            return ResponseUtil.error(ResponseResult.NOT_LOGIN);
        }
        if(IappIdType.WC_XCX.getCode().equals(assortmentCustomerInfoVo.getIappId())){  //i围餐
            BaseResponse baseResponse = null;
            CreateReserveOrderVo createReserveOrderVo = new CreateReserveOrderVo();
            createReserveOrderVo.setCarVer(createOrderVo.getCarVer());
            createReserveOrderVo.setRepastNumber(createOrderVo.getPeopleNumber());
            createReserveOrderVo.setSessionId(createOrderVo.getSessionId());
            createReserveOrderVo.setOrderUpdateVer(createOrderVo.getOrderUpdateVer());
            if(createOrderVo.getOperation() == null) throw new ServiceException(ResponseResult.ORDER_CREATE_OPERATION_ERROR);
            switch (createOrderVo.getOperation()){
                case 2:
                    baseResponse = encircleOrderService.createReserveOrder(createOrderVo);
                    break;
                case 3:
                    baseResponse = encircleOrderService.updateReserveOrder(createReserveOrderVo);
                    break;
                case 4:
                    baseResponse = encircleOrderService.createPrepaymentOrder(createReserveOrderVo);
                    break;
                    default:
                        throw new ServiceException(ResponseResult.ORDER_CREATE_OPERATION_ERROR);
            }
            return baseResponse;
        }
        //原标准点餐程序逻辑处理
        BaseResponse baseResponse = this.checkStandardParamInfo(createOrderVo);
        if(ObjectUtils.notEqual(baseResponse.getCode(),ResponseResult.SUCCESS.getCode())){
            return baseResponse;
        }
        // 扩展字段中存储 sessionKey
        createOrderVo.setSessionKey(assortmentCustomerInfoVo.getSessionKey());
        return orderservice.createOrderNew(createOrderVo);
    }

    /**
     * 标准点餐参数校验
     * @param createOrderVo
     * @return
     */
    private BaseResponse checkStandardParamInfo(CreateOrderVo createOrderVo){
        if(StringUtils.isEmpty(createOrderVo.getSessionId())){
            return ResponseUtil.error(ResponseResult.CREATE_ORDER_CHECK_SESSION_ERROR);
        }
        if(StringUtils.isEmpty(createOrderVo.getShopId())){
            return ResponseUtil.error(ResponseResult.CREATE_ORDER_CHECK_STORE_ERROR);
        }
        if(createOrderVo.getOrderType() == null){
            return ResponseUtil.error(ResponseResult.CREATE_ORDER_CHECK_ORDERTYPE_ERROR);
        }
        return ResponseUtil.success();
    }
}
