/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCartUpdateRequestVo
 * @Package cn.freemud.entities.vo
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/22 10:42
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package com.freemud.sdk.api.assortment.shoppingcart.domain;

import lombok.Data;

import java.util.List;

@Data
public class ShoppingCartGoodsResponseVo {

    /**
     * 商品额外的属性
     */
    List<CartGoods> products;
    /**
     * 商品总数
     */
    private Integer productsCount;
    /**
     * 活动信息
     */
    private ActivityTip activityTip;

    /**
     * 原总价
     */
    private Long originalTotalAmount;
    /**
     * 现总价
     */
    private Long totalAmount;
    /**
     * 总折扣价
     */
    private Long totalDiscountAmount;
    /**
     * 包装费
     */
    private Long packAmount;

    /**
     * 优惠券折扣
     */
    private Long couponDiscount;

    /**
     * 满减折扣
     */
    private Long fullDiscount;

    /**
     * 前端用来提示的信息
     */
    private String toastMsg;
    /**
     * 购物车中商品价格或有效性是否发生变化
     */
    private Boolean changed;

    /**
     * 可用优惠券列表
     */
    private ActivityClassifyCouponBean availableCoupon;

    private ActivityTip buyOneGetActivity;
    /**
     * 购物车是否有非法商品或价格变动
     */
    private CartGoodsStates cartGoodsStates;
}
