package cn.freemud.management.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.base.log.LogTreadLocal;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.entities.dto.response.order.OrderConfirmResponse;
import cn.freemud.management.enums.OperateType;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.service.OrderBaseService;
import cn.freemud.management.service.OrderManagerService;
import cn.freemud.management.util.ResponseUtil;
import com.freemud.application.sdk.api.storecenter.request.StoreInfoRequest;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.application.sdk.api.storecenter.service.StoreCenterService;
import com.freemud.sdk.api.assortment.order.adapter.OrderSdkAdapter;
import com.freemud.sdk.api.assortment.order.request.order.BaseQueryOrderRequest;
import com.freemud.sdk.api.assortment.order.response.order.BaseOrderResponse;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
import javafx.util.Pair;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: rrr
 * @Package cn.freemud.management.service.impl
 * @Description: saas订单履单操作
 * @author: shuhu.hou
 * @date: 2020/3/26 16:01
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class SaasOrderMangerServiceImpl implements OrderManagerService {

    @Autowired
    private OrderSdkAdapter orderSdkAdapter;
    @Autowired
    private OrderCenterSdkService orderCenterSdkService;
    @Autowired
    private OrderDeliveryService orderDeliveryService;
    @Autowired
    private OrderBaseService orderBaseService;
    @Autowired
    private StoreCenterService storeCenterService;


    /**
     * 接单
     * @param request 请求参数
     * @param orderBean 订单实体
     * @return
     */
    @Override
    public BaseResponse<OrderConfirmResponse> orderConfirm(OrderManagerRequest request, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        //订单接单
        BaseQueryOrderRequest orderConfirmRequest = orderSdkAdapter.getOrderConfirmRequest(request.getOperator(), orderBean);
        BaseOrderResponse confirmOrderResponse = orderCenterSdkService.orderConfirmTake(orderConfirmRequest);
        //处理1秒重复接单问题 订单服务接单返回20067重复操作，20018状态机不支持认为接单成功
        if ("20067".equals(confirmOrderResponse.getErrcode().toString()) || "20018".equals(confirmOrderResponse.getErrcode().toString()) || "50002".equals(confirmOrderResponse.getErrcode().toString()) ) {
            return ResponseUtil.success();
        }
        if( ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(),confirmOrderResponse.getErrcode().toString())){
            return ResponseUtil.error(ResponseResult.ORDER_ACCEPT_FAILED);
        }
        //创建配送单
        StoreResponse storeInfo = storeCenterService.getStoreInfo(new StoreInfoRequest(orderBean.getCompanyId(), orderBean.getShopId()),"");
        if (ObjectUtils.notEqual(ResponseResult.SUCCESS.getCode(),storeInfo.getStatusCode().toString()) || storeInfo.getBizVO() == null) {
            return ResponseUtil.error(ResponseResult.STORE_NOT_FOUND);
        }
        Pair<Boolean, String> deliveryResonse = orderDeliveryService.createDelivery(orderBean, storeInfo, request.getOperator());
        if (!deliveryResonse.getKey()){
            return ResponseUtil.error(ResponseResult.ORDER_ACCEPT_FAILED_CREATE_DELIVERY_FAILED);
        }
        // 推送pos消息中心
        orderBaseService.sendMessage(orderBean, OperateType.ORDER_AFFIRM,request.getReason());
        return ResponseUtil.success(new OrderConfirmResponse(storeInfo.getBizVO().getOrderPrintConfig(),orderBean.getGmtExpect()));
    }
}
