package cn.freemud.management.service.impl;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.management.entities.dto.request.order.OrderManagerRequest;
import cn.freemud.management.enums.OrderStatus;
import cn.freemud.management.enums.ResponseResult;
import cn.freemud.management.util.ResponseUtil;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.stereotype.Service;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: OrderVerifyService
 * @Package cn.freemud.management.service.impl
 * @Description:
 * @author: shuhu.hou
 * @date: 2020/3/26 16:04
 * @Copyright: 2020 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class OrderVerifyService {

    /**
     * 接单校验
     * @param orderBean
     * @param request
     * @return
     */
    public BaseResponse orderConfirmTakeVerify(QueryOrdersResponse.DataBean.OrderBean orderBean, OrderManagerRequest request){
        if (orderBean==null){
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR);
        }
        if (!OrderStatus.TAKE_ORDER.getCode().equals(orderBean.getStatus())) {
            return ResponseUtil.error(ResponseResult.ORDER_CANNOT_CONFIRM);
        }
        return commonVerify(orderBean,request);
    }


    private BaseResponse commonVerify(QueryOrdersResponse.DataBean.OrderBean orderBean, OrderManagerRequest request){
        if (ObjectUtils.notEqual(orderBean.getCompanyId(),request.getPartnerId())){
            return ResponseUtil.error(ResponseResult.ORDER_PARTNER_ID_NOT_MATCTH);
        }
        if (ObjectUtils.notEqual(orderBean.getShopId(),request.getStoreId())){
            return ResponseUtil.error(ResponseResult.ORDER_STORE_ID_NOT_MATCTH);
        }
        return ResponseUtil.success();
    }
}
