package cn.freemud.management.service.adapter;

import cn.freemud.management.enums.OrderSource;
import cn.freemud.management.service.OrderManagerService;
import cn.freemud.management.service.impl.SaasOrderMangerServiceImpl;
import cn.freemud.management.service.impl.TakeawayOrderMangerServiceImpl;
import com.freemud.sdk.api.assortment.order.response.order.QueryOrdersResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

/**
 * 根据渠道获取渠道操作实体类
 */
@Service
public class OrderBeanFactory {

    @Autowired
    private ApplicationContext applicationContext;

    public OrderManagerService getOrderManagerService(QueryOrdersResponse.DataBean.OrderBean orderBean){
        String source = orderBean.getSource();
        if (OrderSource.BDWM.getSource().equals(source) || OrderSource.JDWM.getSource().equals(source)
                || OrderSource.MTWM.getSource().equals(source) || OrderSource.ELEME.getSource().equals(source)){
            return applicationContext.getBean(TakeawayOrderMangerServiceImpl.class);
        }
        return applicationContext.getBean(SaasOrderMangerServiceImpl.class);
    }
}
