/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderServiceImpl
 * @Package cn.freemud.service.impl
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/17 20:55
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service.impl;

import cn.freemud.adapter.*;
import cn.freemud.amp.body.MessagePushNewMqBody;
import cn.freemud.amqp.Header;
import cn.freemud.amqp.MQAction;
import cn.freemud.amqp.MQMessage;
import cn.freemud.amqp.MQService;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.base.log.LogTreadLocal;
import cn.freemud.base.util.DateUtil;
import cn.freemud.constant.OrderRefundConstant;
import cn.freemud.constant.RedisKeyConstant;
import cn.freemud.constant.ResponseCodeConstant;
import cn.freemud.entities.dto.*;
import cn.freemud.entities.dto.PayAccessResponse;
import cn.freemud.entities.dto.QueryOrdersResponseDto.DataBean.OrderBean;
import cn.freemud.entities.dto.activity.PayGiftCheckAndJoinResponseDto;
import cn.freemud.entities.dto.activity.PayGitCheckAndJoinRequestDto;
import cn.freemud.entities.dto.product.AttributeValue;
import cn.freemud.entities.dto.product.ProductAttributeGroup;
import cn.freemud.entities.dto.shoppingCart.NewShoppingCartClearDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.*;
import cn.freemud.interceptor.ServiceException;
import cn.freemud.redis.RedisCache;
import cn.freemud.service.BuriedPointService;
import cn.freemud.service.CouponActivityService;
import cn.freemud.service.Orderservice;
import cn.freemud.service.process.WechatPush.WechatPushProcessor;
import cn.freemud.service.thirdparty.*;
import cn.freemud.utils.*;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentCloudPrinter;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformPartnerConfig;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformWxapp;
import com.freemud.api.assortment.datamanager.entity.db.AssortmentOpenPlatformWxappAuthorizer;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.api.assortment.datamanager.manager.AssortmentCloudPrinterManager;
import com.freemud.api.assortment.datamanager.enums.IappIdType;
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformPartnerConfigManager;
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformWxappAuthorizerManager;
import com.freemud.api.assortment.datamanager.manager.AssortmentOpenPlatformWxappManager;
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager;
import com.freemud.api.assortment.datamanager.meal.MealCacheManager;
import com.freemud.application.sdk.api.constant.ResponseConstant;
import com.freemud.application.sdk.api.constant.ResponseResultEnum;
import com.freemud.application.sdk.api.deliverycenter.response.DeliveryInfoDto;
import com.freemud.application.sdk.api.deliverycenter.response.DeliveryResponseDto;
import com.freemud.application.sdk.api.deliverycenter.service.DeliveryService;
import com.freemud.application.sdk.api.log.ApiLog;
import com.freemud.application.sdk.api.log.ErrorLog;
import com.freemud.application.sdk.api.log.LogThreadLocal;
import com.freemud.application.sdk.api.ordercenter.enums.AfterSalesType;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import com.freemud.application.sdk.api.paymentcenter.client.request.CodePayRequest;
import com.freemud.application.sdk.api.paymentcenter.client.request.SVCCardAmountRequest;
import com.freemud.application.sdk.api.paymentcenter.client.response.CodePayResponse;
import com.freemud.application.sdk.api.paymentcenter.client.response.SVCCardAmountResponse;
import com.freemud.application.sdk.api.paymentcenter.client.service.PaymentNewService;
import com.freemud.application.sdk.api.storecenter.request.GetListByCodesRequest;
import com.freemud.application.sdk.api.storecenter.request.StoreInfoRequest;
import com.freemud.application.sdk.api.storecenter.response.GetListByCodesResponse;
import com.freemud.application.sdk.api.storecenter.response.StoreResponse;
import com.freemud.application.sdk.api.storecenter.service.StoreCenterService;
import com.freemud.application.sdk.api.structure.request.PushMessageNoticeDto;
import com.freemud.application.sdk.api.structure.service.MessageCenterClient;
import com.freemud.sdk.api.assortment.message.config.MessageOfficialRefundPushMqConfig;
import com.freemud.sdk.api.assortment.message.entity.MpTemplateMsg;
import com.freemud.sdk.api.assortment.message.entity.TemplateKeyword;
import com.freemud.sdk.api.assortment.message.enums.MessageEventType;
import com.freemud.sdk.api.assortment.message.request.MessagePushOrderTemplateRequest;
import com.freemud.sdk.api.assortment.message.request.MessageTemplateRequest;
import com.freemud.sdk.api.assortment.message.service.IMessageTemplatePushService;
import com.freemud.sdk.api.assortment.order.adapter.ActivitySdkAdapter;
import com.freemud.sdk.api.assortment.order.entities.OrderExtInfoDTO;
import com.freemud.sdk.api.assortment.order.request.order.*;
import com.freemud.sdk.api.assortment.order.response.order.*;
import com.freemud.sdk.api.assortment.order.response.payment.OrderPayResponse;
import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
import com.freemud.sdk.api.assortment.orderdistributor.entity.dto.PaymentMqMessageDto;
import com.freemud.sdk.api.assortment.orderdistributor.service.PaymentQueueService;
import com.freemud.sdk.api.assortment.payment.request.UnifiedOrderRequest;
import com.freemud.sdk.api.assortment.payment.response.OrderRefundResponse;
import com.freemud.sdk.api.assortment.payment.response.UnifiedOrderResponse;
import com.freemud.sdk.api.assortment.payment.service.StandardPaymentService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service
@Slf4j
public class OrderServiceImpl implements Orderservice {

    private final Integer RESPONSE_SUCCESS_CODE = 100;

    private static Gson gson = new Gson();

    @Value("${saas.reverseNotifyiDcUrl}")
    private String reverseNotifyiDcUrl;
    @Value("${program.backorders_change_order_status_consumer_queue}")
    private String backOrdersChangeOrderStatusConsumerQueue;
    @Value("${program.backorders_notify_activity_exchange}")
    private String backOrdersNotifyActivityExchange;
    @Value("${mq.queue.cloud_print_queue}")
    private String cloudPrintQueue;
    @Value("${mq.cloud_print_exchange}")
    private String cloud_print_exchange;

    @Autowired
    private AssortmentCloudPrinterManager cloudPrinterManager;
    @Autowired
    private OrderCommonService orderCommonService;
    @Autowired
    private FMAssistantCloudPrintClient fmAssistantCloudPrintClient;
    @Autowired
    private MessageCenterClient messageNoticeClient;
    @Autowired
    private PromotionActivityClient promotionActivityClient;
    @Autowired
    private ShoppingCartClient shoppingCartClient;
    @Autowired
    private CustomerApplicationClient customerApplicationClient;
    @Autowired
    private ItemServiceImpl itemService;
    @Autowired
    private BuriedPointService buriedPointService;
    @Autowired
    private CouponActivityService couponActivityService;
    @Autowired
    private MessageNoticeAdapter messageNoticeAdapter;
    @Autowired
    private OrderAdapter orderAdapter;
    @Autowired
    private ActivityAdapter activityAdapter;
    @Autowired
    private CouponAdapter couponAdapter;
    @Autowired
    private ActivitySdkAdapter activitySdkAdapter;
    @Autowired
    private MealCacheManager mealCacheManager;
    //聚合订单服务
    @Autowired
    private OrderCenterSdkService orderCenterSdkService;
    @Autowired
    private StandardPaymentService standardPaymentService;
    //门店SDK
    @Autowired
    private StoreCenterService storeCenterService;
    @Autowired
    private DeliveryService deliveryService;
    @Autowired
    private MQService mqService;
    @Autowired
    @Qualifier("messageTemplatePushOrderService")
    private IMessageTemplatePushService<MessagePushOrderTemplateRequest> messageTemplatePushService;
    @Autowired
    private AssortmentOpenPlatformWxappManager openPlatformWxappManager;
    @Autowired
    private AssortmentOpenPlatformPartnerConfigManager openPlatformPartnerConfigManager;
    @Autowired
    private AssortmentCustomerInfoManager customerInfoManager;
    @Autowired
    private WechatPushProcessor wechatPushProcessor;
    @Autowired
    private CheckOrder checkOrder;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private PaymentQueueService paymentQueueService;
    @Autowired
    private PaymentNewService paymentNewService;
    @Autowired
    private ActivityApplicationClient activityApplicationClient;
    @Autowired
    private MallOrderServiceImpl mallOrderService;
    @Autowired
    private AssortmentOpenPlatformWxappAuthorizerManager wxappAuthorizerManager;



    @Override
    public BaseResponse checkBeforeCreateOrder(CheckBeforeCreateOrderRequestVo requestVo) {
        String trackingNo = LogTreadLocal.getTrackingNo();
        AssortmentCustomerInfoVo userInfo = customerInfoManager.getCustomerInfoByObject(requestVo.getSessionId());
        if (userInfo == null || StringUtils.isEmpty(userInfo.getMemberId())) {
            return ResponseUtil.error(ResponseResult.NOT_LOGIN);
        }
        StoreResponse storeResponse = checkOrder.getStoreInfo(requestVo.getPartnerId(), requestVo.getShopId(), trackingNo);
        if (storeResponse == null || storeResponse.getBizVO() == null) {
            return ResponseUtil.error(ResponseResult.STORE_NOT_FOUND);
        }
        StoreResponse.BizVO storeInfo = storeResponse.getBizVO();
        CheckBeforeCreateOrderResponseVo responseVo = new CheckBeforeCreateOrderResponseVo();
        Integer maxOrderQuantity = storeInfo.getMaxOrderQuantity();
        if (maxOrderQuantity == null) {
            maxOrderQuantity = 100;
        }
        // 调用文顺接口获取队列长度
        BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
        baseQueryOrderRequest.setPartnerId(requestVo.getPartnerId());
        baseQueryOrderRequest.setShopId(requestVo.getShopId());
        baseQueryOrderRequest.setTrackingNo(trackingNo);
        BaseOrderResponse queryStoreOrderQuantity = orderCenterSdkService.queryStoreOrderQuantity(baseQueryOrderRequest);
        QueryStoreOrderQuantityResponseDto responseDto = new QueryStoreOrderQuantityResponseDto();
        BeanUtil.convertBean(queryStoreOrderQuantity, responseDto);

        if (!RESPONSE_SUCCESS_CODE.equals(responseDto.getErrcode())) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERY_QUANTITYR_ERROR);
        }
        Integer lineNumber = Integer.parseInt(responseDto.getData());
        // 判断最大接单量和队列长度的关系
        if (maxOrderQuantity > lineNumber) {
            responseVo.setWhetherMaxOrderQuantity(false);
            responseVo.setBeforeNumber(lineNumber);
            responseVo.setWarningInfo("");
        } else {
            responseVo.setWhetherMaxOrderQuantity(true);
            String beforeMessage = "您前面排队超过";
            String afterMessage = "单，出餐时间稍长，是否继续提交？";
            responseVo.setBeforeNumber(lineNumber);
            responseVo.setWarningInfo(beforeMessage + lineNumber + afterMessage);
        }
        return ResponseUtil.success(responseVo);
    }

    @Override
    public BaseResponse createOrderNew(CreateOrderVo createOrderVo) {
        String trackingNo = LogThreadLocal.getTrackingNo();
        // 查询用户信息、校验svc卡,余额购物车校验
        UserLoginInfoDto userLoginInfoDto = checkOrder.checkOrderByMember(createOrderVo, trackingNo);
        // 查询门店信息 营业时间、营业状态，服务器当前时间在营业时间内 点餐桌号
        StoreResponse.BizVO storeResponseDto = checkOrder.checkOrderByStore(createOrderVo, trackingNo);
        // 查询购物车（内部校验券点餐方式，券是否可用） 校验当前订单类型的下单参数
        ShoppingCartGoodsDto shoppingCartGoodsDto = checkOrder.getShoppingCartGoodsDto(createOrderVo);
        // 查询小程序自提外卖配置信息 校验当前订单类型的下单参数 校验外卖是否满足起送条件
        Integer pushOrderTime = checkOrder.checkOrderByOrderType(createOrderVo, userLoginInfoDto, storeResponseDto,shoppingCartGoodsDto.getTotalAmount(), trackingNo);
        //1.5.4版本，商品库存校验与扣库存
        //List<String> stockProductIds = checkOrder.getStockProductIdList(createOrderVo, shoppingCartGoodsDto);
        OrderExtInfoDTO extInfo = getExtInfo(userLoginInfoDto, storeResponseDto, pushOrderTime, createOrderVo);

        //1.9.2套餐需求同步优化创建订单代码
        return this.sdkCreateOrder(createOrderVo, storeResponseDto, shoppingCartGoodsDto, userLoginInfoDto, extInfo);
    }

    /**
     * 获取预支付成功，将信息放入死心队列，当支付成功没有回掉的时候处理
     *
     * @param partnerId
     * @param storeId
     * @param fmId
     * @param orderId
     */
    public void putDelMq(String partnerId, String storeId, String fmId, String orderId) {
        PaymentMqMessageDto dto = new PaymentMqMessageDto();
        try {
            dto.setFmId(fmId);
            dto.setOrderId(orderId);
            dto.setPartnerId(partnerId);
            dto.setStoreId(storeId);
            dto.setTrackingNo(LogThreadLocal.getTrackingNo());
            paymentQueueService.paymentCallback(dto);
        } catch (Exception e) {
            log.info("paymentQueueService.paymentCallback" + dto + " error" + e);
        }

    }

    @Override
    public String paySuccessCallback(PaysuccessNoticeMessage message) {
        ConfirmOrderDto confirmOrderDto = orderAdapter.convent2ConfirmOrderDto(message);
        //首先判断当前订单号是否为围餐，围餐则需要截取掉订单最后一位数字
        String orderId = redisCache.getValue(RedisCacheEnum.ORDER_CACHE_WEICAN_TRANSID_INFO.getCode() + confirmOrderDto.getOrderId());
        if (StringUtils.isNotBlank(orderId)) {
            confirmOrderDto.setOrderId(orderId);
            ApiLog.info("围餐订单回调==>orderId:{},transId:{}", confirmOrderDto.getOrderId(), orderId);
        }
        Map<String, OrderBean> orderBeans = getOrderBeanByOrderId(confirmOrderDto.getOrderId());
        if (MapUtils.isEmpty(orderBeans)) {
            ErrorLog.printErrorLog("paySuccessCallback_queryOrderById_faild", "paySuccessCallback", message, new Exception());
            return gson.toJson(message);
        }
        OrderBean orderBean = orderBeans.get(OrderBeanType.SAASORDER.getCode());
        if ("meals".equals(orderBean.getSource())) { //围餐
            message.setTrans_id(confirmOrderDto.getOrderId());
            return orderCommonService.paySuccessCallback(message);
        }
        // 商城订单处理
        if(OrderSourceType.MALL.getCode().equals(orderBean.getSource())) {
            return mallOrderService.paySuccessCallback(message, confirmOrderDto, orderBeans);
        }
        String oid = StringUtils.isNotEmpty(orderBean.getParentCode()) && !"0".equals(orderBean.getParentCode()) ? orderBean.getParentCode() : orderBean.getOid();
        String partnerId = orderBean.getCompanyId();
        String userId = orderBean.getUserId();
        String storeId = orderBean.getShopId();
        orderBean.setPayVoucher(message.getOut_trade_no());
        //编辑订单信息，获取openid，用于退款
        String extInfo = orderBean.getExtInfo();
        OrderExtInfoDto orderExtInfoDto = null;
        String wxappid = "";
        String sessionId = "";
        String openid = "";
        String ruleId = "";
        if (StringUtils.isNotBlank(extInfo)) {
            orderExtInfoDto = gson.fromJson(extInfo, OrderExtInfoDto.class);
            if (orderExtInfoDto != null && StringUtils.isNotBlank(orderExtInfoDto.getOpenid())) {
                openid = orderExtInfoDto.getOpenid();
                wxappid = orderExtInfoDto.getAppid();
                sessionId = orderExtInfoDto.getSessionId();
                ruleId = orderExtInfoDto.getRuleId();
            }
        }

        // 如果订单状态不是未支付，返回信息
        if (!PayStatus.NOT_PAY.getCode().equals(orderBean.getPayStatus()) || !OrderStatus.WAIT_PAY.getCode().equals(orderBean.getStatus())) {
            return sendPaySuccessNoticeMessage();
        }
        // 订单失败后 发消息重试 待实现
        String takeCode;
        String daySeq;
        PayAccessResponse payAccessResponse;
        ConfirmOrderRequest var1 = LightApplicationConvertToAssortmentSdkAdapter.confirmOrderDtoConvertToConfirmOrderRequest(confirmOrderDto, orderBeans.get(OrderBeanType.MERMBERORDER.getCode()));
        var1.setPartnerId(partnerId);
        var1.setStoreId(storeId);
        var1.setOrderType(orderBean.getType());
        var1.setProductOrderCode(orderBean.getOid());
        var1.setOperator(orderBean.getUserName());

        // 订单支付成功
        com.freemud.sdk.api.assortment.order.response.order.PayAccessResponse payAccessRes = orderCenterSdkService.payAccess(var1);
        String string2 = JSONObject.toJSONString(payAccessRes);
        JSONObject jsonObject2 = JSONObject.parseObject(string2);
        payAccessResponse = jsonObject2.toJavaObject(PayAccessResponse.class);
        // 添加幂等处理，若订单是已支付成功状态，直接返回成功
        if (!RESPONSE_SUCCESS_CODE.equals(payAccessResponse.getErrcode())) {
            OrderBean saasOrder = getOrderBeanByOrderId(confirmOrderDto.getOrderId()).get(OrderBeanType.SAASORDER.getCode());
            if (saasOrder != null && (!PayStatus.NOT_PAY.getCode().equals(saasOrder.getPayStatus()) || !OrderStatus.WAIT_PAY.getCode().equals(saasOrder.getStatus()))) {
                return sendPaySuccessNoticeMessage();
            }
            LogUtil.error("paySuccessCallback_payAccess_faild", gson.toJson(confirmOrderDto), gson.toJson(payAccessResponse));
            //orderRefund(orderBean, "订单异常退款", openid, oid);
            return gson.toJson(message);
        }
        // TODO 订单序号替换取餐码显示
        takeCode = payAccessResponse.getData().getTakeCode();
        daySeq = payAccessResponse.getData().getDaySeq();

        //核销优惠券
        List<OrderBean.AccountBean> accountList = orderBean.getAccountList();
        if (CollectionUtils.isNotEmpty(accountList) && CollectionUtils.isNotEmpty(orderBean.getProductList())) {
            for (OrderBean.AccountBean accountBean : accountList) {
                List<CouponCodeVerificationProductDto> products = new ArrayList<>();
                //商品券核销核销参数
                if (OrderAccountType.PRODUCT_COUPON.getCode().equals(accountBean.getType())) {
                    for (int i = 0; i < orderBean.getProductList().size(); i++) {
                        OrderBean.ProductBean productBean = orderBean.getProductList().get(i);
                        String pid = StringUtils.isNotBlank(productBean.getSpecification()) ? productBean.getSpecification() : productBean.getProductId();
                        if (!org.springframework.util.CollectionUtils.isEmpty(orderBean.getProductList().get(i).getDiscountList())) {
                            List<OrderBean.ProductBean.ProductDiscount> discounts = orderBean.getProductList().get(i).getDiscountList().stream().
                                    filter(productDiscount -> productDiscount.getDiscountId().equals(accountBean.getAccountId())).collect(Collectors.toList());
                            for (OrderBean.ProductBean.ProductDiscount productDiscount : discounts) {
                                if (productDiscount.getDiscountType() == null || productDiscount.getDiscountType() == 0) {
                                    continue;
                                }
                                CouponCodeVerificationProductDto couponCodeVerificationProductDto = new CouponCodeVerificationProductDto();
                                couponCodeVerificationProductDto.setPID(pid);
                                couponCodeVerificationProductDto.setConsume_num(productDiscount.getDiscountQty());
                                couponCodeVerificationProductDto.setSeq(i + 1);
                                products.add(couponCodeVerificationProductDto);
                            }
                        }
                    }
                }

                Integer orderType = orderBean.getType();
                ActivityChannelEnum activityChannelEnum = PropertyConvertUtil.orderTypeEnumConvert2ActivityChannel(orderType);
                if (activityChannelEnum == null) {
                    activityChannelEnum = ActivityChannelEnum.pickup;
                }

                if (OrderAccountType.COUPON.getCode().equals(accountBean.getType())
                        || OrderAccountType.PRODUCT_COUPON.getCode().equals(accountBean.getType())
                        || OrderAccountType.DISCOUNT_COUPON.getCode().equals(accountBean.getType())) {
                    BaseResponse response = couponActivityService.verificationCoupon(activityChannelEnum, accountBean.getAccountId(),
                            orderBean.getOid(), partnerId, storeId, userId, products, accountBean.getPrice().intValue());
                    // 如果核销失败，退款
                    if (!ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(response.getCode())) {
                        orderRefund(orderBean, "订单异常退款", openid, oid);
                        return gson.toJson(message);
                    }
                }
            }
        }
        //TODO 编辑订单额外信息，保存外卖开始时间和外卖结束时间，保存支付信息
        if (orderExtInfoDto != null) {
            orderExtInfoDto.setPayDate(DateUtil.convert2String(new Date(), "yyyy-MM-dd HH:mm:ss"));
            orderExtInfoDto.setPayTransId(message.getOut_trade_no());
            OrderEditDto orderEditDto = new OrderEditDto(orderBean.getOid(), gson.toJson(orderExtInfoDto));
            OrderEditRequest orderEditRequest = new OrderEditRequest(orderEditDto.getOrderId(), orderEditDto.getExtInfo());
            orderEditRequest.setTrackingNo(LogTreadLocal.getTrackingNo());
            orderCenterSdkService.orderEdit(orderEditRequest);
        }
        //TODO 清空购物车
        NewShoppingCartClearDto newShoppingCartClearDto = new NewShoppingCartClearDto();
        newShoppingCartClearDto.setPartnerId(partnerId);
        newShoppingCartClearDto.setShopId(storeId);
        newShoppingCartClearDto.setUserId(userId);
        newShoppingCartClearDto.setAppId(wxappid);
        newShoppingCartClearDto.setSessionId(sessionId);
        newShoppingCartClearDto.setOperationType(1);
        shoppingCartClient.clearShoppingCart(newShoppingCartClearDto);
        if (StringUtils.isNotBlank(daySeq) && orderExtInfoDto != null && !OrderType.TAKE_OUT.getCode().equals(orderBean.getType())) {
            String storeAddress = StringUtils.isNotBlank(orderBean.getAddress()) ? orderBean.getAddress() : "";
            orderBean.setAddress(storeAddress);
            orderBean.setOtherCode(takeCode);
            //发送支付成功模板消息
            this.sendPaySuccessMessage(orderBean);
        }
        // 有云打印机 打印小票，杯贴
        //GetStoreCloudPrintResponseDto storeCloudPrint;
        try {
            //storeCloudPrint = fmCloudPrintClient.getStoreCloudPrint(new GetStoreCloudPrintDto(partnerId, storeId));
            List<AssortmentCloudPrinter> storePrinters = cloudPrinterManager.getStorePrinters(partnerId, storeId);
            if (null != storePrinters && storePrinters.size() > 0) {
                boolean printerStatus = false;
                for (AssortmentCloudPrinter cloudPrinter : storePrinters) {
                    if (null != cloudPrinter.getStatus() && cloudPrinter.getStatus() == 1) {
                        printerStatus = true;
                    }
                }
                //在线打印
                if (printerStatus) {
                    OrderPrintDto orderPrintDto = orderAdapter.convert2OrderPrintDto(orderBean);
                    orderPrintDto.setDaySeq(daySeq);
                    orderPrintDto.setOtherCode(takeCode);
                    asynchronousPrint(orderPrintDto);
                }
            }
        } catch (Exception e) {
            LogUtil.error("cloudPrint_error", null, null, e);
        }
        //TODO 埋点支付行为
        BuriedPointPaymentRequestDto requestDto = new BuriedPointPaymentRequestDto();
        requestDto.setStoreId(storeId);
        requestDto.setPartnerId(partnerId);
        requestDto.setWxAppId(wxappid);
        requestDto.setSessionId(sessionId);
        requestDto.setOpenId(orderExtInfoDto != null ? orderExtInfoDto.getOpenid() : "");
        buriedPointService.BuriedPointPayment(requestDto, orderBean);

        // 推荐优惠插件用户支付完成数据上报
        if (message.getTotal_fee() != 0) {
            orderBean.setStatus(OrderStatus.TAKE_ORDER.getCode());
            wechatPushProcessor.statusOrderPay(orderBean, sessionId, message.getPaid_no(), message.getOut_trade_no()
                    , message.getEndTransId(), message.getPlatformMchId(), message.getTerminalId());
        }

        // 开通会员卡
        if (StringUtils.isNotBlank(ruleId)) {
            this.activateMemberCard(partnerId, ruleId, oid, userId);
        }
        //支付回掉成功标记
        redisCache.save(RedisKeyConstant.KGD_PAYMENT_CALLBACK_FMID + message.getOut_trade_no(), message.getOut_trade_no(), 10L, TimeUnit.MINUTES);
        return sendPaySuccessNoticeMessage();
    }

    private Map<String, OrderBean> getOrderBeanByOrderId(String orderId) {
        // 订单查询：若结果集只有一个orderBean，则为普通订单，否则为会员卡订单（父子订单）
        Map<String, OrderBean> result = new HashMap<>();
        QueryRelationOrderByIdResponseDto queryOrderByIdResponseDto = getQueryRelationOrderByIdResponseDto(orderId);
        if (CollectionUtils.isEmpty(queryOrderByIdResponseDto.getData())) {
            return result;
        }
        if (1 == queryOrderByIdResponseDto.getData().size()) {
            result.put(OrderBeanType.SAASORDER.getCode(), queryOrderByIdResponseDto.getData().get(0));
        } else {
            List<OrderBean> saasOrderBeans = queryOrderByIdResponseDto.getData().stream().filter(order -> order.getBizType().equals(1)).collect(Collectors.toList());
            List<OrderBean> memberOrderBeans = queryOrderByIdResponseDto.getData().stream().filter(order -> order.getBizType().equals(3) && !order.isParent()).collect(Collectors.toList());
            List<OrderBean> fatherOrderBeans = queryOrderByIdResponseDto.getData().stream().filter(order -> order.getBizType().equals(2) && order.isParent()).collect(Collectors.toList());
            result.put(OrderBeanType.SAASORDER.getCode(), CollectionUtils.isNotEmpty(saasOrderBeans) ? saasOrderBeans.get(0) : null);
            result.put(OrderBeanType.MERMBERORDER.getCode(), CollectionUtils.isNotEmpty(memberOrderBeans) ? memberOrderBeans.get(0) : null);
            result.put(OrderBeanType.FATHERORDER.getCode(), CollectionUtils.isNotEmpty(fatherOrderBeans) ? fatherOrderBeans.get(0) : null);
        }
        return result;
    }

    /**
     * 开通会员卡
     *
     * @param partnerId 商户号
     * @param ruleId    会员规则ID
     * @param oid       订单号
     * @param userId    用户ID
     */
    private void activateMemberCard(String partnerId, String ruleId, String oid, String userId) {
        PurchasePaidRequestDto purchasePaidRequestDto = new PurchasePaidRequestDto();
        purchasePaidRequestDto.setPartnerId(partnerId);
        purchasePaidRequestDto.setOperatorType(0);
        purchasePaidRequestDto.setRuleId(ruleId);
        purchasePaidRequestDto.setOrderId(oid);
        purchasePaidRequestDto.setMemberId(userId);
        // 尝试三次开通会员卡，中途成功则跳出
        int count = 3;
        for (int i = 1; i <= count; i++) {
            BaseResponse baseResponse = customerApplicationClient.purchasePaid(purchasePaidRequestDto);
            // 不以响应码为判断是否开通会员卡成功的标准
            if (baseResponse != null && "SUCCESS".equals(baseResponse.getResult())) {
                break;
            }
            // 尝试开通会员卡失败三次
            if (i >= count) {
                LogUtil.error("尝试开通会员卡失败" + count + "次", JSON.toJSONString(purchasePaidRequestDto), JSON.toJSONString(baseResponse));
            }
        }
    }

    @Override
    public String newPaySuccessCallback(NewPaysuccessNoticeMessage newMessage) {
        PaysuccessNoticeMessage message = new PaysuccessNoticeMessage();
        message.setResult_code(StringUtils.isBlank(newMessage.getResultCode()) ? 0 : Integer.valueOf(newMessage.getResultCode()));
        message.setOut_trade_no(StringUtils.isBlank(newMessage.getTransactionCode()) ? "" : newMessage.getTransactionCode());
        message.setTrans_id(StringUtils.isBlank(newMessage.getTransId()) ? "" : newMessage.getTransId());
        message.setTotal_fee(newMessage.getTotalAmount() == null ? 0 : newMessage.getTotalAmount());
        message.setOpenid(StringUtils.isBlank(newMessage.getOpenId()) ? "" : newMessage.getOpenId());
        message.setPlatform_coupon(newMessage.getPlatformCoupon() == null ? 0 : newMessage.getPlatformCoupon());
        message.setMerchant_coupon(newMessage.getPlatformCoupon() == null ? 0 : newMessage.getPlatformCoupon());
        message.setPaid_no(newMessage.getThirdPartTradeNo());
        message.setEndTransId(newMessage.getEndTransId());
        message.setPlatformMchId(newMessage.getPlatformMchId());
        message.setTerminalId(newMessage.getAppId());
        message.setRuleId(newMessage.getRuleId());
        String res = paySuccessCallback(message);
        JSONObject jsonObject = JSONObject.parseObject(res);
        if (jsonObject.containsKey("code")) {
            Integer code = (Integer) jsonObject.get("code");
            if (Objects.equals(ResponseCodeConstant.RESPONSE_SUCCESS_0, code)) {
                //  新版支付成功的情况下code为100
                return newSendPaySuccessNoticeMessage();
            } else {
                return newSendPayFaileMessage();
            }
        }
        return newSendPayFaileMessage();
    }

    @Override
    public String refundNotifyCallback(RefundNotifyCallbackRequestVo requestVo) {
        String trackingNo = LogTreadLocal.getTrackingNo();
        Integer refundStatus = requestVo.getRefundStatus();
        if (!Objects.equals(refundStatus, ResponseCodeConstant.RESPONSE_SUCCESS)) {
            //只有退款成功更新状态.其他情况不处理
            return refundFaileMessage("pay refundStatus is not 100,refundStatus=" + refundStatus);
        }
        //查询订单详情
        QueryRelationOrderByIdResponseDto queryOrderByIdResponseDto = getQueryRelationOrderByIdResponseDto(requestVo.getTransId());
        if (queryOrderByIdResponseDto.getData() == null || !Objects.equals(ResponseCodeConstant.RESPONSE_SUCCESS, queryOrderByIdResponseDto.getErrcode())) {
            return refundFaileMessage("order query fail" + queryOrderByIdResponseDto);
        }

        OrderBean orderBean = new OrderBean();
        if (1 == queryOrderByIdResponseDto.getData().size()) {
            orderBean = queryOrderByIdResponseDto.getData().get(0);
        } else {
            List<OrderBean> orderBeans = queryOrderByIdResponseDto.getData().stream().filter(order -> order.getBizType().equals(1)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(orderBeans)) {
                orderBean = orderBeans.get(0);
            }
        }

        //订单状态
        Integer status = orderBean.getRefundList().get(0).getStatus();
        if (!Objects.equals(RefundStatus.ALREADY_REFUND.getCode(), status)) {
            //不是退款中处理不处理
            return refundFaileMessage("order status is not 3,status=" + status);
        }
        String afterSalesCode = orderBean.getRefundList().get(orderBean.getRefundList().size() - 1).getRid();
        //退款流水号
        BaseQueryOrderRequest request = new BaseQueryOrderRequest();
        request.setPartnerId(requestVo.getPartnerId());
        request.setOrderId(requestVo.getTransId());
        request.setAfterSalesCode(afterSalesCode);
        request.setRefundSerialNo(requestVo.getRefundId());
        request.setOperator("admin");
        request.setTrackingNo(trackingNo);
        BaseOrderResponse response = orderCenterSdkService.orderRefundComplete(request);
        if (response == null || !Objects.equals(ResponseCodeConstant.RESPONSE_SUCCESS, response.getErrcode())) {
            return refundFaileMessage("orderRefundComplete fail" + response);
        }
        return newSendPaySuccessNoticeMessage();
    }

    private QueryRelationOrderByIdResponseDto getQueryRelationOrderByIdResponseDto(String oid) {
        QueryRelatedOrderByCodeRequest baseQueryOrderRequest = new QueryRelatedOrderByCodeRequest();
        baseQueryOrderRequest.setOrderCode(oid);
        baseQueryOrderRequest.setTrackingNo(LogTreadLocal.getTrackingNo());
        QueryRelatedOrderByCodeResp queryOrderByIdResponse;
        queryOrderByIdResponse = orderCenterSdkService.queryRelatedOrderByCode(baseQueryOrderRequest);
        String string = JSONObject.toJSONString(queryOrderByIdResponse);
        JSONObject jsonObject = JSONObject.parseObject(string);
        QueryRelationOrderByIdResponseDto queryOrderByIdResponseDto = jsonObject.toJavaObject(QueryRelationOrderByIdResponseDto.class);
        String orderString = JSONObject.toJSONString(queryOrderByIdResponse.getOrderBeanList());
        queryOrderByIdResponseDto.setData(JSONArray.parseArray(orderString, OrderBean.class));
        return queryOrderByIdResponseDto;
    }

    @Override
    public BaseResponse queryOrders(QueryOrderVo queryOrderVo) {
        AssortmentCustomerInfoVo userLoginInfoDto = customerInfoManager.getCustomerInfoByObject(queryOrderVo.getSessionId());
        if (userLoginInfoDto == null || StringUtils.isBlank(userLoginInfoDto.getMemberId())) {
            return ResponseUtil.error(ResponseResult.NOT_LOGIN);
        }
        if (StringUtils.isBlank(queryOrderVo.getStartDate())) {
            queryOrderVo.setStartDate(DateUtil.convert2String(DateUtil.addMonths(new Date(), -1), "yyyy-MM-dd"));
        }
        if (StringUtils.isBlank(queryOrderVo.getEndDate())) {
            queryOrderVo.setEndDate(DateUtil.convert2String(new Date(), "yyyy-MM-dd"));
        }
        if (queryOrderVo.getQueryOrderStatus() == null) {
            return ResponseUtil.error(ResponseResult.PARAMETER_MISSING.getCode(), "查询订单状态不能为空");
        }
        if (queryOrderVo.getQueryOrderType() != null) {
            if (OrderType.getByCode(queryOrderVo.getQueryOrderType()) == null) {
                return ResponseUtil.error(ResponseResult.PARAMETER_MISSING.getCode(), "查询订单类型不存在");
            }
        }
        String partnerId = queryOrderVo.getPartnerId();
        String startDateStr = queryOrderVo.getStartDate() + " 00:00:00";
        String endDateStr = queryOrderVo.getEndDate() + " 23:59:59";
        Date startDate = DateUtil.convert2Date(startDateStr, "yyyy-MM-dd HH:mm:ss");
        if (startDate == null) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR.getCode(), "查询订单开始时间格式不正确");
        }
        Date endDate = DateUtil.convert2Date(endDateStr, "yyyy-MM-dd HH:mm:ss");
        if (endDate == null) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR.getCode(), "查询订单结束时间格式不正确");
        }
        if (startDate.getTime() < DateUtil.addMonths(new Date(), -3).getTime()) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR.getCode(), "只能查询3个月内的订单信息");
        }
        String userId = userLoginInfoDto.getMemberId();
        QueryOrderDto queryOrderDto = BeanUtil.convertBean(queryOrderVo, QueryOrderDto::new);
        queryOrderDto.setPartnerId(queryOrderVo.getPartnerId());
        queryOrderDto.setStartDate(startDateStr);
        queryOrderDto.setEndDate(endDateStr);
        String channelType = this.getQueryOrderChannelType(queryOrderVo, userLoginInfoDto);
        QueryOrdersDto queryOrdersDto = orderAdapter.convent2QueryOrdersDto(queryOrderDto, userId, channelType);
        QueryOrdersResponse queryOrderResponse;
        try {
            QueryOrdersRequest queryOrdersRequest2 = new QueryOrdersRequest();
            BeanUtil.convertBean(queryOrdersDto, queryOrdersRequest2);
            queryOrdersRequest2.setTrackingNo(LogTreadLocal.getTrackingNo());
            queryOrderResponse = orderCenterSdkService.queryOrders(queryOrdersRequest2);
        } catch (Exception e) {
            LogUtil.error("queryOrders_error", gson.toJson(queryOrdersDto), e);
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR);
        }
        if (queryOrderResponse == null || !RESPONSE_SUCCESS_CODE.equals(queryOrderResponse.getErrcode())) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR.getCode());
        }
        Map<String, Object> responseMap = Maps.newTreeMap();
        //用户无订单数据
        if (queryOrderResponse.getData() == null || queryOrderResponse.getData().getCount() == 0) {
            responseMap.put("count", 0);
            responseMap.put("list", new ArrayList<QueryOrderResponseVo>());
            return ResponseUtil.success(responseMap);
        }
        List<QueryOrdersResponse.DataBean.OrderBean> orders = queryOrderResponse.getData().getOrders();
        Set<String> shopIds = new HashSet<>();
        // 过滤待支付订单
        if (CollectionUtils.isNotEmpty(orders)) {
            for (QueryOrdersResponse.DataBean.OrderBean orderBean : orders) {
                if (!(OrderStatus.WAIT_PAY.getCode().equals(orderBean.getStatus()) || PayStatus.NOT_PAY.getCode().equals(orderBean.getPayStatus()))) {
                    shopIds.add(orderBean.getShopId());
                }
            }
        }
        String storeCodes = "";
        for (String shopId : shopIds) {
            storeCodes = shopId + "," + storeCodes;
        }
        GetListByCodesRequest request = new GetListByCodesRequest();
        request.setPartnerId(partnerId);
        request.setStoreCodes(storeCodes);
        // 查询多个门店信息
        GetListByCodesResponse storeInfoResponse = storeCenterService.getListByCodes(request, LogTreadLocal.getTrackingNo());
        Map<String, StoreResponse.BizVO> storeMap = new HashMap<>();
        if (storeInfoResponse != null && storeInfoResponse.getBizVO() != null && storeInfoResponse.getBizVO().getList() != null) {
            for (StoreResponse.BizVO bizVO : storeInfoResponse.getBizVO().getList()) {
                storeMap.put(bizVO.getStoreCode(), bizVO);
            }
        }
        if (CollectionUtils.isNotEmpty(orders)) {
            orders.forEach(orderBean -> {
                StoreResponse.BizVO storeResponseDto = storeMap.get(orderBean.getShopId());
                if (storeResponseDto != null) {
                    orderBean.setShopAddress(storeResponseDto.getAddress());
                    orderBean.setShopPhone(storeResponseDto.getPhone());
                    orderBean.setShopImageUrl(storeResponseDto.getLogoUrl());
                    //默认骑手头像显示为门店首页图片
                    orderBean.setRiderPhoto(storeResponseDto.getLogoUrl());
                    orderBean.setLatitude(Double.valueOf(storeResponseDto.getLatitude()));
                    orderBean.setLongitude(Double.valueOf(storeResponseDto.getLongitude()));
                }
                // 获取订单运单号，如果有运单则是第三方外卖单
                if (orderBean.getAddInfo() != null && StringUtils.isNotEmpty(orderBean.getAddInfo().getDeliveryId())) {
                    hasThirdDelivery(orderBean);
                }
                orderBean.setQueueIndex("");
                // 查询待取餐订单才需要查询排队人数和订单状态扭转记录
                if (QueryOrderStatus.TAKE_MEAL.getCode().equals(queryOrderDto.getQueryOrderStatus())) {
                    // 查询订单的排队人数
                    BaseQueryOrderRequest var1 = new BaseQueryOrderRequest();
                    var1.setOrderId(orderBean.getOid());
                    var1.setTrackingNo(LogTreadLocal.getTrackingNo());
                    BaseOrderResponse baseOrderResponse = orderCenterSdkService.queryOrderQueueIndex(var1);
                    QueryOrderQueueIndexResponse response = new QueryOrderQueueIndexResponse();
                    response.setErrcode(baseOrderResponse.getErrcode());
                    response.setErrmsg(baseOrderResponse.getErrmsg());
                    response.setData(baseOrderResponse.getData() == null ? 0 : Integer.parseInt(baseOrderResponse.getData()));
                    if (RESPONSE_SUCCESS_CODE.equals(response.getErrcode())) {
                        String queueIndex = response.getData() == null ? "" : response.getData().toString();
                        orderBean.setQueueIndex(queueIndex);
                    }
                    // 查询订单的操作状态
                    BaseQueryOrderRequest var2 = new BaseQueryOrderRequest();
                    var2.setOrderId(orderBean.getOid());
                    var2.setTrackingNo(LogTreadLocal.getTrackingNo());
                    OrderStatusTrackingInfoResponse orderStatusTrackingInfoResponse = orderCenterSdkService.getOrderStatusTrackingInfoByOid(var2);

                    String string = JSONObject.toJSONString(orderStatusTrackingInfoResponse);
                    JSONObject jsonObject = JSONObject.parseObject(string);
                    OrderStatusTrackingInfoDto orderStatusTrackingInfoByOid = jsonObject.toJavaObject(OrderStatusTrackingInfoDto.class);
                    if (RESPONSE_SUCCESS_CODE.equals(orderStatusTrackingInfoByOid.getErrcode())) {
                        orderStatusTracking(orderBean, orderStatusTrackingInfoByOid);
                    }
                }
            });
        }

        List<QueryOrderResponseVo> queryOrderResponseVos = orderAdapter.convent2QueryOrderResponseVos(orders, userLoginInfoDto.getWxAppId(), userLoginInfoDto.getIappId());

        if (QueryOrderStatus.TAKE_MEAL.getCode().intValue() == queryOrderVo.getQueryOrderStatus()) {
            queryOrderResponseVos.forEach(queryOrderResponseVo -> {
                try {
                    // 判断是否有裂变活动 订单扩展信息判断必须有wxappid
                    // 查询门店下有没有 裂变活动
                    Long orderTime = DateUtil.convert2Date(queryOrderResponseVo.getOrderCreateTime(), DateUtil.FORMAT_YYYY_MM_DD_HHMMSS).getTime();
                    String activityId = isShareActivity(queryOrderVo.getPartnerId(), queryOrderResponseVo.getShopId(), queryOrderResponseVo.getWxappid(), orderTime == null ? 0 : orderTime, queryOrderResponseVo.getOid(), userId, queryOrderVo.getSessionId());
                    // 取红包图片
                    queryOrderResponseVo.setRedpacketsPicture(getRedpacketsPicture(activityId));
                    queryOrderResponseVo.setActivityId(activityId);
                    //参与支付有礼活动
                    joinPayGift(queryOrderVo.getSessionId(), queryOrderResponseVo);
                } catch (Exception e) {
                    LogUtil.error("queryOrders_activity_error", gson.toJson(queryOrdersDto), gson.toJson(queryOrderResponseVo), e);
                }
            });
        }


//        Map<String, Object> responseMap = Maps.newTreeMap();
        responseMap.put("count", queryOrderResponse.getData() == null ? 0 : queryOrderResponse.getData().getCount());
        responseMap.put("list", queryOrderResponseVos);
        //只有有订单时才显示用户自定义取餐信息
        if (CollectionUtils.isNotEmpty(queryOrderResponseVos)) {
            responseMap.put("definitionMsg", getDefinitionMsg(queryOrderVo.getPartnerId()));
        }
        return ResponseUtil.success(responseMap);
    }

    private String getRedpacketsPicture(String activityId) {
        if (StringUtils.isNotBlank(activityId)) {
            try {
                ActivityGetByIdResponseDto activityGetByIdResponseDto = promotionActivityClient.getById(Long.valueOf(activityId));
                if (Objects.equals(activityGetByIdResponseDto.getCode(), ResponseResult.SUCCESS.getCode())
                        && activityGetByIdResponseDto.getResult() != null) {
                    return activityGetByIdResponseDto.getResult().getShareConfig().getRedpacketsPicture();
                }
            } catch (Exception e) {
                ErrorLog.errorConvertJson(OrderServiceImpl.class, "getRedpacketsPicture", e);
            }
        }
        return null;
    }

    //参与支付有礼活动
    private void joinPayGift(String sessionId, QueryOrderResponseVo queryOrderResponseVo) {
        PayGitCheckAndJoinRequestDto payGitRequestDto = new PayGitCheckAndJoinRequestDto();
        payGitRequestDto.setStoreId(queryOrderResponseVo.getShopId());
        payGitRequestDto.setSessionId(sessionId);
        payGitRequestDto.setOid(queryOrderResponseVo.getOid());
        payGitRequestDto.setPayAmount(queryOrderResponseVo.getAmount());
        payGitRequestDto.setPayType(1);//1-微信,2-储值卡
        if (OrderType.COLLECT_GOODS.getCode().intValue() == queryOrderResponseVo.getOrderType() || OrderType.EAT_IN.getCode().intValue() == queryOrderResponseVo.getOrderType()) {
            payGitRequestDto.setOrderWay(1);
        } else {
            payGitRequestDto.setOrderWay(2);
        }
        BaseResponse<PayGiftCheckAndJoinResponseDto> payGiftBaseResponse = activityApplicationClient.payGiftCheckAndJoin(payGitRequestDto);
        if (String.valueOf(RESPONSE_SUCCESS_CODE).equals(payGiftBaseResponse.getCode()) && payGiftBaseResponse.getResult() != null) {
            PayGiftCheckAndJoinResponseDto payGiftResponse = payGiftBaseResponse.getResult();
            queryOrderResponseVo.setActivityName(payGiftResponse.getActivityName());
            queryOrderResponseVo.setCoupons(payGiftResponse.getCoupons());
        }
    }

    private void orderStatusTracking(QueryOrdersResponse.DataBean.OrderBean orderBean, OrderStatusTrackingInfoDto orderStatusTrackingInfoByOid) {
        List<OrderStatusTrackingInfoDto.OrderStatusTrackingInfo> data = orderStatusTrackingInfoByOid.getData();
        if (CollectionUtils.isNotEmpty(data)) {
            for (OrderStatusTrackingInfoDto.OrderStatusTrackingInfo orderStatusTrackingInfo : data) {
                Integer status = orderStatusTrackingInfo.getStatus();
                String statusTime = orderStatusTrackingInfo.getStatusTime();
                switch (status) {
                    case 1:
                        orderBean.setOperateTakeOrderTime(statusTime);
                        break;
                    case 2:
                        orderBean.setOperateWaitPayTime(statusTime);
                        break;
                    case 3:
                        orderBean.setOperateReceiptTime(statusTime);
                        break;
                    case 4:
                        orderBean.setOperateDistributionTime(statusTime);
                        break;
                    case 5:
                        orderBean.setOperateCompleteTime(statusTime);
                        break;
                    case 6:
                        orderBean.setOperateCalcelTime(statusTime);
                        break;
                    case 7:
                        orderBean.setOperatePefuseTime(statusTime);
                        break;
                    case 31:
                        orderBean.setOperateCompleteMakeTime(statusTime);
                        break;
                    default:
                        break;
                }
            }
        }
    }

    @Override
    public BaseResponse queryOrderById(Integer operation, String sessionId, String oid, String partnerId, String channel) {
        AssortmentCustomerInfoVo userInfo = customerInfoManager.getCustomerInfoByObject(sessionId);
        if (userInfo == null || StringUtils.isEmpty(userInfo.getMemberId())) {
            return ResponseUtil.error(ResponseResult.NOT_LOGIN);
        }
        String userId = userInfo.getMemberId();
        if (StringUtils.isBlank(oid)) {
            return ResponseUtil.error(ResponseResult.PARAMETER_MISSING.getCode(), "oid不能为空");
        }
        BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
        baseQueryOrderRequest.setOrderId(oid);
        baseQueryOrderRequest.setTrackingNo(LogTreadLocal.getTrackingNo());
        QueryOrderByIdResponse response = orderCenterSdkService.queryOrderById(baseQueryOrderRequest);
        if (!RESPONSE_SUCCESS_CODE.equals(response.getErrcode()) || response.getData() == null) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR);
        }
        QueryOrdersResponse.DataBean.OrderBean orderBean = response.getData();
        String storeId = orderBean.getShopId();
        StoreInfoRequest request = new StoreInfoRequest();
        request.setPartnerId(partnerId);
        request.setStoreCode(storeId);
        StoreResponse storeInfo = storeCenterService.getStoreInfo(request, LogTreadLocal.getTrackingNo());
        if (storeInfo != null && storeInfo.getBizVO() != null) {
            StoreResponse.BizVO storeResponseDto = storeInfo.getBizVO();
            orderBean.setShopAddress(storeResponseDto.getAddress());
            orderBean.setShopPhone(storeResponseDto.getPhone());
            orderBean.setShopImageUrl(storeResponseDto.getLogoUrl());
            //默认骑手头像显示为门店首页图片
            orderBean.setRiderPhoto(storeResponseDto.getLogoUrl());
            orderBean.setShopPhone(storeResponseDto.getPhone());
            orderBean.setLatitude(Double.valueOf(storeResponseDto.getLatitude()));
            orderBean.setLongitude(Double.valueOf(storeResponseDto.getLongitude()));
        }
        //TODO 查询订单的排队人数
        orderBean.setQueueIndex("");

        BaseQueryOrderRequest var1 = new BaseQueryOrderRequest();
        var1.setOrderId(orderBean.getOid());
        var1.setTrackingNo(LogTreadLocal.getTrackingNo());
        BaseOrderResponse baseOrderResponse = orderCenterSdkService.queryOrderQueueIndex(var1);
        QueryOrderQueueIndexResponse response1 = new QueryOrderQueueIndexResponse();
        response1.setErrcode(baseOrderResponse.getErrcode());
        response1.setErrmsg(baseOrderResponse.getErrmsg());
        if (RESPONSE_SUCCESS_CODE.equals(response1.getErrcode())) {
            String queueIndex = response1.getData() == null ? "" : response1.getData().toString();
            orderBean.setQueueIndex(queueIndex);
        }
        //  获取订单运单号，如果有运单则是第三方外卖单
        if (orderBean.getAddInfo() != null && StringUtils.isNotEmpty(orderBean.getAddInfo().getDeliveryId())) {
            hasThirdDelivery(orderBean);
        }
        // 查询订单的操作状态
        OrderStatusTrackingInfoResponse statusTrackingInfoByOid = orderCenterSdkService.getOrderStatusTrackingInfoByOid(var1);
        String string2 = JSONObject.toJSONString(statusTrackingInfoByOid);
        JSONObject jsonObject2 = JSONObject.parseObject(string2);
        OrderStatusTrackingInfoDto orderStatusTrackingInfoByOid = jsonObject2.toJavaObject(OrderStatusTrackingInfoDto.class);

        if (RESPONSE_SUCCESS_CODE.equals(orderStatusTrackingInfoByOid.getErrcode())) {
            orderStatusTracking(orderBean, orderStatusTrackingInfoByOid);
        }

        List<QueryOrderResponseVo> queryOrderResponseVos = orderAdapter.convent2QueryOrderResponseVos(Collections.singletonList(orderBean), userInfo.getWxAppId(), userInfo.getIappId());
        if (CollectionUtils.isEmpty(queryOrderResponseVos)) {
            throw new ServiceException(ResponseResult.ORDER_QUERYORDER_ERROR);
        }
        QueryOrderResponseVo queryOrderResponseVo = queryOrderResponseVos.get(0);
        if (IappIdType.WC_XCX.getCode().equals(userInfo.getIappId())) {
            queryOrderResponseVo.getProducts().stream().forEach(each -> {
                orderBean.getProductList().forEach(var -> {
                    if (var.getId() == each.getId()) {
                        each.setSaleTotalAmount(var.getSettlementPrice());
                        each.setOriginalTotalAmount(var.getSettlementPrice());
                    }
                });

            });
        }

        // 判断是否有裂变活动 订单扩展信息判断必须有wxappid
        String extInfo = response.getData().getExtInfo();
        if (StringUtils.isNotBlank(extInfo)) {
            OrderExtInfoDto orderExtInfoDto = gson.fromJson(extInfo, OrderExtInfoDto.class);
            String wxappid = orderExtInfoDto.getAppid();
            // 查询门店下有没有 裂变活动
            String activityId = isShareActivity(partnerId, storeId, wxappid, response.getData().getGmtCreate(), oid, userId, sessionId);
            queryOrderResponseVo.setActivityId(activityId);
            // 取红包图片
            queryOrderResponseVo.setRedpacketsPicture(getRedpacketsPicture(activityId));
        }

        return ResponseUtil.success(queryOrderResponseVo);
    }

    /**
     * 如果有第三方配送，返回值添加第三方配送信息
     */
    private void hasThirdDelivery(QueryOrdersResponse.DataBean.OrderBean orderBean) {
        String deliveryId = orderBean.getAddInfo().getDeliveryId();
        if ("0".equals(deliveryId)) {
            return;
        }
        String trackingNo = LogTreadLocal.getTrackingNo();
        DeliveryResponseDto<DeliveryInfoDto> delivery = deliveryService.deliveryOrderOne(deliveryId, trackingNo);
        if (RESPONSE_SUCCESS_CODE == delivery.getCode() && delivery.getData() != null) {
            DeliveryInfoDto result = delivery.getData();
            orderBean.setDeliverStatus(result.getDeliveryStatus());
            orderBean.setRiderName(result.getRiderName());
            orderBean.setRiderPhone(result.getRiderPhone());
            orderBean.setReceiveTime(result.getReceiveTime());
            orderBean.setDepatchTime(result.getDepatchTime());
            orderBean.setArriveShopTime(result.getArriveShopTime());
            orderBean.setSendTime(result.getSendTime());
            orderBean.setCompleteTime(result.getCompleteTime());
        }
    }

    /**
     * 查询门店下有没有 裂变活动
     *
     * @param partnerId
     * @param storeId
     * @param wxappid
     * @param orderTime
     * @return
     */
    private String isShareActivity(String partnerId, String storeId, String wxappid, Long orderTime, String bizId, String userId, String sessionId) {

        QueryValidShareActivityReq activityReq = new QueryValidShareActivityReq();
        activityReq.setAppId(wxappid);
        activityReq.setPartnerId(partnerId);
        activityReq.setStoreId(storeId);
        activityReq.setOrderId(bizId);
        String activityId = Optional.ofNullable(promotionActivityClient.queryValidShareActivity(activityReq)).map(BaseResponse::getResult).map(Object::toString).orElse("");

        String nickName = Optional.ofNullable(customerInfoManager.getCustomerInfoByObject(sessionId)).map(AssortmentCustomerInfoVo::getNickName).orElse("");
        if (StringUtils.isNotBlank(activityId)) {
            // 添加分享记录 每笔订单只能添加一笔分享记录
            ShareAcitivityRequestDto shareAcitivityRequestDto = couponAdapter.convert2ShareAcitivityRequestDto(activityId, bizId, partnerId, userId, nickName);
            BaseResponse shareResponse = promotionActivityClient.shareRecord(shareAcitivityRequestDto);
            if (Objects.equals(shareResponse.getCode(), ResponseResult.SUCCESS.getCode())) {
                return activityId;
            }
        }
        return null;
    }

    @Override
    public BaseResponse deleteOrder(DeleteOrderVo deleteOrderVo) {
        if (StringUtils.isBlank(deleteOrderVo.getOid())) {
            return ResponseUtil.error(ResponseResult.PARAMETER_MISSING.getCode(), "oid不能为空");
        }
        BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
        baseQueryOrderRequest.setOrderId(deleteOrderVo.getOid());
        baseQueryOrderRequest.setTrackingNo(LogTreadLocal.getTrackingNo());
        QueryOrderByIdResponse queryOrderByIdResponse = orderCenterSdkService.queryOrderById(baseQueryOrderRequest);
        String string = JSONObject.toJSONString(queryOrderByIdResponse);
        JSONObject jsonObject = JSONObject.parseObject(string);
        QueryOrderByIdResponseDto responseDto = jsonObject.toJavaObject(QueryOrderByIdResponseDto.class);
        if (!RESPONSE_SUCCESS_CODE.equals(responseDto.getErrcode()) || responseDto.getData() == null) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR);
        }
        //围餐删除缓存信息
        mealCacheManager.deleteOrderCreatePreParmentLock(queryOrderByIdResponse.getData().getCompanyId(), queryOrderByIdResponse.getData().getShopId(), queryOrderByIdResponse.getData().getBarCounter());
        OrderBean orderBean = responseDto.getData();
        if (!PayStatus.NOT_PAY.getCode().equals(orderBean.getPayStatus())) {
            return ResponseUtil.error(ResponseResult.ORDER_DELETE_ERROR.getCode(), "订单状态不允许删除");
        }
        if (!OrderStatus.WAIT_PAY.getCode().equals(orderBean.getStatus())) {
            return ResponseUtil.error(ResponseResult.ORDER_DELETE_ERROR.getCode(), "订单状态不允许删除");
        }
//        DeleteOrderDto deleteOrderDto = orderAdapter.convent2DeleteOrderDto(deleteOrderVo.getOid());
//
//        DeleteOrderRequest var1 = new DeleteOrderRequest();
//        var1.setOrderId(deleteOrderDto.getOrderId());
//        var1.setOrderSdkType(getDefaultOrderSdkType(deleteOrderVo.getPartnerId()));
//        var1.setTrackingNo(LogTreadLocal.getTrackingNo());
//        BaseOrderResponse baseOrderResponse = orderCenterSdkService.deleteOrder(var1);
//
//        if (!RESPONSE_SUCCESS_CODE.equals(baseOrderResponse.getErrcode())) {
////            log.error("deleteOrder is error , deleteOrderDto :{}", deleteOrderDto);
//            return ResponseUtil.error(ResponseResult.ORDER_DELETE_ERROR);
//        }
        // 删除订单 通知活动添加商品库存
        //backOrdersNotifyActivity(orderBean, Arrays.asList(TransTypeEnum.ACTIVITY.getCode(), TransTypeEnum.PRODUCT.getCode()));
        // TODO: 2019/9/10 删除订单通知
        backOrdersStatusChange(orderBean.getOid(), orderBean.getStatus());
        return ResponseUtil.success();
    }

    @Override
    public BaseResponse orderRefund(OrderRefundVo orderRefundVo) {
        if (StringUtils.isEmpty(orderRefundVo.getReason())) {
            orderRefundVo.setReason("退款");
        }
        AssortmentCustomerInfoVo userInfo = customerInfoManager.getCustomerInfoByObject(orderRefundVo.getSessionId());
        if (userInfo == null || StringUtils.isEmpty(userInfo.getMemberId())) {
            return ResponseUtil.error(ResponseResult.NOT_LOGIN);
        }
        String memberId = userInfo.getMemberId();
        String partnerId = userInfo.getPartnerId();
//        String openid = map.get("openid").toString();
//        String wxappId = map.get("wxAppid").toString();

        if (StringUtils.isBlank(orderRefundVo.getOid())) {
            return ResponseUtil.error(ResponseResult.PARAMETER_MISSING.getCode(), "oid不能为空");
        }

        BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
        baseQueryOrderRequest.setOrderId(orderRefundVo.getOid());
        baseQueryOrderRequest.setTrackingNo(LogTreadLocal.getTrackingNo());
        QueryOrderByIdResponse queryOrderByIdResponse = orderCenterSdkService.queryOrderById(baseQueryOrderRequest);
        String string = JSONObject.toJSONString(queryOrderByIdResponse);
        JSONObject jsonObject = JSONObject.parseObject(string);
        QueryOrderByIdResponseDto orderByIdResponseDto = jsonObject.toJavaObject(QueryOrderByIdResponseDto.class);
        boolean isSon = StringUtils.isEmpty(orderByIdResponseDto.getData().getParentCode()) || "0".equals(orderByIdResponseDto.getData().getParentCode());
        String orderId = isSon ? orderByIdResponseDto.getData().getOid() : orderByIdResponseDto.getData().getParentCode();
        if (!RESPONSE_SUCCESS_CODE.equals(orderByIdResponseDto.getErrcode()) || orderByIdResponseDto.getData() == null) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR.getCode(), "订单信息不存在");
        }
        if (!memberId.equals(orderByIdResponseDto.getData().getUserId())) {
            return ResponseUtil.error(ResponseResult.ORDER_QUERYORDER_ERROR.getCode(), "不能操作非本人的订单");
        }
        OrderBean orderBean = orderByIdResponseDto.getData();
        //orderBean.setOid(orderId);
        if (PayStatus.NOT_PAY.getCode().equals(orderByIdResponseDto.getData().getPayStatus())
                || OrderStatus.WAIT_PAY.getCode().equals(orderBean.getStatus())) {
            return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "订单未支付，无法退款");
        }
//        if (OrderStatus.COMPLETE.getCode().equals(orderBean.getStatus())) {
//            return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "订单已完成，无法退款");
//        }
        if (OrderStatus.CALCEL.getCode().equals(orderBean.getStatus())) {
            return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "订单已取消，无法退款");
        }
        if (OrderStatus.DISTRIBUTION.getCode().equals(orderBean.getStatus())) {
            return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "订单配送中，退款请联系售后！");
        }

        /**
         * 已接单，制作完成，配送中,未接单，用户可申请退款
         *
         * v1.9.3.1 支持已完成订单可申请退款(通过b端后台控制)
         */
        List<Integer> enableRefundCodes = Lists.newArrayList(Arrays.asList(
                OrderStatus.RECEIPT.getCode(), OrderStatus.COMPLETE_MAKE.getCode(), OrderStatus.DISTRIBUTION.getCode(), OrderStatus.TAKE_ORDER.getCode(), OrderStatus.COMPLETE.getCode()
        ));
        if (enableRefundCodes.contains(orderBean.getStatus()) && PayStatus.HAVE_PAID.getCode().equals(orderBean.getPayStatus())) {
            if (CollectionUtils.isNotEmpty(orderBean.getRefundList())) {
                OrderBean.RefundBean refundBean = orderBean.getRefundList().get(0);
                if (RefundStatus.APPLY_REFUND.getCode().equals(refundBean.getStatus())) {
                    return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "商家正在处理中，请稍后……");
                }
                if (RefundStatus.REFUSE_REFUND.getCode().equals(refundBean.getStatus())) {
                    return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "您的申请已被商家拒绝，请联系门店沟通。");
                }
            }
            if (OrderStatus.COMPLETE.getCode().equals(orderBean.getStatus())) {
                boolean refundButton = this.orderAdapter.checkRefundButton(queryOrderByIdResponse.getData(), userInfo.getWxAppId());
                if (!refundButton) {
                    return ResponseUtil.error(ResponseResult.ORDER_NOT_ALLOW_REFUND.getCode(), ResponseResult.ORDER_NOT_ALLOW_REFUND.getMessage());
                }
            }
            // 未接单
            if (OrderStatus.TAKE_ORDER.getCode().equals(orderBean.getStatus())) {
                //商家未接单逻辑处理    1.调用支付退款 2.根据支付退款返回状态组装订单取消参数,调用订单取消接口
                BaseResponse baseResponse = partnerNoTakeOrder(orderRefundVo, orderBean, orderId,AfterSalesType.USER_CANCEL);
                if (baseResponse != null) {
                    return baseResponse;
                }
                // 删除订单 通知活动添加商品库存
                //backOrdersNotifyActivity(orderBean, Arrays.asList(TransTypeEnum.ACTIVITY.getCode(), TransTypeEnum.COUPON.getCode(), TransTypeEnum.PRODUCT.getCode()));
                backOrdersStatusChange(orderBean.getOid(), orderBean.getStatus());
            } else {
                com.freemud.sdk.api.assortment.order.request.order.OrderRefundRequest var1 = new com.freemud.sdk.api.assortment.order.request.order.OrderRefundRequest();
                OrderRefundRequestDto orderRefundRequestDto = orderAdapter.convent2OrderRefundRequestDto(orderRefundVo, orderBean.getOid());
                BeanUtil.convertBean(orderRefundRequestDto, var1);
                var1.setTrackingNo(LogTreadLocal.getTrackingNo());
                var1.setPartnerId(orderRefundVo.getPartnerId());
                var1.setStoreId(orderBean.getShopId());
                var1.setOrderStatus(orderBean.getStatus());
                var1.setOperator(orderBean.getUserName());
                BaseOrderResponse baseResponseDto = orderCenterSdkService.orderRefund(var1);
                if (!RESPONSE_SUCCESS_CODE.equals(baseResponseDto.getErrcode())) {
                    return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), baseResponseDto.getErrmsg());
                }
                if (orderBean.getAmount() > 0) {
                    sendPosMessage(partnerId, orderBean.getShopId());
                }
                //通知小助手发送申请退款公众号订阅消息
                sendApplyRefundSubscriptionNotice(orderBean,var1);
                //已接单可发起退款申请，查询门店有无云打印机，有则打印退款申请小票
                printApplyRefundSmallTicket(orderBean, orderRefundVo);
            }
        }
        return ResponseUtil.success();
    }

    /**
     * 商家未接单,取消订单逻辑处理    1.调用支付退款 2.根据支付退款返回状态组装订单取消参数,调用订单取消接口
     *
     * @param orderRefundVo
     * @param orderBean
     */
    private BaseResponse partnerNoTakeOrder(OrderRefundVo orderRefundVo, OrderBean orderBean, String fatherOrderId,AfterSalesType afterSalesType) {
        com.freemud.application.sdk.api.base.BaseResponse<OrderRefundResponse> response = null;
        Long refundId = System.currentTimeMillis();
        String partnerId = orderBean.getCompanyId();
        int state = PayRefundStatus.SUCCESS.getCode();
        if (orderBean.getAmount() != 0) {
            //调用支付退款
            com.freemud.sdk.api.assortment.payment.request.OrderRefundRequest orderPayRefundRequest = orderAdapter.getOrderPayRefundRequest(orderBean, refundId, fatherOrderId);
            response = standardPaymentService.orderRefund(orderPayRefundRequest, LogTreadLocal.getTrackingNo());
            if (response == null || response.getData() == null || !com.freemud.sdk.api.assortment.order.domain.ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(response.getCode())) {
                return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "orderRefund_failed");
            }
            //获取支付返回退款状态
            state = response.getData().getRefundStatus() == null ? PayRefundStatus.SUCCESS.getCode() : response.getData().getRefundStatus();
        }
        CancelOrderRequest cancelOrderRequest = orderAdapter.convent2CancelOrderRequest(orderBean.getOid(),
                partnerId, afterSalesType, orderRefundVo.getReason(), LogTreadLocal.getTrackingNo(), refundId.toString());
        cancelOrderRequest.setOperator(orderBean.getUserName());
        cancelOrderRequest.setPartnerId(orderBean.getCompanyId());
        if (PayRefundStatus.RUNNING.getCode().intValue() == state) {
            // 退款中
            cancelOrderRequest.setCreateEvent(AfterSalesOrderCreateEventEnum.RETURN_COMPLETE.getCreateEvent());
        } else if (PayRefundStatus.SUCCESS.getCode().intValue() == state) {
            //退款成功
            cancelOrderRequest.setCreateEvent(AfterSalesOrderCreateEventEnum.REFUND_COMPLETE.getCreateEvent());
        }
        cancelOrderRequest.setReqRemark(orderRefundVo.getRemarks());
        BaseOrderResponse baseOrderResponse = orderCenterSdkService.orderCancel(cancelOrderRequest);
        if (baseOrderResponse == null || baseOrderResponse.getData() == null || !ObjectUtils.equals(ResponseConstant.SUCCESS_RESPONSE_CODE, baseOrderResponse.getErrcode())) {
            return ResponseUtil.error(ResponseResult.ORDER__ERRORREFUND.getCode(), "orderRefund_failed");
        }
        return null;
    }

    public void backOrdersNotifyActivity(OrderBean orderBean, List<Integer> transType) {
        LogUtil.info("backOrdersNotifyActivity", gson.toJson(orderBean), gson.toJson(transType));
        if (orderBean == null) {
            return;
        }
        // 删除订单 通知活动添加商品库存
        ActivityCancelStockRequestDto activityCancelStockRequestDto = activityAdapter.convert2ActivityCancelStockRequestDto(
                orderBean, transType);
        try {
            Header header = new Header(MQAction.INSERT.getAction(), "backOrdersNotifyActivity", orderBean.getOid(), backOrdersChangeOrderStatusConsumerQueue);
            MQMessage<ActivityCancelStockRequestDto> message = new MQMessage<>(header, activityCancelStockRequestDto);
            mqService.convertAndSend(backOrdersNotifyActivityExchange, backOrdersChangeOrderStatusConsumerQueue, message);
        } catch (Exception e) {
            LogUtil.error("ActivityReverse", JSON.toJSONString(activityCancelStockRequestDto), "", e);
        }
    }


    public void backOrdersStatusChange(String oid, Integer orderStatus) {
        if (StringUtils.isEmpty(oid)) {
            return;
        }
        ApiLog.info("backOrdersStatusChange", oid, String.valueOf(orderStatus));
        OrderStatusChangeRequestDto requestDto = new OrderStatusChangeRequestDto();
        requestDto.setOid(oid);
        requestDto.setOrderStatus(orderStatus);

        try {
            Header header = new Header(MQAction.INSERT.getAction(), "backOrdersStatusChange", oid, backOrdersChangeOrderStatusConsumerQueue);
            MQMessage<OrderStatusChangeRequestDto> message = new MQMessage<>(header, requestDto);
            mqService.convertAndSend(backOrdersNotifyActivityExchange, backOrdersChangeOrderStatusConsumerQueue, message);
        } catch (Exception e) {
            LogUtil.error("ActivityReverse", JSON.toJSONString(requestDto), "", e);
        }
    }

    /**
     * 发MQ去打印
     *
     * @param request
     */
    public void asynchronousPrint(OrderPrintDto request) {
        LogUtil.debug("OrderPrintDto", JSONObject.toJSONString(request), null);
        Header header = new Header(MQAction.INSERT.getAction(), "asynchronous-print-api", request.getOid() + "", cloudPrintQueue);
        MQMessage<OrderPrintDto> message = new MQMessage<>(header, request);
        mqService.convertAndSend(cloud_print_exchange, cloudPrintQueue, message);
    }

    @Override
    public BaseResponse queryOrderQueueIndex(QueryOrderQueueIndexVo queryOrderQueueIndexVo) {
        AssortmentCustomerInfoVo userInfo = customerInfoManager.getCustomerInfoByObject(queryOrderQueueIndexVo.getSessionId());
        if (userInfo == null || StringUtils.isEmpty(userInfo.getMemberId())) {
            return ResponseUtil.error(ResponseResult.NOT_LOGIN);
        }
        try {
            BaseQueryOrderRequest var1 = new BaseQueryOrderRequest();
            var1.setOrderId(queryOrderQueueIndexVo.getOid());
            var1.setTrackingNo(LogTreadLocal.getTrackingNo());
            BaseOrderResponse response = orderCenterSdkService.queryOrderQueueIndex(var1);

            if (!RESPONSE_SUCCESS_CODE.equals(response.getErrcode())) {
                return ResponseUtil.error(ResponseResult.NOT_LOGIN);
            }
            Map<String, String> queueIndexMap = Maps.newTreeMap();
            queueIndexMap.put("oid", queryOrderQueueIndexVo.getOid());
            queueIndexMap.put("queueIndex", response.getData() == null ? "" : response.getData().toString());
            return ResponseUtil.success(queueIndexMap);
        } catch (Exception e) {
            return ResponseUtil.error(ResponseResult.SYSTEM_BUSINESS_ERROR);
        }
    }

//    /**
//     * 用户评价
//     *
//     * @param requestVo
//     * @return
//     */
//    @Override
//    public BaseResponse userOrderEvaluation(AddUserOrderEvaluationRequestVo requestVo) {
//        return microSupportClient.addEvaluationDetail(requestVo);
//    }
//
//    /**
//     * 用户评价（新接口）
//     *
//     * @param requestVo
//     * @return
//     */
//    @Override
//    public BaseResponse userOrderEvaluationNew(AddUserOrderEvaluationNewRequestVo requestVo) {
//        return microSupportClient.addEvaluationDetailNew(requestVo);
//    }
//
//    /**
//     * 根据订单号查询对应的评价详情
//     *
//     * @param requestVo
//     * @return
//     */
//    @Override
//    public BaseResponse getEvaluationByOrderId(GetEvaluationDetailByOrderIdRequestVo requestVo) {
//        return microSupportClient.getEvaluteDetailByOrderId(requestVo);
//    }
//
//    /**
//     * 判断对应的订单有没有评价
//     *
//     * @param requestVo
//     * @return
//     */
//    @Override
//    public BaseResponse getEvaluationStatus(GetEvaluationDetailByOrderIdRequestVo requestVo) {
//        return microSupportClient.getEvaluationStatus(requestVo);
//    }
//
//    @Override
//    public BaseResponse getEvaluationStatusNew(GetEvaluationStatusNewRequestVo requestVo) {
//        return microSupportClient.getEvaluationStatusNew(requestVo);
//    }

    @Override
    public BaseResponse getRefundReason(GetRefundReasonVo getRefundReasonVo) {
        AssortmentCustomerInfoVo customerInfoByObject = customerInfoManager.getCustomerInfoByObject(getRefundReasonVo.getSessionId());
        if (customerInfoByObject != null && customerInfoByObject.getMemberId() == null) {
            throw new ServiceException(ResponseResult.NOT_LOGIN);
        }
        List<RefundReasonResponseVo> refundReasonResponseVos = getRefundReasonResponseVos(getRefundReasonVo);
        return ResponseUtil.success(refundReasonResponseVos);
    }

    @Override
    public BaseResponse getNewRefundReason(GetRefundReasonVo getRefundReasonVo) {
        AssortmentCustomerInfoVo userInfo = customerInfoManager.getCustomerInfoByObject(getRefundReasonVo.getSessionId());
        if (userInfo != null && userInfo.getMemberId() == null) {
            throw new ServiceException(ResponseResult.NOT_LOGIN);
        }
        String oid = getRefundReasonVo.getOid();
        if (StringUtils.isEmpty(oid)) {
            throw new ServiceException(ResponseResult.ORDER_CODE_EMPTY);
        }
        GetRefundResonResponseVo result = new GetRefundResonResponseVo();
        List<RefundReasonResponseVo> refundReasonResponseVos = getRefundReasonResponseVos(getRefundReasonVo);
        result.setRefundReasons(refundReasonResponseVos);
        assert userInfo != null;
        String refundDocument = buildRefundDocument(oid);
        result.setRefundDocument(refundDocument);
        return ResponseUtil.success(result);
    }

    private String buildRefundDocument(String oid) {
        QueryOrderByIdResponseDto response = getQueryOrderByIdResponseDto(oid);
        if (!RESPONSE_SUCCESS_CODE.equals(response.getErrcode()) || response.getData() == null) {
            throw new ServiceException(ResponseResult.ORDER_QUERYORDER_ERROR);
        }
        OrderBean orderBean = response.getData();
        // TODO: 2019/9/9 再次校验是否可以退款 是否需要
        // boolean refund = orderAdapter.buildRefundButton(orderBean, wxappId);
        String document = OrderRefundConstant.COMMON_DOCUMENT;
        if (OrderType.COLLECT_GOODS.getCode().equals(orderBean.getType())) {
            return document;
        }
        if (OrderType.TAKE_OUT.getCode().equals(orderBean.getType())) {
            if (OrderStatus.COMPLETE.getCode().equals(orderBean.getStatus())) {
                document = OrderRefundConstant.TAKE_OUT_COMPLETE_DOCUMENT;
                return document;
            } else {
                document = OrderRefundConstant.TAKE_OUT_NOT_COMPLETE_DOCUMENT;
                return document;
            }
        }
        return document;
    }

    private QueryOrderByIdResponseDto getQueryOrderByIdResponseDto(String oid) {
        BaseQueryOrderRequest baseQueryOrderRequest = new BaseQueryOrderRequest();
        baseQueryOrderRequest.setOrderId(oid);
        baseQueryOrderRequest.setTrackingNo(LogTreadLocal.getTrackingNo());
        QueryOrderByIdResponse queryOrderByIdResponse = orderCenterSdkService.queryOrderById(baseQueryOrderRequest);
        String string = JSONObject.toJSONString(queryOrderByIdResponse);
        JSONObject jsonObject = JSONObject.parseObject(string);
        return jsonObject.toJavaObject(QueryOrderByIdResponseDto.class);
    }

    /**
     * 构建订单退款原因
     *
     * @param getRefundReasonVo 请求参数
     * @return
     */
    private List<RefundReasonResponseVo> getRefundReasonResponseVos(GetRefundReasonVo getRefundReasonVo) {
        List<RefundReasonResponseVo> refundReasonResponseVos = Lists.newArrayList();
        if (CreateOrderType.TAKE_OUT.getCode().equals(getRefundReasonVo.getOrderType())) {
            refundReasonResponseVos.add(getRefundReasonResponseVo(RefundReasonEnum.Delivery_Time_too_long));
            refundReasonResponseVos.add(getRefundReasonResponseVo(RefundReasonEnum.Misdelivery_Leakage_of_Goods));
            refundReasonResponseVos.add(getRefundReasonResponseVo(RefundReasonEnum.Riders_confirm_service_ahead_of_schedule));
            refundReasonResponseVos.add(getRefundReasonResponseVo(RefundReasonEnum.Other));
        } else {
            refundReasonResponseVos.add(getRefundReasonResponseVo(RefundReasonEnum.Wrong_order));
            refundReasonResponseVos.add(getRefundReasonResponseVo(RefundReasonEnum.Goods_not_match_expectations));
            refundReasonResponseVos.add(getRefundReasonResponseVo(RefundReasonEnum.Other));
        }
        return refundReasonResponseVos;
    }

    /**
     * 发送pos端消息
     */
    public void sendPosMessage(String partnerId, String storeId) {
        PushMessageNoticeDto pushMessageNoticeDto = messageNoticeAdapter.convent2PushMessageNoticeDto(2, partnerId, storeId,
                null, null, null, null);
        messageNoticeClient.createMessage(pushMessageNoticeDto, LogThreadLocal.getTrackingNo());
    }

    /**
     * 获取缓存用户信息
     */
//    private Map<String, Object> getUserInfoMapBySessionId(String sessionId) {
//        String redisKey = "saas:user:info:sessionId:" + sessionId;
//        Map<String, Object> map = redisCache.getValue(redisKey);
//        return map;
//    }

    /**
     * 支付后通知确认返回信息
     */
    public String sendPaySuccessNoticeMessage() {
        Map<String, Object> map = Maps.newTreeMap();
        map.put("code", 0);
        map.put("message", "success");
        return gson.toJson(map);
    }

    /**
     * 支付后通知确认返回信息
     */
    public String newSendPaySuccessNoticeMessage() {
        Map<String, Object> map = Maps.newTreeMap();
        map.put("code", 100);
        map.put("message", "success");
        return gson.toJson(map);
    }

    /**
     * 支付后通知失败返回信息
     */
    public String newSendPayFaileMessage() {
        Map<String, Object> map = Maps.newTreeMap();
        map.put("code", 500);
        map.put("message", "failed");
        return gson.toJson(map);
    }

    /**
     * 退款中回调失败返回信息
     */
    public String refundFaileMessage(String errorMes) {
        Map<String, Object> map = Maps.newTreeMap();
        map.put("code", 500);
        map.put("message", "failed:" + errorMes);
        return gson.toJson(map);
    }

    /**
     * 获取自定义信息
     */
//    public OrderExtInfoDto getOrderExtInfo(String partnerId, String prepayId, String appid, String appsecret, String openid) {
//        OrderExtInfoDto orderExtInfoDto = new OrderExtInfoDto();
//        orderExtInfoDto.setOpenid(openid);
//        orderExtInfoDto.setPrepayId(prepayId);
//        orderExtInfoDto.setAppid(appid);
//        orderExtInfoDto.setAppsecret(appsecret);
//        String accessToken = getAccessToken(partnerId, appid);
//        orderExtInfoDto.setAccessToken(accessToken);
//        orderExtInfoDto.setExpireDate("");
//        return orderExtInfoDto;
//    }

    /**
     * 获取accessToken
     */
    public String getAccessToken(String partnerId, String appid) {
        if (StringUtils.isBlank(partnerId) || StringUtils.isBlank(appid)) {
            return "";
        }
        String accessToken = "";
        GetWxappAccessTokenDto getWxappAccessTokenDto = new GetWxappAccessTokenDto();
        getWxappAccessTokenDto.setAppId(appid);
        getWxappAccessTokenDto.setParentId(Long.valueOf(WxappMessageTemplateType.PAY_SUCCESS.getParentId()));
//        GetWxappAccessTokenResponseDto responseDto = openPlatformClient.getAccessTokenAndTemplateId(getWxappAccessTokenDto);
//        if (ResponseResult.SUCCESS.getCode().equals(responseDto.getCode()) && responseDto.getResult() != null) {
//            accessToken = responseDto.getResult().getAccessToken();
//        }
//        LogUtil.info("getAccessToken end", gson.toJson(getWxappAccessTokenDto), gson.toJson(responseDto));
        return accessToken;
    }


    /**
     * 发送支付成功模板消息
     *
     * @param orderBean
     */
    private void sendPaySuccessMessage(QueryOrdersResponseDto.DataBean.OrderBean orderBean) {
        Long gmtExpect = orderBean.getGmtExpect();
        if (gmtExpect != null) {
            // 预约下单
            this.sendMessage(orderBean, MessageEventType.PAYORDEREXPECT);
        } else {
            // 非预约下单
            this.sendMessage(orderBean, MessageEventType.PAYORDER);
        }
    }

    /**
     * 发送模板消息
     *
     * @param orderBean
     * @param messageEventType
     */
    private void sendMessage(QueryOrdersResponseDto.DataBean.OrderBean orderBean, MessageEventType messageEventType) {
        MessageTemplateRequest<MessagePushOrderTemplateRequest> messageTemplateRequest = null;
        try {
            messageTemplateRequest = messageNoticeAdapter.convent2MessageTemplateRequest(orderBean);
            messageTemplateRequest.setMessageEventType(messageEventType);
            this.messageTemplatePushService.sendTemplateMsg(messageTemplateRequest);
        } catch (Exception e) {
            LogUtil.error("sendTemplateMsg_error", JSONObject.toJSONString(orderBean), JSONObject.toJSONString(messageTemplateRequest), e);
        }
    }


    /**
     * 异常状态退款流程
     */
    public void orderRefund(OrderBean orderBean, String refundReason, String openid, String oid) {
        String storeId = orderBean.getShopId();
        String partnerId = orderBean.getCompanyId();
        OrderRefundVo orderRefundVo = new OrderRefundVo();
        orderRefundVo.setOid(orderBean.getOid());
        orderRefundVo.setPartnerId(orderBean.getCompanyId());
        orderRefundVo.setReason(refundReason);
        //系统异常取消订单
        partnerNoTakeOrder(orderRefundVo, orderBean, oid,AfterSalesType.SYSTEM_CANCEL);
        // 发送消息到消息中心推送给pos前端
        PushMessageNoticeDto pushMessageNoticeDto = messageNoticeAdapter.convent2PushMessageNoticeDto(2, partnerId, storeId,
                null, null, null, null);
        String messageNoticeResponse = messageNoticeClient.createMessage(pushMessageNoticeDto, LogThreadLocal.getTrackingNo());
        // 退单冲正商品库存，冲正商品券，冲正活动库存
        //backOrdersNotifyActivity(orderBean, Arrays.asList(TransTypeEnum.ACTIVITY.getCode(), TransTypeEnum.COUPON.getCode(), TransTypeEnum.PRODUCT.getCode()));
        backOrdersStatusChange(orderBean.getOid(), orderBean.getStatus());

    }

    /**
     * 获取父子订单商品第三方商品编号
     *
     * @param
     * @return
     */
    private CreateFatherSonOrderRequest getProductCustomerCodeNew(CreateFatherSonOrderRequest fatherSonOrderRequest) {
        List<String> pids = new ArrayList<>();
        List<CreateFatherSonOrderRequest.OrderInfo> productOrderInfoList = fatherSonOrderRequest.getOrderInfoList().stream().filter(orderInfo -> orderInfo.getProducts() != null).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(productOrderInfoList)) {
            return fatherSonOrderRequest;
        }
        for (CreateOrderProductRequest productDto : productOrderInfoList.get(0).getProducts()) {
            pids.add(productDto.getProductId());
        }
        Map<String, GetProductsVo> products = itemService.getSpuProducts(pids, fatherSonOrderRequest.getPartnerId(), productOrderInfoList.get(0).getShopId());
        if (products.isEmpty()) {
            return fatherSonOrderRequest;
        }
        for (CreateOrderProductRequest productDto : productOrderInfoList.get(0).getProducts()) {
            if (StringUtils.isNotEmpty(productDto.getSpecification()) && products.get(productDto.getSpecification()) != null) {
                productDto.setCustomerCode(products.get(productDto.getSpecification()).getCustomerCode());
                productDto.setProductCode(products.get(productDto.getSpecification()).getProductCode());
                productDto.setThirdProductSpecId(products.get(productDto.getSpecification()).getThirdProductSpecId());
                productDto.setThirdProductPropertyId(getThirdPropertyId(products.get(productDto.getSpecification()).getProductAttributeGroupList(),productDto.getAddInfo()));
            } else {
                productDto.setCustomerCode("");
                productDto.setProductCode("");
                LogUtil.error("getProducts_exception", JSONObject.toJSONString(pids), JSONObject.toJSONString(products));
            }
            //套餐子商品
            if(CollectionUtils.isNotEmpty(productDto.getComboProduct())){
                for (CreateOrderProductRequest comboProduct : productDto.getComboProduct()){
                    String comboSkuId = comboProduct.getSpecification();
                    if (products.get(comboSkuId) != null) {
                        comboProduct.setCustomerCode(products.get(comboSkuId).getCustomerCode());
                        comboProduct.setProductCode(products.get(comboSkuId).getProductCode());
                        comboProduct.setThirdProductSpecId(products.get(comboSkuId).getThirdProductSpecId());
                        comboProduct.setThirdProductPropertyId(getThirdPropertyId(products.get(comboSkuId).getProductAttributeGroupList(),comboProduct.getAddInfo()));
                    } else {
                        comboProduct.setCustomerCode("");
                        comboProduct.setProductCode("");
                        LogUtil.error("getProducts_exception", JSONObject.toJSONString(comboSkuId), JSONObject.toJSONString(products), null);
                    }
                }
            }
        }
        return fatherSonOrderRequest;
    }

    /**
     * 获取商品第三方商品编号
     *
     * @param createOrderDto
     * @return
     */
    private BaseCreateOrderRequest getProductCustomerCode(BaseCreateOrderRequest createOrderDto) {
        List<String> spuIds = new ArrayList<>();
        for (CreateOrderProductRequest productDto : createOrderDto.getProducts()) {
            spuIds.add(productDto.getProductId());
        }
        Map<String, GetProductsVo> products = itemService.getSpuProducts(spuIds, createOrderDto.getCompanyId(), createOrderDto.getShopId());
        if (products.isEmpty()) {
            return createOrderDto;
        }
        for (CreateOrderProductRequest productDto : createOrderDto.getProducts()) {
            String skuId = productDto.getSpecification();
            if (products.get(skuId) != null) {
                productDto.setCustomerCode(products.get(skuId).getCustomerCode());
                productDto.setProductCode(products.get(skuId).getProductCode());
                productDto.setThirdProductSpecId(products.get(productDto.getSpecification()).getThirdProductSpecId());
                productDto.setThirdProductPropertyId(getThirdPropertyId(products.get(productDto.getSpecification()).getProductAttributeGroupList(),productDto.getAddInfo()));
            } else {
                productDto.setCustomerCode("");
                productDto.setProductCode("");
                LogUtil.error("getProducts_exception", JSONObject.toJSONString(skuId), JSONObject.toJSONString(products), null);
            }
            //套餐子商品
            if(CollectionUtils.isNotEmpty(productDto.getComboProduct())){
                for (CreateOrderProductRequest comboProduct : productDto.getComboProduct()){
                    String comboSkuId = comboProduct.getSpecification();
                    if (products.get(comboSkuId) != null) {
                        comboProduct.setCustomerCode(products.get(comboSkuId).getCustomerCode());
                        comboProduct.setProductCode(products.get(comboSkuId).getProductCode());
                        comboProduct.setThirdProductSpecId(products.get(comboSkuId).getThirdProductSpecId());
                        comboProduct.setThirdProductPropertyId(getThirdPropertyId(products.get(comboSkuId).getProductAttributeGroupList(),comboProduct.getAddInfo()));
                    } else {
                        comboProduct.setCustomerCode("");
                        comboProduct.setProductCode("");
                        LogUtil.error("getProducts_exception", JSONObject.toJSONString(skuId), JSONObject.toJSONString(products), null);
                    }
                }
            }

        }
        return createOrderDto;
    }

    private String getThirdPropertyId(List<ProductAttributeGroup> productAttributeGroups, String addInfo) {
        String thirdProductPropertyId = "";
        if(StringUtils.isBlank(addInfo) || CollectionUtils.isEmpty(productAttributeGroups) ){
            return thirdProductPropertyId;
        }
        JSONObject jsonObject = JSONObject.parseObject(addInfo);
        String attributeNames = (String)jsonObject.get("attributeNames");
        List<String> list = new ArrayList<>();
        String[] split = attributeNames.split("/");

        List<AttributeValue> attributeValues = new ArrayList<>();
        for (ProductAttributeGroup attributeGroup : productAttributeGroups){
            attributeValues.addAll(attributeGroup.getAttributeValues());
        }

        for (int i= 0;i<split.length;i++){
            for (AttributeValue attributeValue : attributeValues){
                if(attributeValue.getAttributeValue().equals(split[i])){
                    list.add(attributeValue.getCustomerCode());
                    break;
                }
            }
        }
        if (CollectionUtils.isNotEmpty(list)) {
            thirdProductPropertyId = StringUtils.join(list, ",");
        }
        return thirdProductPropertyId;
    }

    /**
     * 创建订单调用集成，不区分订单类型
     *
     * @return
     */
    private BaseResponse sdkCreateOrder(CreateOrderVo createOrderVo, StoreResponse.BizVO storeResponseDto, ShoppingCartGoodsDto shoppingCartGoodsDto, UserLoginInfoDto userLoginInfoDto, OrderExtInfoDTO orderExtInfoDTO) {
        OrderExtendedReq orderExtendedReq = orderAdapter.saveStoreInfo(storeResponseDto);
        String orderWarnTime = storeResponseDto.getOrderWarnTime();
        //创建普通订单
        Function<Object, CreateOrderResponse> createOrder = (var -> {
            BaseCreateOrderRequest baseCreateOrderRequest = orderAdapter.convent2CreateOrderDto(createOrderVo, shoppingCartGoodsDto,orderWarnTime);
            //查询第三方商品编号
            baseCreateOrderRequest = getProductCustomerCode(baseCreateOrderRequest);
            //保存门店渠道信息
            baseCreateOrderRequest.setOrderExtended(orderExtendedReq);
            CreateOrderRequest createOrderRequest = new CreateOrderRequest();
            baseCreateOrderRequest.setTrackingNo(LogThreadLocal.getTrackingNo());
            createOrderRequest.setBaseCreateOrderRequest(baseCreateOrderRequest);
            MqMessageRequest mqMessageRequest = new MqMessageRequest();
            mqMessageRequest.setBackOrdersNotifyActivityExchange(backOrdersNotifyActivityExchange);
            mqMessageRequest.setBackOrdersNotifyActivityQueue(backOrdersChangeOrderStatusConsumerQueue);
            createOrderRequest.setMqMessageRequest(mqMessageRequest);
            createOrderRequest.setTrackingNo(LogThreadLocal.getTrackingNo());
            return orderCenterSdkService.createOrderFlow(createOrderRequest);
        });
        //创建父子订单
        Function<Object, CreateFatherSonOrderResponse> createFatherSonOrder = (var -> {
            CreateFatherSonOrderRequest createFatherSonOrderRequest = orderAdapter.convertFatherSonOrderRequest(createOrderVo, shoppingCartGoodsDto, orderExtendedReq,orderWarnTime);
            //查询第三方商品编号
            createFatherSonOrderRequest = getProductCustomerCodeNew(createFatherSonOrderRequest);
            MqMessageRequest mqMessageRequest = new MqMessageRequest();
            mqMessageRequest.setBackOrdersNotifyActivityExchange(backOrdersNotifyActivityExchange);
            mqMessageRequest.setBackOrdersNotifyActivityQueue(backOrdersChangeOrderStatusConsumerQueue);
            createFatherSonOrderRequest.setMqMessageRequest(mqMessageRequest);
            return orderCenterSdkService.createFatherSonOrder(createFatherSonOrderRequest);
        });

        CreateOrderResponseVo createOrderResponse = new CreateOrderResponseVo();
        PaymentRequest paymentRequest = new PaymentRequest();
        long totalAmount = 0;
        int cardAmount = 0;
        QueryOrdersResponse.DataBean.OrderBean orderBean = new QueryOrdersResponse.DataBean.OrderBean();
        QueryOrdersResponse.DataBean.OrderBean fatherBeanListOne = new QueryOrdersResponse.DataBean.OrderBean();
        QueryOrdersResponse.DataBean.OrderBean productBeanListOne = new QueryOrdersResponse.DataBean.OrderBean();
        if (createOrderVo.getBuyMemberCard() != null && StringUtils.isNotEmpty(createOrderVo.getBuyMemberCard().getRuleId()) && StringUtils.isNotEmpty(createOrderVo.getBuyMemberCard().getPaidId())) {
            //父子订单
            int cardOriginalAmount = shoppingCartGoodsDto.getCardOriginalAmount() == null ? 0 : shoppingCartGoodsDto.getCardOriginalAmount();
            int cardDiscountAmount = shoppingCartGoodsDto.getCardDiscountAmount() == null ? 0 : shoppingCartGoodsDto.getCardDiscountAmount();
            cardAmount = cardOriginalAmount - cardDiscountAmount;
            CreateFatherSonOrderResponse createFatherSonOrderResponse = createFatherSonOrder.apply(null);
            if (ObjectUtils.notEqual(Integer.valueOf(ResponseResult.SUCCESS.getCode()), createFatherSonOrderResponse.getErrcode())) {
                return ResponseUtil.error(createFatherSonOrderResponse.getErrcode().toString(), createFatherSonOrderResponse.getErrmsg());
            }
            List<QueryOrdersResponse.DataBean.OrderBean> orderBeanList = createFatherSonOrderResponse.getOrderBeanList();
            List<QueryOrdersResponse.DataBean.OrderBean> fatherBeanList = orderBeanList.stream().filter(orderBeanTemp -> orderBeanTemp.getIsParent()).collect(Collectors.toList());
            List<QueryOrdersResponse.DataBean.OrderBean> productBeanList = orderBeanList.stream().filter(orderBeanTemp -> 1 == orderBeanTemp.getBizType()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(fatherBeanList)) fatherBeanListOne = fatherBeanList.get(0);
            if (CollectionUtils.isNotEmpty(productBeanList)) productBeanListOne = productBeanList.get(0);
            //订单总金额 商品+会员卡
            totalAmount = orderBeanList.stream().mapToLong(QueryOrdersResponse.DataBean.OrderBean::getAmount).count();
            fatherBeanList.get(0).setShopId(storeResponseDto.getStoreCode());
            fatherBeanList.get(0).setCompanyId(createOrderVo.getPartnerId());
            List<QueryOrdersResponse.DataBean.OrderBean> orderBeans = createFatherSonOrderResponse.getOrderBeanList().stream().filter(orderBeanTemp -> orderBeanTemp.getBizType().equals(1)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(orderBeans)) {
                orderBean = orderBeans.get(0);
            }
        } else {
            //普通订单
            CreateOrderResponse createOrderFlowResponse = createOrder.apply(null);
            if (ObjectUtils.notEqual(Integer.valueOf(ResponseResult.SUCCESS.getCode()), createOrderFlowResponse.getErrcode())) {
                return ResponseUtil.error(createOrderFlowResponse.getErrcode().toString(), createOrderFlowResponse.getErrmsg());
            }
            orderBean = createOrderFlowResponse.getData();
            fatherBeanListOne = orderBean;
            productBeanListOne = orderBean;
            totalAmount = orderBean.getAmount();
        }

        //<!---创建订单公共方法执行逻辑--->
        OrderPayResponse orderPayResponse = null;
        paymentRequest = orderBodyConvertToPaymentBody(userLoginInfoDto, createOrderVo.getPartnerId());
        if (totalAmount < 0) {
            throw new ServiceException(ResponseResult.PAY_AMOUNT_ERROR);
        } else if (totalAmount > 0 && StringUtils.isBlank(createOrderVo.getCardCode())) {
            orderPayResponse = getPreOrderPay(fatherBeanListOne, paymentRequest, LogThreadLocal.getTrackingNo(), cardAmount);
        } else if (totalAmount > 0 && StringUtils.isNotBlank(createOrderVo.getCardCode())) {
            //svc卡支付
            orderPayResponse = svcPay(createOrderVo.getCardCode(), fatherBeanListOne, paymentRequest, LogThreadLocal.getTrackingNo());
        } else {
            // 0元订单如果不需要支付，自定义支付单号
            orderPayResponse = getOrderPayResponse(paymentRequest, fatherBeanListOne);
        }
        if (orderPayResponse == null) {
            return failPreOrderPay(LogThreadLocal.getTrackingNo(), productBeanListOne, createOrderVo.getCardCode());
        }
        createOrderResponse = orderAdapter.convent2CreateFatherSonOrderResponseVo(orderPayResponse, orderBean);
        BaseResponse baseEditResponse = this.updateOrderInfo(orderPayResponse, orderExtInfoDTO, productBeanListOne, LogThreadLocal.getTrackingNo());
        if (baseEditResponse != null) {
            return baseEditResponse;
        }
        if (totalAmount > 0 && StringUtils.isBlank(createOrderVo.getCardCode())) {
            createOrderResponse.setPaySuccess(false);
        } else {
            createOrderResponse.setPaySuccess(true);
        }
        // 推荐优惠插件用户下单数据上报
        wechatPushProcessor.statusOrderCreate(userLoginInfoDto, createOrderResponse.getOid(), createOrderVo.getPartnerId());
        if (!createOrderResponse.getPaySuccess()) {
            return ResponseUtil.success(createOrderResponse);
        } else {
            //如果是商品券支付0元，调用回调接口
            PaysuccessNoticeMessage message = new PaysuccessNoticeMessage();
            message.setResult_code(100);
            message.setOut_trade_no(createOrderResponse.getFmId());
            message.setTrans_id(createOrderResponse.getOid());
            message.setTotal_fee(0);
            message.setOpenid(userLoginInfoDto.getOpenId());
            message.setPlatform_coupon(0);
            message.setMerchant_coupon(0);
            this.paySuccessCallback(message);
            return ResponseUtil.success(createOrderResponse);
        }

    }


    private OrderPayResponse getOrderPayResponse(PaymentRequest paymentRequest, QueryOrdersResponse.DataBean.OrderBean orderBean) {
        OrderPayResponse orderPayResponse;
        String fmId = "SPAY" + ValidationCode.getRandomUuid();
        orderPayResponse = orderAdapter.getOrderPayResponse(orderBean.getCompanyId(), paymentRequest,
                orderBean.getOid(), fmId);
        return orderPayResponse;
    }

    private BaseResponse failPreOrderPay(String trackingNo, QueryOrdersResponse.DataBean.OrderBean orderBean, String cardCode) {
        //失败冲正库存，冲正活动库存，取消订单
        CancelOrderRequest cancelOrderRequest = orderAdapter.convent2CancelOrderRequest(orderBean.getOid(), orderBean.getCompanyId(),
                AfterSalesType.SYSTEM_CANCEL, "异常订单取消", trackingNo, null);
        orderCenterSdkService.orderCancel(cancelOrderRequest);
        // TODO: 2019/9/10 hubowen mq推送变更
        //backOrdersNotifyActivity(orderBean, Arrays.asList(TransTypeEnum.PRODUCT.getCode(),TransTypeEnum.ACTIVITY.getCode()), backOrdersNotifyActivityQueue, backOrdersNotifyActivityExchange);
        backOrdersStatusChange(orderBean.getOid(), orderBean.getStatus());
        //svc 卡支付失败
        if (StringUtils.isNotBlank(cardCode)) {
            return ResponseUtil.error(ResponseResultEnum.PAY_BACKEND_CONFIG_ERROR.getCode(), ResponseResultEnum.PAY_BACKEND_CONFIG_ERROR.getMessage(), null);
        }
        return ResponseUtil.error(ResponseResultEnum.PAY_UNIFIED_ORDER_ERROR.getCode(), ResponseResultEnum.PAY_UNIFIED_ORDER_ERROR.getMessage(), null);
    }

    public OrderPayResponse getPreOrderPay(QueryOrdersResponse.DataBean.OrderBean orderBean, PaymentRequest paymentRequest, String trackingNo, Integer cardAmount) {
        try {
            UnifiedOrderRequest request = orderAdapter.convent2UnifiedOrderRequest(orderBean, paymentRequest, orderBean.getAmount(), cardAmount);
            com.freemud.application.sdk.api.base.BaseResponse<UnifiedOrderResponse> responseBase = standardPaymentService.unifiedOrder(request, trackingNo);
            if (!ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(responseBase.getCode())) {
                return null;
            }
            putDelMq(request.getPartnerId(), request.getStoreId(), responseBase.getData().getFmId(), orderBean.getOid());
            OrderPayResponse orderPayResponse = orderAdapter.convent2OrderPayResponse(responseBase.getData());
            orderPayResponse.setWxAppid(paymentRequest.getWxAppId());
            orderPayResponse.setOpenId(paymentRequest.getOpenId());
            orderPayResponse.setPartnerId(orderBean.getCompanyId());
            orderPayResponse.setOrderId(orderBean.getOid());
            return orderPayResponse;
        } catch (Exception e) {
            LogUtil.error("getPreOrderPay_error", JSONObject.toJSONString(orderBean), JSONObject.toJSONString(paymentRequest));
            //TODO 邮件告警
            return null;
        }
    }

    public OrderPayResponse svcPay(String cardCode, QueryOrdersResponse.DataBean.OrderBean orderBean, PaymentRequest paymentRequest, String trackingNo) {
        CodePayRequest request = new CodePayRequest();
        String partnerId = orderBean.getCompanyId();
        request.setBody("svc储值卡支付");
        request.setBusinessDate(DateUtil.convert2String(new Date(), DateUtil.FORMAT_YYYY_MM_DD_HHMMSS));
        request.setCode(cardCode);
        request.setPartnerId(partnerId);
        request.setStoreId(orderBean.getShopId());
//        request.setStoreId("10086");
        request.setAmount(orderBean.getAmount());
        request.setTransId(orderBean.getOid());
        request.setStationId("1");
        request.setOperatorId("1");
        request.setVer("2");
        SVCCardAmountRequest svcRequest = new SVCCardAmountRequest();
        svcRequest.setPartnerId(partnerId);
        svcRequest.setCardCodes(Arrays.asList(cardCode));
        //查询svc卡余额
        com.freemud.application.sdk.api.base.BaseResponse<SVCCardAmountResponse> svcCardAmountResponseBaseResponse = paymentNewService.querySVCCardAmount(svcRequest, trackingNo);
        if (svcCardAmountResponseBaseResponse == null || !ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(svcCardAmountResponseBaseResponse.getCode())
                || svcCardAmountResponseBaseResponse.getData().getData() == null || CollectionUtils.isEmpty(svcCardAmountResponseBaseResponse.getData().getData().getCardSimpleInfos())) {
            return null;
        }
        Integer amount = svcCardAmountResponseBaseResponse.getData().getData().getCardSimpleInfos().get(0).getAmount();
        Integer vamount = svcCardAmountResponseBaseResponse.getData().getData().getCardSimpleInfos().get(0).getVamount();
        if (amount + vamount < orderBean.getAmount()) {
            return null;
        }
        //svc卡支付
        com.freemud.application.sdk.api.base.BaseResponse<CodePayResponse> responseBase = paymentNewService.codePay(request, trackingNo);
        if (responseBase == null || !ResponseCodeConstant.RESPONSE_SUCCESS_STR.equals(responseBase.getCode()) || responseBase.getData().getData() == null) {
            return null;
        }
        OrderPayResponse orderPayResponse = new OrderPayResponse();
        CodePayResponse.CodePayDate codePayResponse = responseBase.getData().getData();
        orderPayResponse.setFmId(codePayResponse.getFmId());
        orderPayResponse.setPayTransId(codePayResponse.getPayTransId());
        orderPayResponse.setWxAppid(paymentRequest.getWxAppId());
        orderPayResponse.setOpenId(paymentRequest.getOpenId());
        orderPayResponse.setPartnerId(orderBean.getCompanyId());
        orderPayResponse.setOrderId(orderBean.getOid());
        return orderPayResponse;
    }

    private PaymentRequest orderBodyConvertToPaymentBody(UserLoginInfoDto userLoginInfoDto, String partnerId) {
        String wxAppId = userLoginInfoDto.getWxAppid();
        //设置支付信息
        PaymentRequest paymentRequest = new PaymentRequest();
        paymentRequest.setOpenId(userLoginInfoDto.getOpenId());
        paymentRequest.setWxAppId(wxAppId);
        AssortmentOpenPlatformWxapp wxApp = openPlatformWxappManager.findByPartnerIdAndWxappId(partnerId, wxAppId);
        paymentRequest.setPrincipalName(wxApp.getPrincipalName());
        paymentRequest.setReverseNotifyiDcUrl(reverseNotifyiDcUrl);
        return paymentRequest;
    }

    public OrderExtInfoDTO getExtInfo(UserLoginInfoDto userLoginInfoDto, StoreResponse.BizVO storeResponseDto,
                                      Integer pushOrderTime, CreateOrderVo createOrderVo) {

        Integer serviceTime = storeResponseDto.getServiceTime();
        String sessionId = createOrderVo.getSessionId();
        String version = createOrderVo.getVersion();
        CreateOrderVo.BuyMemberCard memberCard = createOrderVo.getBuyMemberCard();

        String deliveryHoursDayStart = "";
        String deliveryHoursDayEnd = "";
        if (StringUtils.isNotBlank(storeResponseDto.getDeliveryHoursDay())) {
            String[] days = storeResponseDto.getDeliveryHoursDay().split("-");
            if (days.length == 2) {
                deliveryHoursDayStart = DateUtil.convert2String(new Date(), DateUtil.FORMAT_yyyyMMdd_date) + " " + days[0] + ":00";
//                deliveryHoursDayEnd = DateUtil.convert2String(new Date(), DateUtil.FORMAT_yyyyMMdd_date) + " " + days[1] + ":00";
            }
        }

        OrderExtInfoDTO orderExtInfoDto = new OrderExtInfoDTO();
        orderExtInfoDto.setDeliveryHoursDayStart(deliveryHoursDayStart);
        orderExtInfoDto.setDeliveryHoursDayEnd(deliveryHoursDayEnd);
        orderExtInfoDto.setOpenid(userLoginInfoDto.getOpenId());
        orderExtInfoDto.setAppid(userLoginInfoDto.getWxAppid());
        orderExtInfoDto.setSessionId(sessionId);
        if (Objects.equals(serviceTime, null)) {
            serviceTime = 50;
        }
        orderExtInfoDto.setServiceTime(serviceTime);
        orderExtInfoDto.setPushOrderTime(pushOrderTime);
        orderExtInfoDto.setVersion(version);
        if (memberCard != null && memberCard.getRuleId() != null) {
            orderExtInfoDto.setRuleId(memberCard.getRuleId());
        }
        return orderExtInfoDto;
    }


    /**
     * 获取商户自定义提示信息配置
     *
     * @param partnerId
     * @return
     */
    public String getDefinitionMsg(String partnerId) {
        String definitionMsgKey = "partner_definition_msg";
        AssortmentOpenPlatformPartnerConfig partnerConfig = openPlatformPartnerConfigManager.selectPartnerConfigByPartnerKey(partnerId, definitionMsgKey, 1);
        if (partnerConfig == null) {
            return null;
        }
        return partnerConfig.getPartnerValue();
    }

    /**
     * 获取桌号
     */
//    public String getTableNumber(String partnerId, String shopId, String tableNumber) {
//        StoreTableNumber storeTableNumber = storeTableNumberManager.selectOne(partnerId, shopId, tableNumber);
//        if (storeTableNumber == null) {
//            return "";
//        }
//        return tableNumber;
//    }

    /**
     * 冲正商品库存，活动库存,商品库存，订单取消，退款
     *
     * @param orderBean 订单信息
     * @param transType TransTypeEnum 冲正类型
     */
    public void backOrdersNotifyActivity(QueryOrdersResponse.DataBean.OrderBean orderBean, List<Integer> transType, String backOrdersNotifyActivityQueue,
                                         String backOrdersNotifyActivityExchange) {
        LogUtil.info("backOrdersNotifyActivity", JSONObject.toJSONString(transType), null);
        if (orderBean == null) {
            return;
        }
        // 删除订单 通知活动添加商品库存
        ActivityCancelStockRequest activityCancelStockRequestDto = activitySdkAdapter.convert2ActivityCancelStockRequestDto(
                orderBean, transType);
        try {
            Header header = new Header(MQAction.INSERT.getAction(), "backOrdersNotifyActivity", orderBean.getOid(), backOrdersNotifyActivityQueue);
            MQMessage<ActivityCancelStockRequest> message = new MQMessage<>(header, activityCancelStockRequestDto);
            mqService.convertAndSend(backOrdersNotifyActivityExchange, backOrdersNotifyActivityQueue, message);
        } catch (Exception e) {
            //TODO 邮件告警
            LogUtil.error("backOrdersNotifyActivity_error", backOrdersNotifyActivityExchange, backOrdersNotifyActivityQueue, e);
        }
    }

    /**
     * 编辑订单，保持预支付信息
     */
    public BaseResponse updateOrderInfo(OrderPayResponse orderPayResponse, OrderExtInfoDTO orderExtInfo
            , QueryOrdersResponse.DataBean.OrderBean orderBean, String trackingNo) {
//        orderExtInfo = orderAdapter.getOrderExtInfo(orderPayResponse, orderExtInfo);
        orderExtInfo.setOpenid(orderPayResponse.getOpenId());
        String prepayId = "";
        // StringUtils 依赖修改
        if (orderPayResponse.getPayOrder() != null && !StringUtils.isEmpty(orderPayResponse.getPayOrder().getPackageX())) {
            String[] prepayIds = orderPayResponse.getPayOrder().getPackageX().split("=");
            prepayId = prepayIds.length > 1 ? prepayIds[1] : "";
        }
        orderExtInfo.setPrepayId(prepayId);

        OrderEditRequest orderEditRequest = new OrderEditRequest(orderPayResponse.getPayTransId(),
                JSONObject.toJSONString(orderExtInfo));
        orderEditRequest.setOrderId(orderBean.getOid());
        orderEditRequest.setTrackingNo(trackingNo);
        BaseOrderResponse baseOrderResponse = orderCenterSdkService.orderEdit(orderEditRequest);
        if (!ObjectUtils.equals(ResponseCodeConstant.RESPONSE_SUCCESS, baseOrderResponse.getErrcode())) {
            CancelOrderRequest cancelOrderRequest = orderAdapter.convent2CancelOrderRequest(orderBean.getOid(), orderBean.getCompanyId(),
                    AfterSalesType.SYSTEM_CANCEL, "异常订单取消", trackingNo, null);
            orderCenterSdkService.orderCancel(cancelOrderRequest);
            //如果编辑订单支付信息失败，冲正
            // backOrdersNotifyActivity(orderBean, Arrays.asList(TransTypeEnum.PRODUCT.getCode(),TransTypeEnum.ACTIVITY.getCode()), backOrdersNotifyActivityQueue, backOrdersNotifyActivityExchange);
            backOrdersStatusChange(orderBean.getOid(), orderBean.getStatus());
            return ResponseUtil.error(baseOrderResponse.getErrcode().toString(), baseOrderResponse.getErrmsg());

        }

        return null;
    }

    public RefundReasonResponseVo getRefundReasonResponseVo(RefundReasonEnum refundReasonEnum) {
        RefundReasonResponseVo refundReasonResponseVo = new RefundReasonResponseVo();
        refundReasonResponseVo.setCode(refundReasonEnum.getCode());
        refundReasonResponseVo.setDesc(refundReasonEnum.getDesc());
        return refundReasonResponseVo;
    }

    /**
     * 通知小助手发送申请退款公众号订阅消息
     * @param orderBean
     */
    public void sendApplyRefundSubscriptionNotice(OrderBean orderBean,OrderRefundRequest request) {
        LogUtil.debug("sendApplyRefundSubscriptionNotice", JSONObject.toJSONString(request), null);
        String partnerId = orderBean.getCompanyId();
        String shopId = orderBean.getShopId();
        if(orderBean.getExtInfo() == null){
            return;
        }
        OrderExtInfoDto extInfo = JSONObject.parseObject(orderBean.getExtInfo(), OrderExtInfoDto.class);
        if(extInfo == null || extInfo.getAppid() == null){
            return;
        }
        AssortmentOpenPlatformWxappAuthorizer authorizerAppid = wxappAuthorizerManager.findAuthorizerByWxAppId(extInfo.getAppid());
        if(authorizerAppid == null){
            return;
        }
        String accessToken = authorizerAppid.getAuthorizerAccessToken();
        String orderId = orderBean.getOid();
        MpTemplateMsg template = new MpTemplateMsg();
        MpTemplateMsg.TemplateMsgData data = new MpTemplateMsg.TemplateMsgData();
        TemplateKeyword first = new TemplateKeyword();
        first.setValue("用户申请退款");
        TemplateKeyword keyword1 = new TemplateKeyword();
        keyword1.setValue(orderId);
        TemplateKeyword keyword2 = new TemplateKeyword();
        Double amount = orderBean.getAmount() / 100.0D;
        keyword2.setValue(amount.toString()+ " 元");
        TemplateKeyword keyword3 = new TemplateKeyword();
        keyword3.setValue(orderBean.getGmtPay() == null ? "" : DateUtil.convert2String(new Date(orderBean.getGmtPay()), "yyyy-MM-dd HH:mm:ss"));
        TemplateKeyword keyword4 = new TemplateKeyword();
        keyword4.setValue(orderBean.getUserName());
        TemplateKeyword keyword5 = new TemplateKeyword();
        keyword5.setValue(orderBean.getPhone());
        TemplateKeyword remark = new TemplateKeyword();
        remark.setValue(request.getReason()+","+request.getRemark());
        data.setFirst(first);
        data.setKeyword1(keyword1);
        data.setKeyword2(keyword2);
        data.setKeyword3(keyword3);
        data.setKeyword4(keyword4);
        data.setKeyword5(keyword5);
        data.setRemark(remark);
        template.setData(data);
        MessagePushNewMqBody messagePushMqBody = new MessagePushNewMqBody();
        messagePushMqBody.setPartnerId(partnerId);
        messagePushMqBody.setAccessToken(accessToken);
        messagePushMqBody.setTemplate(template);
        messagePushMqBody.setStoreId(shopId);
        messagePushMqBody.setOrderId(orderId);
        messagePushMqBody.setWxappid(extInfo.getAppid());
        Header header = new Header(MQAction.INSERT.getAction(), "order-application-service-api", orderId, MessageOfficialRefundPushMqConfig.MESSAGE_PUSH_ORDER_REFUND_QUEUE);
        MQMessage<MessagePushNewMqBody> message = new MQMessage<>(header, messagePushMqBody);
        mqService.convertAndSend(MessageOfficialRefundPushMqConfig.MESSAGE_PUSH_EXCHANGE_TOPIC, MessageOfficialRefundPushMqConfig.MESSAGE_PUSH_ORDER_REFUND_QUEUE_EKY, message);
    }

    /**
     * 申请退款小票打印
     *
     * @param orderBean
     * @param orderRefundVo
     */
    private void printApplyRefundSmallTicket(OrderBean orderBean, OrderRefundVo orderRefundVo) {
        // 有云打印机 打印小票，杯贴
        //GetStoreCloudPrintResponseDto storeCloudPrint;
        try {
            //storeCloudPrint = fmCloudPrintClient.getStoreCloudPrint(new GetStoreCloudPrintDto(orderBean.getCompanyId(), orderBean.getShopId()));
            List<AssortmentCloudPrinter> storePrinters = cloudPrinterManager.getStorePrinters(orderBean.getCompanyId(), orderBean.getShopId());
            if (null != storePrinters && storePrinters.size() > 0) {
                boolean printerStatus = false;
                for (AssortmentCloudPrinter cloudPrinter : storePrinters) {
                    if (null != cloudPrinter.getStatus() && cloudPrinter.getStatus() == 1) {
                        printerStatus = true;
                    }
                }
                //在线打印
                if (printerStatus) {
                    OrderPrintDto orderPrintDto = orderAdapter.convert2OrderPrintDto(orderBean);
                    String reason = orderRefundVo.getReason();
                    if (StringUtils.isNotBlank(orderRefundVo.getRemarks())) {
                        reason = reason + "," + orderRefundVo.getRemarks();
                    }
                    orderPrintDto.setRemark(reason);
                    fmAssistantCloudPrintClient.applyRefundPrint(orderPrintDto);
                }
            }
        } catch (Exception e) {
            LogUtil.error("applyRefundPrint_error", null, null, e);
        }
    }

    /**
     * 历史判断围餐是从userLoginInfoDto判断iappid的。
     * 商城订单从前端传channelType区分，
     * 默认点餐
     */
    private String getQueryOrderChannelType(QueryOrderVo queryOrderVo, AssortmentCustomerInfoVo userLoginInfoDto) {
        String channelType = OrderChannelType.SAAS.getCode();
        if(IappIdType.WC_XCX.getCode().equals(userLoginInfoDto.getIappId())) {
            channelType = OrderChannelType.IWC.getCode();
        } else if(OrderChannelType.MALL.getCode().equals(queryOrderVo.getChannelType())) {
            channelType = OrderChannelType.MALL.getCode();
        }
        return channelType;
    }

}
