package cn.freemud.enums;

import java.util.Arrays;

public enum BusinessTypeEnum {
    SAAS_PICKUP(0,"自提","saas"),
    SAAS_DELIVERY(1,"外卖","saas_delivery"),
    SAAS_MALL(2,"商城","saas_mall"),
    SAAS_WC(3,"围餐","wc");


    private Integer type;
    private String name;
    private String code;

    BusinessTypeEnum(Integer type, String name, String code) {
        this.type = type;
        this.name = name;
        this.code = code;
    }

    public static BusinessTypeEnum getByType(Integer type) {
        return Arrays.stream(BusinessTypeEnum.values())
                .filter(e -> e.type.equals(type))
                .findFirst().orElse(BusinessTypeEnum.SAAS_PICKUP);
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
