/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: 111
 * @Package cn.freemud.entities.dto
 * @Description: 订单其他结算方式
 * @author: liming.guo
 * @date: 2018/5/18 17:06
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.entities.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class CreateOrderAccountDto {
    /**
     *  结算对象ID
     */
    private String accountId;
    /**
     *  结算对象名称
     */
    private String name;
    /**
     *  结算对象类型  1 运费 2折扣 3包装费 4积分 5 优惠券 6线下支付 7 微信 8 支付宝 9 商户金额
     */
    private Integer type;
    /**
     *  结算金额
     */
    private Long price;
    /**
     *  结算数量
     */
    private Integer number;
    /**
     *  排序
     */
    private Integer sequence;
    /**
     * 自定义信息
     */
    private String addInfo;
}
