package cn.freemud.enums;

public enum ApportionType {

    SINGLE_PRODUCT_ACTIVITY(0, "商品类促销"),
    ALL_PRODUCT_ACTIVITY(1, "交易类促销")
    ;

    private Integer code;
    private String desc;

    ApportionType(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ApportionType getByCode(Integer code) {
        for (ApportionType type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
