package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.application.sdk.api.ordercenter.enums.OrderClientType;
import com.freemud.application.sdk.api.ordercenter.request.OrderExtendedReq;
import com.freemud.application.sdk.api.ordercenter.request.create.OrderTaskReq;
import com.freemud.application.sdk.api.promotioncenter.request.promotion.ActivityUpdateStockRequest;
import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import com.freemud.sdk.api.assortment.order.enums.*;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
public class BaseCreateOrderRequest extends BaseConfig {

    /**
     * 商户ID 必填
     */
    private String companyId;
    /**
     * 门店ID
     */
    private String shopId;
    /**
     * 第三方门店
     */
    private String thirdShopId;
    /**
     * 门店名称
     */
    private String shopName;
    /**
     * 用户ID
     */
    private String userId;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 用户电话
     */
    private String phone;

    /**
     * 收货地址 非必填
     */
    private String address;
    /**
     * 收货地址经度 非必填
     */
    private String longitude;
    /**
     * 收获地址维度  非必填
     */
    private String latitude;
    /**
     * 订单类型  1 外卖 2.预订单 3.商城 4 自提
     */
    private QueryOrderType orderType;
    /**
     * 订单状态
     */
    private OldOrderStatus orderStatus;
    /**
     * 支付类型
     */
    private QueryPayType payType;
    /**
     * 支付状态
     */
    private PayStatus payStatus;
    /**
     * 支付渠道号
     */
    private String payChannel;
    /**
     * 支付渠道名称
     */
    private String payChannelName;
    /**
     * 订单来源
     */
    private String source;
    /**
     * 订单来源名称
     */
    private String sourceName;
    /**
     * 期望送达时间
     */
    private Long gmtExpect;
    /**
     * 支付时间
     */
    private Date payTime;

    /**
     * 订单备注
     */
    private String remark;

    /**
     * 实付金额
     */
    private Long amount;
    //桌号
    private String barCounter;
    /**
     * 商品列表
     */
    private List<CreateOrderProductRequest> products;
    /**
     * 其他结算列表
     */
    private List<CreateOrderAccountRequest> accounts;


    public DeliveryTypeInfo addInfo;

    public OrderOtherInfo otherInfo;

    private OrderExtendedReq orderExtended;

    //预订单任务
    private OrderTaskReq orderTask;

    /**
     * 促销活动扣减库存
     */
    public ActivityUpdateStockRequest activityUpdateStockRequest;

    private OrderClientType orderClientType;

    /**
     * 省
     */
    private String province;

    /**
     * 城市
     */
    private String city;

    /**
     * 区
     */
    private String region;

    @Data
    public static class DeliveryTypeInfo {
        /**
         * 订单类型，自配送self，第三方配送third
         */
        private QueryDeliveryType deliveryType;

    }

    @Data
    public static class OrderOtherInfo {
        /**
         * 流程的 sessionId
         */
        private String sessionId;
        /**
         * 版本号
         */
        private String version;
        /**
         * 小程序授权accessToken 可为空
         */
        private String accessToken;
        /**
         * 小程序授权过期时间
         */
        private String expireDate;
        /**
         * 预计送达时间
         */
        private Integer serviceTime;
        /**
         * 第三方外卖定时推单时间
         */
        private Integer pushOrderTime;
        /**
         * 会员规则ID
         */
        private String ruleId;
    }


}
