package cn.freemud.entities.dto;

import lombok.Data;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.6.0
 * @Title: SyncStatusDto
 * @Package cn.freemud.entities.dto
 * @Description: 简单描述下这个类是做什么用的
 * @author: hang.chai
 * @date: 2019/3/12 15:00
 * @Copyright: 2019 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class WechatReportOrderDto {
    /**
     * 商户号
     */
    private String partnerId;
    /**
     * 门店号
     */
    private String shopId;
    /**
     * 微信或支付宝appId
     */
    private String appId;
    /**
     * 非码流水Id
     */
    private String payVoucher;
    /**
     * 子商户号
     */
    private String subMchId;
    /**
     * 子商户APPID,非必填
     */
    private String subAppId;
    /**
     * 门店编号
     */
    private String outShopNo;
    /**
     * 用户子标识 ,非必填
     */
    private String subOpenId;
    /**
     * 登录票据(微信用户登录接口返回的登 录票据 公众号，填写access_token； 小程序，填写session_key；)
     */
    private String loginToken;
    /**
     * 总价,单位为分
     */
    private int totalAmount;
    /**
     * 优惠金额,单位为分
     */
    private int discountAmount;
    /**
     * 实际支付，单位为分
     */
    private int userAmount;
    /**
     * 订单状态 (CREATE_DEAL—用户下单；PAY_SUCCESS—支付完成)
     */
    private Integer status;
    /**
     * 微信支付订单号（status 为 PAY_SUCCESS时必填）
     */
    private String transactionId;
    /**
     * 服务商支付订单号（status为PAY_SUCCESS时 必填）
     */
    private String outTradeNo;
    /**
     * 服务商订单号
     */
    private String outOrderNo;
    /**
     * 菜品列表
     */
    private List<DishInfo> dishList;
    /**
     * 消费人数
     */
    private int peopleCount;
    /**
     * 创建时间 时间戳
     */
    private Long gmtCreate;

    @Data
    public static class DishInfo{
        /**
         * 商户菜品ID
         */
        private String outDishNo;
        /**
         * 菜品名称
         */
        private String name;
        /**
         * 菜品单价,单位为分
         */
        private int price;
        /**
         * 菜品数量
         */
        private float count;
    }
}
