package cn.freemud.entities.dto;

import lombok.Data;

@Data
public class ActivityGetByIdResponseDto {
    private String code;
    private String message;
    private String ver;

    private ActivityDataBean result;

    @Data
    public static class ActivityDataBean {

        /**
         * 活动ID
         */
        private Long id;

        /**
         * 活动名称
         */
        private String activityName;

        /**
         * 活动类型
         */
        private Byte type;

        /**
         * 商户ID
         */
        private String partnerId;

        /**
         * 活动状态，0为未开始，1为已开始，2为已暂停，其他状态为保留
         */
        private String status;

        /**
         * 活动开始时间
         */
        private String startTime;

        /**
         * 活动结束时间
         */
        private String endTime;

        /**
         * 创建时间
         */
        private String createTime;


        /**
         * 创建用户
         */
        private String createUser;

        /**
         * 活动说明
         */
        private String memo;

        /**
         * 活动详细描述
         */
        private String description;

        private ShareConfig shareConfig;

        @Data
        public static class ShareConfig {

            private Long id;
            private Long activityId;

            /**
             * 分享获得的方式：支付后，其他
             */
            private String grantType;

            /**
             * 分享的 红包 券 的份数
             */
            private Long shareCopies;

            /**
             * 每人每天领取券的数量限制
             */
            private Integer dayTimes;

            /**
             * 分享类型： 优惠券，红包
             */
            private String sharType;

            /**
             * 活动图片
             */
            private String picture;

            /**
             * 引导标题
             */
            private String guideTitle;

            /**
             * 引导副标题
             */
            private String guideSubTitle;

            /**
             * 引导图片
             */
            private String guidePicture;

            /**
             * 分享标题
             */
            private String shareTitle;

            /**
             * 分享图片
             */
            private String sharePicture;

            /**
             * 红包图片
             */
            private String redpacketsPicture;

            /**
             * 创建人
             */
            private String createUser;

            private Long createTime;

            private Long updateTime;

        }
    }
}
