package cn.freemud.order.test;

import cn.freemud.amp.EnumEmailAlert;
import cn.freemud.consumer.PushOrderApplication;
import cn.freemud.order.entity.OrderPushLog;
import cn.freemud.order.mapper.OrderPushLogMapper;
import com.freemud.application.sdk.api.service.EmailAlertService;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.Date;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @version V1.0
 * @Title: ${FILE_NAME}
 * @Package com.freemud.mail.core
 * @Description: ${TODO}(用一句话描述该文件做什么)
 * @author: aiqi.gong
 * @date: 2019/3/25 22:18
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@RunWith(SpringRunner.class)
@SpringBootTest(classes = PushOrderApplication.class)
public class TestPushOrder {
    @Autowired
    private OrderPushLogMapper orderPushLogMapper;

    @Autowired
    private EmailAlertService emailAlertService;

    @Test
    public void testInsert() {
        OrderPushLog orderPushLog = new OrderPushLog();
        orderPushLog.setPushDate(new Date());
        orderPushLog.setOrderId("dd");
        orderPushLog.setPartnerId("");
        orderPushLog.setPlatformStoreId("");
        orderPushLog.setRequestBody("");
        orderPushLog.setTraceId("");
        orderPushLogMapper.insert(orderPushLog);
    }
    @Test
    public void EmailAlertServiceTest() {
        emailAlertService.sendEmailAlert(EnumEmailAlert.Description.SendScoreError.getDescription(),
                "测试邮件报警");
    }

}
