package cn.freemud.service.impl;

import cn.freemud.entities.vo.OrderAffirmRequestVO;
import cn.freemud.entities.vo.PaysuccessNoticeMessage;
import cn.freemud.utils.ValidationCode;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class MallOrderServiceImplTest {

    @Autowired
    private MallOrderServiceImpl mallOrderService;


    @Before
    public void before() throws Exception {
    }

    @After
    public void after() throws Exception {
    }


    @Test
    public void testPaySuccess() {
        //0元支付
        String fmId = "SPAY" + ValidationCode.getRandomUuid();
        PaysuccessNoticeMessage message = new PaysuccessNoticeMessage();
        message.setResult_code(100);
        message.setOut_trade_no(fmId);
        message.setTrans_id("16303606485084241800003");
        message.setTotal_fee(0);
        message.setOpenid("oORZK5MHMBm78PO302NdRyzIY5K0");
        message.setPlatform_coupon(0);
        message.setMerchant_coupon(0);
        mallOrderService.paySuccessCallback(message);
    }

    @Test
    public void testAffirm() {
        OrderAffirmRequestVO requestVO = new OrderAffirmRequestVO();
        requestVO.setPartnerId("1864");
        requestVO.setShopId("8899");
        requestVO.setSessionId("123123");
        requestVO.setChannelType("mall");
        requestVO.setOid("16303606485084241800003");
        mallOrderService.orderAffirm(requestVO);
    }
}
