/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: RedisKeyConstant
 * @Package cn.freemud.constant
 * @Description: redisKey相关的常量
 * @author: song.cai
 * @date: 2018/12/17 12:48
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */

package com.freemud.sdk.api.assortment.shoppingcart.constant;

public class RedisKeyConstant {
    /**
     * 用户购物车在redis的key前缀
     */
    public final static String SAAS_SHOPPINGCART_KEY_PREFIX = "saas:user:info:cart:goods:";
    /**
     * 用户购物车在redis的key前缀
     */
    public final static String SAAS_USER_INFO_CART_CARTADDPRODUCT = "saas:user:info:cart:cartAddProduct:goods:";
    /**
     * 用户购物车总价在redis的key前缀
     */
    public final static String SAAS_SHOPPINGCART_AMOUNT_PREFIX = "saas:user:info:cart:amount:goods:";
    /**
     * 商品的信息前缀
     */
    public final static String SAAS_GOODS_KEY_PREFIX = "saas:goods:goods:";

    /**
     * 商品的缓存时间
     */
    public final static long GOODS_CACHE_SECONDS = 10;

    /**
     * kgd:meal:member:{partnerId}:{storeId}:{tableNum}
     * 围餐人员hashKey
     */
    public static final String MEAL_MEMBER_HASH_KEY = "kgd:meal:member:{0}:{1}:{2}";
    /**
     * kgd:meal:cart:ver:{partnerId}:{storeId}:{tableNum}
     * 围餐购物车版本号缓存
     */
    public static final String MEAL_CART_VER_KEY = "kgd:meal:cart:ver:{0}:{1}:{2}";
    /**
     * kgd:meal:cart:{partnerId}:{storeId}:{tableNum}
     * 购物车hashKey
     */
    public final static String MEAL_CART_BASE_HASH_KEY = "kgd:meal:cart:{0}:{1}:{2}";

    /**
     * kgd:meal:lock:{partnerId}:{storeId}:{tableNum}
     * 下单锁定购物车key
     */
    public final static String MEAL_CART_LOCK_KEY = "kgd:meal:lock:{0}:{1}:{2}";

    /**
     * 用户购物车在redis的key前缀（商城购物车）
     */
    public final static String SAAS_MALL_SHOPPINGCART_KEY_PREFIX = "saas:user:info:mall:cart:goods:";
    
    /**
     * 用户购物车总价在redis的key前缀(商城购物车)
     */
    public final static String SAAS_MALL_SHOPPINGCART_AMOUNT_PREFIX = "saas:user:info:mall:cart:amount:goods:";

    /**
     * 点餐门店绑定的商城门店redis的key前缀
     */
    public final static String OPENSTORE_MICROMALL_BIND_STOREID_PREFIX = "openstore:micromall:bind:storeId:";

}
