package com.freemud.sdk.api.assortment.order.request.order;

import com.freemud.sdk.api.assortment.order.config.BaseConfig;
import com.freemud.sdk.api.assortment.order.enums.OldOrderAccountType;
import lombok.Data;

import java.util.List;

@Data
public class ConfirmOrderRequest extends BaseConfig {

    private String partnerId;
    private String storeId;
    private String orderId;
    //老订单状态
    private Integer orderType;

    private String payChannelName;

    private String payVoucher;

    private String completeOrderCode;

    private Integer timeout;
    //实际支付金额
    private String actualPayAmount;
    /**
     * 自定义字段
     */
    private String extInfo;
    //操作人
    private String operator;
    private List<OrderSettlement>orderSettlements;
    @Data
    public static class OrderSettlement{
        /**
         * 优惠结算类型
         */
        private OldOrderAccountType settlementType;

        /**
         * 平台优惠
         */
        private Long platformDiscountAmount;

        /**
         * 商家优惠
         */
        private Long shopDiscountAmount;
        /**
         * 结算金额
         */
        private Long settlementAmount;
        /**
         * 备注
         */
        private String note;

    }
}
