/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: ShoppingCart
 * @Package cn.freemud.controller
 * @Description:
 * @author: ping.wu
 * @date: 2018/5/18 18:07
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.controller;

import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.vo.*;
import cn.freemud.enums.ResponseResult;
import cn.freemud.service.ShoppingCartNewService;
import cn.freemud.service.impl.ShoppingCartMealServiceImpl;
import cn.freemud.service.impl.ShoppingCartNewServiceImpl;
import cn.freemud.utils.ResponseUtil;
import com.freemud.api.assortment.datamanager.entity.vo.AssortmentCustomerInfoVo;
import com.freemud.api.assortment.datamanager.enums.IappIdType;
import com.freemud.api.assortment.datamanager.manager.customer.AssortmentCustomerInfoManager;
import com.freemud.application.sdk.api.base.SDKCommonBaseContextWare;
import com.alibaba.fastjson.JSON;
import com.freemud.application.sdk.api.log.ApiAnnotation;
import com.freemud.application.sdk.api.log.LogParams;
import io.swagger.annotations.Api;
import org.apache.commons.lang.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/shoppingCart", consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(value = "购物车 controller", tags = {"购物车管理接口"})
@Slf4j
public class ShoppingCartController {

    @Autowired
    private AssortmentCustomerInfoManager customerInfoManager;

    /**
     * 从微信卡券向购物车中添加商品
     */
    @ApiAnnotation(logMessage = "addGoodsByCard")
    @PostMapping(value = "/addGoodsByCard")
    public BaseResponse addGoodsByCard(@Validated @LogParams @RequestBody AddGoodsByWeixinCardRequestVo request) {
        return getInstanceBySessionId(request.getSessionId()).addGoodsByCard(request);
    }

    /**
     * 向购物车中添加商品
     */
    @ApiAnnotation(logMessage = "addGoods")
    @PostMapping(value = "/addGoods")
    public BaseResponse addGoods(@Validated @LogParams @RequestBody AddShoppingCartGoodsRequestVo request) {
        return getInstanceBySessionId(request.getSessionId()).addGoods(request);
    }

    /**
     * 修改购物车中商品数量
     */
    @ApiAnnotation(logMessage = "updateGoodsQty")
    @PostMapping(value = "/updateGoodsQty")
    public BaseResponse updateGoodsQty(@Validated @LogParams @RequestBody UpdateShoppingCartGoodsQtyRequestVo request) {
        return getInstanceBySessionId(request.getSessionId()).updateGoodsQty(request);
    }

    /**
     * 查询购物车信息
     */
    @ApiAnnotation(logMessage = "listCartGoods")
    @PostMapping(value = "/listCartGoods")
    public BaseResponse listCartGoods(@Validated @LogParams @RequestBody ShoppingCartInfoRequestVo request) {
        return getInstanceBySessionId(request.getSessionId()).getGoodsList(request);
    }

    /**
     * 查询购车信息无配送费
     * SVC卡支付check，check购物车金额加配送费小于储值卡金额
     */
    @ApiAnnotation(logMessage = "listCartGoodsCheck")
    @PostMapping(value = "/listCartGoodsCheck")
    public BaseResponse listCartGoodsCheck(@Validated @LogParams @RequestBody ShoppingCartInfoRequestVo request) {
        return getInstanceBySessionId(request.getSessionId()).getGoodsListCheck(request);
    }

//    /**
//     * 清空购物车
//     */
//    @PostMapping(value = "/clear")
//    public BaseResponse clear(@Validated @RequestBody ShoppingCartClearRequestVo request) {
//        return shoppingCartService.clear(request);
//    }

    /**
     * 清空购物车
     */
    @ApiAnnotation(logMessage = "clearCartGoods")
    @PostMapping(value = "/clearCartGoods")
    public BaseResponse clearCartGoods(@Validated @LogParams @RequestBody ShoppingCartClearRequestVo request) {
        String sessionId = request.getSessionId();
        if(StringUtils.isEmpty(sessionId)){
            String tableNumber = request.getTableNumber();
            if(StringUtils.isEmpty(tableNumber)){
                return ResponseUtil.error(ResponseResult.PARAMETER_MISSING,"sessionId和tableNumber不能同时为空");
            }
            return getInstanceByIAppId(IappIdType.WC_XCX.getCode()).clear(request);
        }

        return getInstanceBySessionId(sessionId).clear(request);
    }

    /**
     * 获取购物车均摊详情，点 "去支付" 时调用
     *
     * @param getShoppingCartGoodsApportionRequestVo
     * @return
     */
    @ApiAnnotation(logMessage = "getShoppingCartGoodsApportion")
    @PostMapping(value = "/getShoppingCartGoodsApportion")
    public BaseResponse getShoppingCartGoodsApportion(@Validated @LogParams @RequestBody GetShoppingCartGoodsApportionRequestVo getShoppingCartGoodsApportionRequestVo) {
        if (getShoppingCartGoodsApportionRequestVo == null || getShoppingCartGoodsApportionRequestVo.getShoppingCartInfoRequestVo() == null) {
            return ResponseUtil.error(ResponseResult.NOT_LOGIN);
        }
        ShoppingCartInfoRequestVo shoppingCartInfoRequestVo = getShoppingCartGoodsApportionRequestVo.getShoppingCartInfoRequestVo();
        return getInstanceBySessionId(shoppingCartInfoRequestVo.getSessionId()).
                getShoppingCartGoods(shoppingCartInfoRequestVo,
                        getShoppingCartGoodsApportionRequestVo.getPremiumExchangeActivity());
    }


    private ShoppingCartNewService getInstanceBySessionId(String sessionId) {

        AssortmentCustomerInfoVo assortmentCustomerInfoVo = customerInfoManager.getCustomerInfoByObject(sessionId);
        if (assortmentCustomerInfoVo == null || StringUtils.isBlank(assortmentCustomerInfoVo.getIappId())) {
            return getInstanceByIAppId(IappIdType.IBZ_DC_XCX.getCode());
        }
        String iAppId = assortmentCustomerInfoVo.getIappId();
        return getInstanceByIAppId(iAppId);
    }

    private ShoppingCartNewService getInstanceByIAppId(String iAppId) {
        if (IappIdType.WC_XCX.getCode().equals(iAppId)) {
            //围餐
            return SDKCommonBaseContextWare.getBean(ShoppingCartMealServiceImpl.class);
        }
        return SDKCommonBaseContextWare.getBean(ShoppingCartNewServiceImpl.class);
    }

}
