package cn.freemud.order.test;

import cn.freemud.constant.ServiceConstants;
import cn.freemud.consumer.PushOrderApplication;
import com.freemud.application.sdk.api.base.BaseResponse;
import com.freemud.application.sdk.api.membercenter.request.SendExperienceRequest;
import com.freemud.application.sdk.api.membercenter.request.UpGradeRequest;
import com.freemud.application.sdk.api.membercenter.response.SendExperienceResponse;
import com.freemud.application.sdk.api.membercenter.response.UpGradeResponse;
import com.freemud.application.sdk.api.membercenter.service.MemberCenterService;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = PushOrderApplication.class)
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
@Slf4j
public class MemberCenterServiceTest {
    @Autowired
    private MemberCenterService memberCenterService;

    @Test
    public void upGradeTest() {
        UpGradeRequest upGradeRequest = new UpGradeRequest();
        upGradeRequest.setIdempotencyBussinessType(3);
        upGradeRequest.setIdempotencyBussinessId("34234234");
        upGradeRequest.setMemberId("1");
        upGradeRequest.setPartnerId("1864");
        upGradeRequest.setOrderId("34234234");
        String uuid = "dfsadf";
        BaseResponse<UpGradeResponse> baseResponse = memberCenterService.upGrade(upGradeRequest, uuid);
        log.info("单元测试:{}",baseResponse);
        Assert.assertEquals(baseResponse.getCode(), "100");
    }

    @Test
    public void sendExperienceTest() {
        SendExperienceRequest sendExperienceRequest = new SendExperienceRequest();
        sendExperienceRequest.setPartnerId("1864");
        sendExperienceRequest.setMemberId("1");
        sendExperienceRequest.setAmount(11);
        sendExperienceRequest.setChangeType(ServiceConstants.CHANGE_TYPE_1);
        sendExperienceRequest.setOperationType(ServiceConstants.OPERATION_TYPE_1);
        sendExperienceRequest.setOrderId("34234");
        sendExperienceRequest.setIdempotencyBussinessType(ServiceConstants.BUSSINESS_TYPE_2);
        sendExperienceRequest.setIdempotencyBussinessId("34234");
        String trackingNo = "435345";
        BaseResponse<SendExperienceResponse> baseResponse = memberCenterService.sendExperience(sendExperienceRequest, trackingNo);
        log.info("单元测试:{}",baseResponse);
        Assert.assertEquals(baseResponse.getCode(), "100");

    }

}
