/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title: OrderServiceTest
 * @Package cn.freemud.service
 * @Description:
 * @author: liming.guo
 * @date: 2018/5/21 20:04
 * @version V1.0
 * @Copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
package cn.freemud.service;

import cn.freemud.adapter.OrderAdapter;
import cn.freemud.base.entity.BaseResponse;
import cn.freemud.entities.dto.OrderExtInfoDto;
import cn.freemud.entities.dto.OrderRefundDto;
import cn.freemud.entities.dto.QueryOrdersResponseDto;
import cn.freemud.entities.dto.activity.ShareDiscountActivityDto;
import cn.freemud.entities.dto.shoppingCart.ShoppingCartGoodsDto;
import cn.freemud.entities.vo.CheckBeforeCreateOrderRequestVo;
import cn.freemud.entities.vo.CreateOrderVo;
import cn.freemud.enums.ActivityTypeEnum;
import cn.freemud.enums.ApportionType;
import cn.freemud.service.impl.OrderServiceImpl;
import cn.freemud.service.thirdparty.PaymentClient;
import cn.freemud.utils.ValidationCode;
import com.alibaba.fastjson.JSON;
import com.freemud.sdk.api.assortment.order.request.order.AssortmentGroupCreateOrderRequest;
import com.freemud.sdk.api.assortment.order.request.order.AssortmentGroupOrderAffirmRequest;
import com.freemud.sdk.api.assortment.order.request.order.AssortmentGroupOrderClearRequest;
import com.freemud.sdk.api.assortment.order.request.order.CancelOrderRequest;
import com.freemud.sdk.api.assortment.order.response.order.AssortmentAffirmGroupOrderResponse;
import com.freemud.sdk.api.assortment.order.response.order.CreateOrderResponse;
import com.freemud.sdk.api.assortment.order.service.OrderCenterSdkService;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.test.context.junit4.SpringRunner;

import java.util.List;

@RunWith(SpringRunner.class)
@SpringBootTest
@EnableDiscoveryClient
@EnableFeignClients
@EnableAutoConfiguration
public class OrderServiceTest {

    @Autowired
    private PaymentClient paymentClient;
    @Autowired
    private OrderServiceImpl orderService;
    @Autowired
    private OrderAdapter orderAdapter;
    @Autowired
    private OrderCenterSdkService orderCenterSdkService;


    private static Gson gson = new Gson();

    @Test
    public void checkBeforeCreateOrder() {
        CheckBeforeCreateOrderRequestVo requestVo = new CheckBeforeCreateOrderRequestVo();
        requestVo.setSessionId("1374933477d9ae3f68d51fe9cf355015eb5cb325");
        requestVo.setPartnerId("1864");
        requestVo.setShopId("1001");
        BaseResponse baseResponse = orderService.checkBeforeCreateOrder(requestVo);
        System.out.println("baseResponse : " + baseResponse);
    }



    @Test
    public void sendPaySuccessMessage() {
        String prepayId = "wx12172508680782878abdcf7f1397888639";
        String openid = "ob0iP4nIyQrS9Ye-vgKOlsc2QGm8";
        String orderType = "自提";
        String takeCoke = "53102";
        String shopName = "上海区长宁店";
        String shopAddress = "上海长宁区";
        String appid = "wx2eba2ce69704a6c7";
        String secret = "df050cb30e30b51b8133e06d44d72b9a";
        String oid = "324324";
        String partnerId = "1779";
        OrderExtInfoDto orderExtInfoDto = new OrderExtInfoDto();
        orderExtInfoDto.setPrepayId(prepayId);
        orderExtInfoDto.setOpenid(openid);
        orderExtInfoDto.setAppid(appid);
        orderExtInfoDto.setAppsecret(secret);
//        orderService.sendPaySuccessMessage(orderExtInfoDto, partnerId, orderType, takeCoke, shopName, shopAddress, oid, null, "1.5.3");
    }

    @Test
    public void sendPaySuccessMessageTest() {
        OrderExtInfoDto extInfo = new OrderExtInfoDto();
        extInfo.setAppid("wx2a93f36b16608ee8");
        extInfo.setOpenid("orZZ75b7M2rHadusUXfQiZQa01Ys");
        extInfo.setPrepayId("wx292016339756888aa1e321646904902700");
        QueryOrdersResponseDto.DataBean.OrderBean orderBean = new QueryOrdersResponseDto.DataBean.OrderBean();
        orderBean.setExtInfo(JSON.toJSONString(extInfo));
        orderBean.setCompanyId("2282");
        orderBean.setAddress("上海市嘉定区南翔镇");
        orderBean.setDaySeq(11);
        orderBean.setGmtExpect(1559121217000L);
        orderBean.setShopName("蜜雪门店");
        orderBean.setGmtCreate(1559121216000L);
        orderBean.setOid("14583554844933096800002");
        orderBean.setType(5);
        orderBean.setOtherCode("5166");
        orderBean.setAmount(1L);
//        orderService.sendPaySuccessMessage(orderBean);
    }

    @Test
    public void orderRefund() {
        OrderRefundDto orderRefundDto = new OrderRefundDto();
        orderRefundDto.setVer(2);
        orderRefundDto.setReqtype(62);
        orderRefundDto.setUnifyid("66077052-0288-4113-b520-7aeee3ab86cb");
        orderRefundDto.setRefund_id(System.currentTimeMillis() + Long.valueOf(ValidationCode.getRandomNumber(5)));
        orderRefundDto.setStore_id("fm99999");
        orderRefundDto.setStation_id("1");
        orderRefundDto.setOperator_id("1");
        orderRefundDto.setTrans_id("111103004053082672");
        orderRefundDto.setOpenid("ob0iP4nIyQrS9Ye-vgKOlsc2QGm8");
        List<OrderRefundDto.TransactionBean> transactionBeans = Lists.newArrayList();
        OrderRefundDto.TransactionBean transactionBean = new OrderRefundDto.TransactionBean();
        transactionBean.setFmid("ZHL1407O1555433903");
        transactionBean.setRefund_count(1L);
        transactionBeans.add(transactionBean);
        orderRefundDto.setTransactions(transactionBeans);
        String json = paymentClient.orderRefund(orderRefundDto);
        System.out.println("json===" + json);

    }

    @Test
    public void getAccessToken() {
        orderService.getAccessToken("1779", "wx2eba2ce69704a6c7");
    }


    @Test
    public void createOrderTest1() {
        ShoppingCartGoodsDto shoppingCartGoodsDto = new ShoppingCartGoodsDto();
        List<ShoppingCartGoodsDto.CartGoodsDetailDto> products = Lists.newArrayList();
        ShoppingCartGoodsDto.CartGoodsDetailDto cartGoodsDetailDto = new ShoppingCartGoodsDto.CartGoodsDetailDto();
        cartGoodsDetailDto.setSpuId("spu001");
        cartGoodsDetailDto.setSkuId("sku001");
        cartGoodsDetailDto.setSpuName("奶茶");
        cartGoodsDetailDto.setSkuName("奶茶/加椰果");
        cartGoodsDetailDto.setOriginalPrice(100L);
        cartGoodsDetailDto.setQty(2);
        ShoppingCartGoodsDto.CartGoodsDetailDto.CartGoodsExtra cartGoodsExtra = new ShoppingCartGoodsDto.CartGoodsDetailDto.CartGoodsExtra();
        cartGoodsExtra.setAttributeId("00001");
        cartGoodsExtra.setAttributeName("加糖");
        List<ShoppingCartGoodsDto.CartGoodsDetailDto.CartGoodsExtra> cartGoodsExtras = Lists.newArrayList();
        cartGoodsExtras.add(cartGoodsExtra);
        cartGoodsDetailDto.setExtraList(cartGoodsExtras);
        products.add(cartGoodsDetailDto);

//         cartGoodsDetailDto = new ShoppingCartInfoDto.CartGoodsDetailDto();
//        cartGoodsDetailDto.setSpuId("spu001");
//        cartGoodsDetailDto.setSkuId("sku001");
//        cartGoodsDetailDto.setSpuName("奶茶");
//        cartGoodsDetailDto.setSkuName("奶茶/加椰果");
//        cartGoodsDetailDto.setOriginalPrice(100L);
//        cartGoodsDetailDto.setQty(1);
//        cartGoodsExtra = new ShoppingCartInfoDto.CartGoodsDetailDto.CartGoodsExtra();
//        cartGoodsExtra.setAttributeId("00002");
//        cartGoodsExtra.setAttributeName("多糖");
//        cartGoodsExtras = Lists.newArrayList();
//        cartGoodsExtras.add(cartGoodsExtra);
//        cartGoodsDetailDto.setExtraList(cartGoodsExtras);
//        products.add(cartGoodsDetailDto);

        cartGoodsDetailDto = new ShoppingCartGoodsDto.CartGoodsDetailDto();
        cartGoodsDetailDto.setSpuId("spu001");
        cartGoodsDetailDto.setSkuId("sku001");
        cartGoodsDetailDto.setSpuName("奶茶");
        cartGoodsDetailDto.setSkuName("奶茶/加椰果");
        cartGoodsDetailDto.setOriginalPrice(100L);
        cartGoodsDetailDto.setQty(1);
        cartGoodsExtra = new ShoppingCartGoodsDto.CartGoodsDetailDto.CartGoodsExtra();
        cartGoodsExtra.setAttributeId("00003");
        cartGoodsExtra.setAttributeName("常温");
        cartGoodsExtras = Lists.newArrayList();
        cartGoodsExtras.add(cartGoodsExtra);
        cartGoodsDetailDto.setExtraList(cartGoodsExtras);
        products.add(cartGoodsDetailDto);

        shoppingCartGoodsDto.setProducts(products);
        System.out.println("json===" + new Gson().toJson(shoppingCartGoodsDto));
        shoppingCartGoodsDto.setOriginalTotalAmount(200L);
        shoppingCartGoodsDto.setTotalAmount(160L);
        shoppingCartGoodsDto.setTotalDiscountAmount(60L);


        /**
         * 参与活动 限时特价 80 限购1份 满减 180 -20
         */
        List<ShareDiscountActivityDto> shareDiscountActivityDtos = Lists.newArrayList();

        ShareDiscountActivityDto shareDiscountActivityDto = new ShareDiscountActivityDto();
        shareDiscountActivityDto.setSpuId("spu001");
        shareDiscountActivityDto.setGoodsId("sku001");
        shareDiscountActivityDto.setOriginalPrice(100L);
        shareDiscountActivityDto.setGoodsQuantity(3);
        List<ShareDiscountActivityDto.ApportionGood> apportionGoods = Lists.newArrayList();

        ShareDiscountActivityDto.ApportionGood apportionGood = ShareDiscountActivityDto.ApportionGood.builder()
                .goodsId("sku001")
                .originalPrice(100L)
                .nowPrice((160L - 160L * 20 / 260) / 2)
                .apportionAmount(40L + 160L * 20 / 260)
                .goodsQuantity(2)
                .build();
        List<ShareDiscountActivityDto.ApportionGood.ApportionDetail> apportionDetails = Lists.newArrayList();
        ShareDiscountActivityDto.ApportionGood.ApportionDetail apportionDetail = new ShareDiscountActivityDto.ApportionGood.ApportionDetail();
        apportionDetail.setActivityCode("activity1");
        apportionDetail.setActivityName("限时特价80，限购2份");
        apportionDetail.setActivityType(ActivityTypeEnum.TYPE_2.getCode());
        apportionDetail.setApportionType(ApportionType.SINGLE_PRODUCT_ACTIVITY.getCode());
        apportionDetail.setGoodsNowPrice(80L);
        apportionDetail.setActivityApportionAmount(40L);
        apportionDetails.add(apportionDetail);
        apportionDetail = new ShareDiscountActivityDto.ApportionGood.ApportionDetail();
        apportionDetail.setActivityCode("activity2");
        apportionDetail.setActivityName("满减100-20");
        apportionDetail.setActivityType(ActivityTypeEnum.TYPE_12.getCode());
        apportionDetail.setApportionType(ApportionType.ALL_PRODUCT_ACTIVITY.getCode());
        apportionDetail.setGoodsNowPrice(100L);
        apportionDetail.setActivityApportionAmount(160L * 20 / 260);
        apportionDetails.add(apportionDetail);
        apportionGood.setApportionDetails(apportionDetails);

        apportionGoods.add(apportionGood);
        /**
         * --------------------
         */

        apportionGood = ShareDiscountActivityDto.ApportionGood.builder()
                .goodsId("sku001")
                .originalPrice(100L)
                .nowPrice(100 - ((20 - 160L * 20 / 260)))
                .apportionAmount((20 - 160L * 20 / 260))
                .goodsQuantity(1)
                .build();

        apportionDetails = Lists.newArrayList();
        apportionDetail = new ShareDiscountActivityDto.ApportionGood.ApportionDetail();
        apportionDetail.setActivityCode("activity2");
        apportionDetail.setActivityName("满减100-20");
        apportionDetail.setActivityType(ActivityTypeEnum.TYPE_12.getCode());
        apportionDetail.setApportionType(ApportionType.ALL_PRODUCT_ACTIVITY.getCode());
        apportionDetail.setGoodsNowPrice(100L);
        apportionDetail.setActivityApportionAmount((20 - 160L * 20 / 260));
        apportionDetails.add(apportionDetail);
        apportionGood.setApportionDetails(apportionDetails);

        apportionGoods.add(apportionGood);

        shareDiscountActivityDto.setApportionGoods(apportionGoods);
        shareDiscountActivityDtos.add(shareDiscountActivityDto);
        //shoppingCartGoodsDto.setShareDiscountActivityDtos(shareDiscountActivityDtos);


//        List<CreateOrderProductDemoDto> createOrderProductDemoDtos = orderService.createOrderProductDemoDtos(shoppingCartGoodsDto,
//                0L, 0L);
//        System.out.println("json11===" + gson.toJson(createOrderProductDemoDtos));


    }

    @Test
    public void createOrderDtoTest() {
        String createOrderStr = "{\n" +
                "  \"sessionId\": \"b311f516000b539c219aabe9975793ff706b79b3\",\n" +
                "  \"shopId\": \"10086\",\n" +
                "  \"partnerId\": \"1864\",\n" +
                "  \"storeName\": \"我的专属门店\",\n" +
                "  \"userId\": \"115380388035218205\",\n" +
                "  \"userName\": \"Griggles\",\n" +
                "  \"mobile\": \"16602109227\",\n" +
                "  \"channel\": \"saas\",\n" +
                "  \"orderType\": 1,\n" +
                "  \"takeMealTime\": \"\",\n" +
                "  \"takeOut\": 0,\n" +
                "  \"orderRemark\": \"\",\n" +
                "  \"receiveId\": \"915511947946169024\",\n" +
                "  \"couponCode\": \"\",\n" +
                "  \"version\": \"1.5.3\",\n" +
                "  \"formId\": \"5898809489874b0b5a27dc519a43dea4\",\n" +
                "  \"premiumExchangeActivity\": {\n" +
                "    \"activityCode\": \"\",\n" +
                "    \"activityName\": \"\",\n" +
                "    \"products\": []\n" +
                "  }\n" +
                "}";
        String shoppingCartGoodsDtoStr = "{\n" +
                "    \"products\": [\n" +
                "      {\n" +
                "        \"spuId\": \"1207004037991244821\",\n" +
                "        \"skuId\": \"1207004037991244821\",\n" +
                "        \"spuName\": \"买一赠一奶茶\",\n" +
                "        \"skuName\": \"买一赠一奶茶\",\n" +
                "        \"originalPrice\": 200,\n" +
                "        \"picture\": \"https://picture.sandload.cn/蛋糕.jpg\",\n" +
                "        \"qty\": 1,\n" +
                "        \"hasProductCoupon\": false,\n" +
                "        \"extraList\": [\n" +
                "          {\n" +
                "            \"attributeId\": \"123009557252308243\",\n" +
                "            \"attributeName\": \"热\"\n" +
                "          },\n" +
                "          {\n" +
                "            \"attributeId\": \"123013772507905310\",\n" +
                "            \"attributeName\": \"加大杯\"\n" +
                "          }\n" +
                "        ]\n" +
                "      },\n" +
                "      {\n" +
                "        \"spuId\": \"1207004037991244821\",\n" +
                "        \"skuId\": \"1207004037991244821\",\n" +
                "        \"spuName\": \"买一赠一奶茶\",\n" +
                "        \"skuName\": \"买一赠一奶茶\",\n" +
                "        \"originalPrice\": 200,\n" +
                "        \"picture\": \"https://picture.sandload.cn/蛋糕.jpg\",\n" +
                "        \"qty\": 1,\n" +
                "        \"hasProductCoupon\": false,\n" +
                "        \"extraList\": [\n" +
                "          {\n" +
                "            \"attributeId\": \"123009557252308243\",\n" +
                "            \"attributeName\": \"热\"\n" +
                "          },\n" +
                "          {\n" +
                "            \"attributeId\": \"123013772507905310\",\n" +
                "            \"attributeName\": \"加大杯\"\n" +
                "          }\n" +
                "        ]\n" +
                "      }\n" +
                "    ],\n" +
                "    \"originalTotalAmount\": 200,\n" +
                "    \"totalAmount\": 200,\n" +
                "    \"totalDiscountAmount\": 0,\n" +
                "    \"packageAmount\": 0,\n" +
                "    \"shareDiscountActivityDtos\": [\n" +
                "      {\n" +
                "        \"spuId\": \"120700403799124482\",\n" +
                "        \"goodsId\": \"120700403799124482\",\n" +
                "        \"originalPrice\": 200,\n" +
                "        \"goodsQuantity\": 1,\n" +
                "        \"hasProductCoupon\": false,\n" +
                "        \"apportionGoods\": [\n" +
                "          {\n" +
                "            \"goodsId\": \"120700403799124482\",\n" +
                "            \"goodsQuantity\": 1,\n" +
                "            \"nowPrice\": 200,\n" +
                "            \"originalPrice\": 200,\n" +
                "            \"apportionAmount\": 0,\n" +
                "            \"apportionDetails\": [\n" +
                "            ]\n" +
                "          }\n" +
                "        ]\n" +
                "      },\n" +
                "      {\n" +
                "        \"spuId\": \"1207004037991244821\",\n" +
                "        \"goodsId\": \"1207004037991244821\",\n" +
                "        \"originalPrice\": 200,\n" +
                "        \"goodsQuantity\": 1,\n" +
                "        \"hasProductCoupon\": false,\n" +
                "        \"apportionGoods\": [\n" +
                "          {\n" +
                "            \"goodsId\": \"1207004037991244821\",\n" +
                "            \"goodsQuantity\": 1,\n" +
                "            \"nowPrice\": 0,\n" +
                "            \"originalPrice\": 200,\n" +
                "            \"apportionAmount\": 200,\n" +
                "            \"apportionDetails\": [\n" +
                "              {\n" +
                "                \"activityCode\": \"activy1\",\n" +
                "                \"activityType\": 61,\n" +
                "                \"activityName\": \"买一曾一\",\n" +
                "                \"goodsNowPrice\": 0,\n" +
                "                \"activityRebate\": 0,\n" +
                "                \"apportionType\": 0,\n" +
                "                \"activityApportionAmount\": 200\n" +
                "              }\n" +
                "            ]\n" +
                "          }\n" +
                "        ]\n" +
                "      }\n" +
                "    ]\n" +
                "  }";

        CreateOrderVo createOrderVo = gson.fromJson(createOrderStr, CreateOrderVo.class);
        ShoppingCartGoodsDto shoppingCartGoodsDto = gson.fromJson(shoppingCartGoodsDtoStr, ShoppingCartGoodsDto.class);
//        System.out.println("json===" + gson.toJson(orderAdapter.convent2CreateOrderDto(createOrderVo, shoppingCartGoodsDto)));


    }

    @Test
    public void orderRefundTest() {
        String orderRefundStr = "{\"partnerId\":\"1864\",\"afterSalesType\":\"SYSTEM_CANCEL\",\"orderId\":\"143670090595904518\",\"reason\":\"订单异常退款\",\"fmId\":\"SXAB1864O1625498803\",\"orderSdkType\":\"OLD\",\"trackingNo\":\"109e6caecf3e4c34b7ce40d112985687\"}";
        CancelOrderRequest cancelOrderRequest = gson.fromJson(orderRefundStr, CancelOrderRequest.class);
//        BaseOrderResponse baseResponseDto = orderCenterSdkService.orderRefundFlow(cancelOrderRequest);
//        System.out.println("response=" + gson.toJson(baseResponseDto));
    }

    @Test
    public void testCreateGroupOrder(){
        AssortmentGroupCreateOrderRequest groupCreateOrderRequest = new AssortmentGroupCreateOrderRequest();
        groupCreateOrderRequest.setCompanyId("1864");
        groupCreateOrderRequest.setShopId("0011");
        groupCreateOrderRequest.setOrderClient(2);
        CreateOrderResponse createOrderResponse = orderCenterSdkService.createGroupOrder(groupCreateOrderRequest);
        System.out.println("param:"+JSON.toJSONString(createOrderResponse));
    }

    @Test
    public void testAffirmGroupOrder(){
        AssortmentGroupOrderAffirmRequest groupCreateOrderRequest = new AssortmentGroupOrderAffirmRequest();
        groupCreateOrderRequest.setOrderCode("15469038234254573600000");
        AssortmentAffirmGroupOrderResponse createOrderResponse = orderCenterSdkService.affirmGroupOrder(groupCreateOrderRequest);
        System.out.println("param:"+JSON.toJSONString(createOrderResponse));
    }

    @Test
    public void testClearGroupOrder(){
        AssortmentGroupOrderClearRequest groupCreateOrderRequest = new AssortmentGroupOrderClearRequest();
        groupCreateOrderRequest.setOrderCode("15469038234254573600000");
        AssortmentAffirmGroupOrderResponse createOrderResponse = orderCenterSdkService.clearGroupOrder(groupCreateOrderRequest);
        System.out.println("param:"+JSON.toJSONString(createOrderResponse));
    }

}
