package com.freemud.pay.job.service.util;

import com.freemud.pay.job.dao.dbModel.ActiveDM;
import com.freemud.pay.job.dao.dbModel.StoreDM;
import com.freemud.pay.job.entity.PayMessage;
import com.freemud.pay.job.service.IActiveService;
import com.freemud.pay.job.service.IStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.*;
import java.text.SimpleDateFormat;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title:
 * @Package com.freemud.pay
 * @Description:
 * @author: lihui.wang
 * @date:
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class InterrprentUtil {

    protected final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    IStoreService iStoreService;

    @Autowired
    IActiveService iActiveService;


    public String Interrprent(PayMessage payMessage)
    {
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy年MM月dd日 HH:mm");
        SimpleDateFormat dateformat1 = new SimpleDateFormat("MM月dd日");
        SimpleDateFormat dateformat2 = new SimpleDateFormat("yyyy年MM月dd日");

        StoreDM storeDM = iStoreService.selectByStoreIdAndPartnerId(payMessage.getPayMessage().getPartnerid(),payMessage.getPayMessage().getStore_id());

        String templateContent=FileHelper.readToFile("D:\\templates\\"+payMessage.getPayMessageActive().getTemplateid()+".txt");

        templateContent= templateContent.replace("#id#", payMessage.getPayMessage().getId().toString())
//                .replace("#toUserId#", payMessage.getPayMessage().getUserid())
                .replace("#toUserId#", "2088912097512321")
                .replace("#fmId#", payMessage.getPayMessage().getFmid())
                .replace("#shortDate#", dateformat1.format(payMessage.getPayMessage().getCreatedate()))
                .replace("#createDate#", dateformat.format(payMessage.getPayMessage().getCreatedate()))
                .replace("#platfromTranNo#", payMessage.getPayMessage().getPlatformTradeNumber())
                .replace("#amount#", payMessage.getPayMessage().getAmount().toString())
                .replace("#mcoupon#", payMessage.getPayMessage().getmCoupon().toString())
                .replace("#pcoupon#", payMessage.getPayMessage().getpCoupon().toString())
                .replace("#actualPay#", String.valueOf(payMessage.getPayMessage().getAmount() -
                        payMessage.getPayMessage().getpCoupon() -
                        payMessage.getPayMessage().getpCoupon()))
                .replace("#discount#", String.valueOf(payMessage.getPayMessage().getmCoupon() + payMessage.getPayMessage().getpCoupon()))
                .replace("#storeName#", storeDM.getStorename())
                .replace("#templateId#", payMessage.getPayMessageActive().getTemplateid())
                 .replace("#wxMsgActiveId#", payMessage.getPayMessageActive().getWxmsgactiveid()==null?"":payMessage.getPayMessageActive().getWxmsgactiveid());
        if (payMessage.getPayMessageActive().getCouponactiveid()!=null &&payMessage.getPayMessageActive().getCouponactiveid() > 0)
        {
            /**
             * 解密
             */
            EncryptionHelper encryptionHelper = new EncryptionHelper();
            String code = payMessage.getPayMessage().getCode().isEmpty()?null:encryptionHelper.Decode(payMessage.getPayMessage().getCode().trim());
            ActiveDM couponInfo = iActiveService.selectByPrimaryKey(payMessage.getPayMessageActive().getCouponactiveid());
            templateContent = templateContent.replace("#code#", code)
                    .replace("#validFrom#", dateformat2.format(couponInfo.getStartdate()))
                    .replace("#validEnd#", dateformat2.format(couponInfo.getEnddate()));
        }else {
            logger.info("活动券码号为空");
        }
        return templateContent;
    }



}