package com.freemud.pay.job.service.impl;

import com.freemud.pay.job.dao.dbModel.PayMessageActiveDM;
import com.freemud.pay.job.dao.repository.IPayMessageActiveRepository;
import com.freemud.pay.job.entity.BaseParam;
import com.freemud.pay.job.service.IPayMessageActiveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title:
 * @Package com.freemud.pay
 * @Description:
 * @author: lihui.wang
 * @date:
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service("iPayMessageActiveService")
public class PayMessageActiveServiceImpl implements IPayMessageActiveService {

    @Autowired
    IPayMessageActiveRepository iPayMessageActiveRepository;

    @Override
    public PayMessageActiveDM getPayMessageActiveDM(long activeId, BaseParam baseParam){
        Map<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("activeId",activeId);
        paramsMap.put("dbPartition",baseParam.getDbPartition());
        paramsMap.put("linkServer",baseParam.getLinkServer());
        return iPayMessageActiveRepository.getPayMessageActiveDM(paramsMap);
    }
}