package com.freemud.pay.job.dao.repository.impl;

import com.freemud.pay.job.dao.IBaseDao;
import com.freemud.pay.job.dao.dbModel.BaseModel;
import com.freemud.pay.job.dao.dbModel.PayMessageDM;
import com.freemud.pay.job.dao.mapper.PayMessageDMMapper;
import com.freemud.pay.job.dao.repository.IPayMessageRepository;
import com.freemud.pay.job.entity.PayMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title:
 * @Package com.freemud.pay
 * @Description:
 * @author: lihui.wang
 * @date:
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Primary
@Repository
public class PayMessageRepositoryImpl extends BaseRepositoryImpl implements IPayMessageRepository {

    @Autowired
    PayMessageDMMapper payMessageMapper;

    @Override
    protected IBaseDao getDao() {
        return payMessageMapper;
    }

    @Override
    public List<PayMessageDM> getPayMessages(Map<String, Object> paramsMap) {
        return payMessageMapper.getPayMessages(paramsMap);
    }

    @Override
    public int updateMessageStatus(Integer status,Long id) {
        return payMessageMapper.updateMessageStatus(status,id);
    }

    @Override
    public int updateMessageTryTimes(Integer trytimes, Long id) {
        return payMessageMapper.updateMessageTryTimes(trytimes,id);
    }


    @Override
    public PayMessageDM selectById(Long id) {
        return payMessageMapper.selectById(id);
    }

}