package com.freemud.pay.job.dao.repository.impl;

import com.freemud.pay.job.dao.IBaseDao;
import com.freemud.pay.job.dao.dbModel.ActiveDM;
import com.freemud.pay.job.dao.mapper.ActiveDMMapper;
import com.freemud.pay.job.dao.repository.IActiveRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title:
 * @Package com.freemud.pay
 * @Description:
 * @author: lihui.wang
 * @date:
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Primary
@Repository
public class ActiveRepositoryImpl extends BaseRepositoryImpl implements IActiveRepository {

    @Autowired
    ActiveDMMapper activeDMMapper;

    @Override
    protected IBaseDao getDao() {
        return activeDMMapper;
    }

    @Override
    public ActiveDM selectByPrimaryKey(Integer activeid) {
        return this.getById(activeid);
    }

}