package com.freemud.pay.job.dao.repository;

import com.freemud.pay.job.dao.dbModel.BaseModel;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @title: IBaseRepository
 * @package: com.freemud.framework.base
 * @description: ${TODO}(用一句话描述该文件做什么)
 * @author: dengjie<jie.deng @ freemud.cn>
 * @date: 2018/7/30 16:51
 * @version: v1.0
 * @copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface IBaseRepository {
    public <T extends BaseModel> T insert(T model);

    public <T extends BaseModel> T insertWith(T model);

    public <T extends BaseModel> int insertList(List<T> modelList);

    public <T extends BaseModel> int update(T model);

    public <T extends BaseModel> int updateWith(T model);

    public <T extends BaseModel> int delete(T model);

    public int deleteById(Integer id);

    public <T extends BaseModel> T selectOne(T model);

    public <T extends BaseModel> List<T> select(T model);

    public <T extends BaseModel> List<T> selectAll();

    public <T extends BaseModel> int selectCount(T model);

    public <T extends BaseModel> T getById(Integer id);

    public <T extends BaseModel> T getBy(T model);

    public <T extends BaseModel> List<T> queryBy(T model);
}
