package com.freemud.pay.job;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.context.annotation.Bean;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
//import org.apache.http.ssl.SSLContextBuilder;  

@Configurable
public class ConfigBean {

	@Bean(name="sdkRestTemplate")
	public RestTemplate restTemplate() {
		CloseableHttpClient httpClient;
		RestTemplate restTemplate = null;
		try {
			httpClient = HttpClientUtils.acceptsUntrustedCertsHttpClient();
			HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory(
					httpClient);
			restTemplate = new RestTemplate(clientHttpRequestFactory);
		} catch (KeyManagementException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (KeyStoreException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchAlgorithmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return restTemplate;
	}

	/**
	 * ObjectMapper源码注释建议单例化，因为创建成本比较高
	 * 如果config不同可以使用ObjectMapper中的writer()或者reader()
	 * 方法创建出非常轻量化的fluent的ObjectWrite或者ObjectReader来进行自定义配置
	 * 原文请看{@link ObjectMapper}
	 * */
	@Bean(name="soapMapper")
	public ObjectMapper soapMapper(){
		final XmlMapper mapper = new XmlMapper();
		//大驼峰命名
		mapper.setPropertyNamingStrategy(PropertyNamingStrategy.UPPER_CAMEL_CASE);
		//关闭未知属性报错，以免对方升级接口添加字段导致我们挂掉
		mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES,false);
		//针对没有的PropertyName的情况不会创建一个空的标签
		mapper.setDefaultUseWrapper(false);
		return mapper;
	}

}
