package com.freemud.pay.job.service.processorfactory.processimpl;

import com.alibaba.fastjson.JSON;
import com.alipay.api.AlipayClient;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipayMobilePublicMessageSingleSendRequest;
import com.alipay.api.response.AlipayMobilePublicMessageSingleSendResponse;
import com.freemud.pay.job.config.AliPayConfig;
import com.freemud.pay.job.dao.dbModel.PayPlatformAccountDM;
import com.freemud.pay.job.entity.PayMessage;
import com.freemud.pay.job.entity.dto.PayPlatformAcountKey;
import com.freemud.pay.job.service.*;
import com.freemud.pay.job.service.constants.PayPlatformAccountConstans;
import com.freemud.pay.job.service.processorfactory.IMessageProcessor;
import com.freemud.pay.job.service.util.EncryptionHelper;
import com.freemud.pay.job.service.util.FileHelper;
import com.freemud.pay.job.service.util.InterrprentUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title:
 * @Package com.freemud.pay
 * @Description:
 * @author: lihui.wang
 * @date:
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Component
public class AliFuWuChuangSingleMessageSender implements IMessageProcessor {

    protected final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    IPayPlatformAccountService iPayPlatformAccountService;

    @Autowired
    IPayMessageService iPayMessageService;

    @Autowired
    IStoreService iStoreService;

    @Autowired
    IActiveService iActiveService;

    @Autowired
    private AliPayConfig config;

    @Autowired
    private InterrprentUtil interrprentUtil;

    @Override
    public Boolean Process(PayMessage payMessage) {

        logger.info("向第三方发送请求");
        System.out.println(payMessage.getPayMessage().getPartnerid());

        PayPlatformAccountDM payPlatformAccountDM = iPayPlatformAccountService.getPayPlatformAccount(payMessage, PayPlatformAccountConstans.PLATFORM_ALI_FWC);

        if (payPlatformAccountDM == null){
            payMessage.setNoRetry(true);
            logger.info("平台信息为空");
            return false;
        }
        logger.info("获取第三方");
        try {
            String cerfile= FileHelper.readToFile(payPlatformAccountDM.getCerfile()+".pkcs8.pem");

            AlipayClient alipayClient = new DefaultAlipayClient(config.getServerUrl(),payPlatformAccountDM.getPlatformappid(),cerfile);

            logger.info("获取alipayClient成功");

            AlipayMobilePublicMessageSingleSendRequest request = new AlipayMobilePublicMessageSingleSendRequest();

            request.setBizContent(interrprentUtil.Interrprent(payMessage));

            AlipayMobilePublicMessageSingleSendResponse response = alipayClient.execute(request,null,payPlatformAccountDM.getAuthcode());

            if (response.getCode().equals("200")){
                logger.info("requestBdoy:{"+JSON.toJSONString(request)+"}"+"\n"+"responseBody:{"+JSON.toJSONString(response)+"}");
                return true;
            }
            else if (response.getCode() == "12007") //未关注
            {
                iPayMessageService.updateMessageTryTimes(3,payMessage.getPayMessage().getId());
                logger.warn("requestBdoy:{"+JSON.toJSONString(request)+"}"+"\n"+"responseBody:{"+JSON.toJSONString(response)+"}");
                return false;
            }
            else
            {
                logger.error("消息推送状态码未知"+response.getCode());
                logger.warn("requestBdoy:{"+JSON.toJSONString(request)+"}"+"\n"+"responseBody:{"+JSON.toJSONString(response)+"}");
                return false;
            }

        }catch (Exception e){
            e.printStackTrace();
            logger.error("消息推送失败");
            return false;
        }
    }

}