package com.freemud.pay.job.service.processorfactory;

import com.freemud.pay.job.dao.dbModel.PayMessageActiveDM;
import com.freemud.pay.job.dao.dbModel.PayMessageDM;
import com.freemud.pay.job.service.processorfactory.processimpl.AliFuWuChuangSingleMessageSender;
import com.freemud.pay.job.service.processorfactory.processimpl.FamilyMarkLanternSender;
import com.freemud.pay.job.service.util.SpringUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title:
 * @Package com.freemud.pay
 * @Description:
 * @author: lihui.wang
 * @date:
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
public class MessageProcessorFactory {

    protected static final Logger logger = LoggerFactory.getLogger(MessageProcessorFactory.class);

    public static IMessageProcessor GetMessageProcessor( PayMessageActiveDM active)
    {
        if (active == null
                ||  StringUtils.isEmpty(active.getAction()))
        {
            logger.info("推送action为空");
            return null;
        }
        String s = active.getAction().toLowerCase();
        switch (s){
            case "ali.single.send":
                return SpringUtil.getBean(AliFuWuChuangSingleMessageSender.class);
            case "qj.point.send":
                return  SpringUtil.getBean(FamilyMarkLanternSender.class);
                default:
                return null;
        }

//        if ("ali.single.send".equals(s)) {
//            return SpringUtil.getBean(AliFuWuChuangSingleMessageSender.class);
//        } else {
//            return null;
//        }
    }
}