package com.freemud.pay.job.service.impl;

import com.freemud.pay.job.dao.dbModel.PayMessageDM;
import com.freemud.pay.job.dao.dbModel.PayPlatformAccountDM;
import com.freemud.pay.job.dao.repository.PayPlatformAccountRepository;
import com.freemud.pay.job.dao.repository.impl.PayMessageRepositoryImpl;
import com.freemud.pay.job.entity.PayMessage;
import com.freemud.pay.job.entity.dto.PayPlatformAcountKey;
import com.freemud.pay.job.service.IPayMessageService;
import com.freemud.pay.job.service.IPayPlatformAccountService;
import com.freemud.pay.job.service.constants.PayPlatformAccountConstans;
import com.freemud.pay.job.service.util.EncryptionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title:
 * @Package com.freemud.pay
 * @Description:
 * @author: lihui.wang
 * @date:
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Service("iPayPlatformAccountService")
public class PayPlatformAccountServiceImpl implements IPayPlatformAccountService {

    protected final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    PayPlatformAccountRepository payPlatformAccountRepository;

    @Autowired
    IPayMessageService iPayMessageService;

    @Override
    public PayPlatformAccountDM getPayPlatformAccount(PayMessage payMessage,String platform) {
        EncryptionHelper encryptionHelper = new EncryptionHelper();
        List<PayPlatformAccountDM> payPlatformAccountDMList = payPlatformAccountRepository.selectByPartnerId(payMessage.getPayMessage().getPartnerid());

        List<PayPlatformAccountDM> payPlatformAccountDMList1 = new ArrayList<>();
        payPlatformAccountDMList.stream().forEach(p->{
            if(p.getEnable() == true &&  p.getPlatform().equalsIgnoreCase(platform) ){
                if (p != null){
                    payPlatformAccountDMList1.add(p);
                }
            }
        });
        if (payPlatformAccountDMList1.size() > 0){
            PayPlatformAccountDM payPlatformAccountDM = payPlatformAccountDMList1.get(0);
            if(payPlatformAccountDM.getPassword()!=null) {
                payPlatformAccountDM.setPassword(encryptionHelper.Decode(payPlatformAccountDM.getPassword()));
            }
            return payPlatformAccountDM;
        }
        return null;
    }
}