package com.freemud.pay.job.service.impl;


import com.freemud.pay.job.dao.dbModel.PayMessageActiveDM;
import com.freemud.pay.job.dao.dbModel.PayMessageDM;
import com.freemud.pay.job.dao.repository.IPayMessageRepository;
import com.freemud.pay.job.entity.BaseParam;
import com.freemud.pay.job.entity.PayMessage;
import com.freemud.pay.job.service.processorfactory.IMessageProcessor;
import com.freemud.pay.job.service.IPayMessageService;
import com.freemud.pay.job.service.processorfactory.MessageProcessorFactory;
import com.freemud.pay.job.service.IPayMessageActiveService;
import com.freemud.pay.job.service.util.SpringUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title:
 * @Package com.freemud.pay
 * @Description:
 * @author: lihui.wang
 * @date:
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@Primary
@Service("payMessageServiceImpl")
public class PayMessageServiceImpl implements IPayMessageService {

    protected final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    IPayMessageRepository iPayMessageRepository;

    @Autowired
    IPayMessageActiveService iPayMessageActiveService;

    @Override
    public void pushMessage(BaseParam baseParam) {

        String linkServer = baseParam.getLinkServer();
        if (linkServer.isEmpty()){
            linkServer = "";
        }
        else if (!linkServer.endsWith(".")){
            linkServer = linkServer + ".";
        }
        baseParam.setLinkServer(linkServer);
         String dbPartition= baseParam.getDbPartition();

        //第一步：获取数据
        List<PayMessageDM> payMessages=getPayMessages(baseParam);

        if (payMessages.size()>0){
            logger.info("获取payMessage数据成功");
        }

        for (PayMessageDM message :payMessages){

            if (message.getPayMessageActiveId()<0)
            {
                markMessageAsNoProcess(message);
                logger.info("活动ID不存在");
                return;
            }
            PayMessageActiveDM active = iPayMessageActiveService.getPayMessageActiveDM(message.getPayMessageActiveId(),baseParam);
            if (active == null
                    || StringUtils.isEmpty(active.getAction()))
            {
                markMessageAsNoProcess(message);
                logger.info("活动action不存在");
                return;
            }
            boolean result = false;

            try
            {
                IMessageProcessor processor = MessageProcessorFactory.GetMessageProcessor(active);

                PayMessage payMessage=new PayMessage();
                payMessage.setBaseParam(baseParam);
                payMessage.setPayMessage(message);
                payMessage.setPayMessageActive(active);
                result = (processor == null)
                        ? false
                        : processor.Process(payMessage);
                if (result){
                    logger.info("消息推送成功");
                }
            }
            catch (Exception ex)
            {
                //Logger.Warn(string.Format("failed process #{0},exception:{1}", message.Id, ex));
                ex.printStackTrace();
                logger.error("消息推送失败");
            }

            if (result)
            {
                markMessageAsSuccess(message);
            }
            else
            {
                markMessageAsFailed(message);
            }

        }


    }

    @Override
    public int updateMessageStatus(Integer status, Long id) {
        return iPayMessageRepository.updateMessageStatus(status,id);
    }

    private void markMessageAsSuccess(PayMessageDM message) {
        updateMessageStatus(1,message.getId());
    }

    private void markMessageAsFailed(PayMessageDM message) {
        updateMessageStatus(-1,message.getId());
    }


    private void markMessageAsNoProcess(PayMessageDM message) {
        updateMessageStatus(-1,message.getId());
    }


    @Override
    public List<PayMessageDM> getPayMessages(BaseParam baseParam){
        Map<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("dbPartition",baseParam.getDbPartition());
        paramsMap.put("linkServer",baseParam.getLinkServer());
        return iPayMessageRepository.getPayMessages(paramsMap);
    }

    @Override
    public int updateMessageTryTimes(Integer trytimes, Long id) {
        return iPayMessageRepository.updateMessageTryTimes(trytimes,id);
    }

    @Override
    public PayMessageDM selectById(Long id) {
        return iPayMessageRepository.selectById(id);
    }


}