package com.freemud.pay.job.jobhandler;

import com.alibaba.fastjson.JSON;
import com.freemud.pay.job.entity.BaseParam;
import com.freemud.pay.job.service.IPayMessageService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.http.HttpStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @Title:
 * @Package com.freemud.pay
 * @Description:
 * @author: lihui.wang
 * @date:
 * @Copyright: 2017 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目
 */
@JobHandler(value="payMessageJobHandler")
@Component
public class PayMessageJobHandler extends IJobHandler {

    @Autowired
    private IPayMessageService payMessageService;

    @Override
    public ReturnT<String> execute(final String param) throws Exception {
        if(StringUtils.isBlank(param)){
            ReturnT<String> result=new ReturnT<String>();
            result.setCode(500);
            result.setMsg( "参数错误为空");
            return result;
        }
        BaseParam baseRequest=null;
        try {
            System.out.println("param: " + param);
            baseRequest = JSON.parseObject(param,BaseParam.class);
        }catch (Exception ex){

            ReturnT<String> result=new ReturnT<String>();
            result.setCode(500);
            result.setMsg( "参数错误:("+param+")");
            return result;
        }
        XxlJobLogger.log("PAYMESSAGE-JOB, START");
        payMessageService.pushMessage(baseRequest);
        XxlJobLogger.log("PAYMESSAGE-JOB, END");
        return SUCCESS;
    }

}