package com.freemud.pay.job.dao.repository.impl;


import com.freemud.pay.job.dao.IBaseDao;
import com.freemud.pay.job.dao.dbModel.BaseModel;
import com.freemud.pay.job.dao.repository.IBaseRepository;

import java.util.List;

/**
 * All rights Reserved, Designed By www.freemud.cn
 *
 * @title: BaseRepository
 * @package: com.freemud.framework.base.repository.impl
 * @description: ${TODO}(用一句话描述该文件做什么)
 * @author: dengjie<jie.deng @ freemud.cn>
 * @date: 2018/7/30 17:00
 * @version: v1.0
 * @copyright: 2018 www.freemud.cn Inc. All rights reserved.
 * 注意：本内容仅限于上海非码科技内部传阅，禁止外泄以及用于其他的商业目的
 */
public abstract class BaseRepositoryImpl implements IBaseRepository {

    protected abstract IBaseDao getDao();

    @Override
    public <T extends BaseModel> T insert(T model)  {
        getDao().insert(model);
        return model;
    }

    @Override
    public <T extends BaseModel> T insertWith(T model)  {
        getDao().insertSelective(model);
        return model;
    }

    @Override
    public <T extends BaseModel> int insertList(List<T> modelList) {
        return getDao().insertList(modelList);
    }

    @Override
    public <T extends BaseModel> int update(T model)  {
        return getDao().updateByPrimaryKey(model);
    }

    @Override
    public <T extends BaseModel> int updateWith(T model) {
        return getDao().updateByPrimaryKeySelective(model);
    }

    @Override
    public <T extends BaseModel> int delete(T model) {
        return getDao().delete(model);
    }

    @Override
    public int deleteById(Integer id) {
        return getDao().deleteByPrimaryKey(id);
    }

    @Override
    public <T extends BaseModel> T selectOne(T model) {
        return (T) getDao().selectOne(model);
    }

    @Override
    public <T extends BaseModel> List<T> select(T model) {
        return (List<T>) getDao().select(model);
    }

    @Override
    public <T extends BaseModel> List<T> selectAll() {
        return (List<T>) getDao().selectAll();
    }

    @Override
    public <T extends BaseModel> int selectCount(T model) {
        return getDao().selectCount(model);
    }

    @Override
    public <T extends BaseModel> T getById(Integer id) {
        return (T) getDao().selectByPrimaryKey(id);
    }

    @Override
    public <T extends BaseModel> T getBy(T model){
        return (T) getDao().selectOne(model);
    }

    @Override
    public <T extends BaseModel> List<T> queryBy(T model){
        return (List<T>) getDao().select(model);
    }
}
