package cn.freemud.demo;

import cn.freemud.demo.po.User;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import org.junit.Assert;
import org.junit.Test;

import java.util.HashMap;
import java.util.LinkedHashMap;

public class MapTests {

    @Test
    public void Test() {

        //HashMap 无序排列 效率较高
        HashMap<String,User> userHashMap = Maps.newHashMap();
        User user1 = new User(1L,"张三");
        User user2 = new User(2L,"李四");
        User user3 = new User(3L,"王五");
        userHashMap.put("xxx",user1);
        userHashMap.put("aaa",user2);
        userHashMap.put("sss",user3);
        Assert.assertTrue("张三".equals(userHashMap.get("xxx").getUsername()));
        //重复键值不能重复添加，只能后者覆盖前者
        userHashMap.put("xxx",user2);
        System.out.println(userHashMap.get("xxx").getUsername());
        Assert.assertTrue("李四".equals(userHashMap.get("xxx").getUsername()));

        System.out.println(userHashMap);

        //LinkedHashMap 自动排序 效率较低
        LinkedHashMap<String,User> userLinkedHashMap = Maps.newLinkedHashMap();

        userLinkedHashMap.put("xxx",user1);
        userLinkedHashMap.put("aaa",user2);
        userLinkedHashMap.put("sss",user3);

        Assert.assertTrue("张三".equals(userLinkedHashMap.get("xxx").getUsername()));
        System.out.println(userLinkedHashMap);
        Assert.assertEquals(JSON.toJSONString(userLinkedHashMap),"{\"xxx\":{\"id\":1,\"username\":\"张三\"},\"aaa\":{\"id\":2,\"username\":\"李四\"},\"sss\":{\"id\":3,\"username\":\"王五\"}}");


    }
}
