package cn.freemud.demo;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import org.junit.Assert;
import org.junit.Test;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

import static com.google.common.base.Preconditions.*;

public class IOTests {

    @Test
    public void Test(){

        String content = "this is test file.";
        String fileName = "D:/java-traning/test1.md";
        checkNotNull(fileName,"test fileName must not be null.");

        File testFile = new File(fileName);
        try {

            // write file.
            if(testFile.isDirectory()){
                if(testFile.exists()){
                    testFile.delete();
                }
            }
            else{
                testFile.mkdirs();
            }
            Files.write(content,testFile, Charsets.UTF_8);

            // read file

            String readFileContent = Joiner.on("\r\n").join(Files.readLines(testFile,Charsets.UTF_8));

            Assert.assertEquals(content,readFileContent);
        }
        catch (IOException fileIoEx){
            String ss = fileIoEx.toString();
            System.out.print(ss);

        }
    }
}
