package cn.freemud.demo;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import org.junit.Assert;
import org.junit.Test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

import static com.google.common.base.Preconditions.*;

public class IOTests {

    String content = "this is test file.";
    String fileName = "D:/java-training/test1.md";

    @Test
    public void IOFileReadWriteTest(){

        checkNotNull(fileName,"test fileName must not be null.");

        File testFile = new File(fileName);
        try {
            Files.createParentDirs(testFile);
            if(testFile.exists()){
                testFile.delete();
            }
            Files.write(content,testFile, Charsets.UTF_8);

            // read file

            String readFileContent = Joiner.on("\r\n").join(Files.readLines(testFile,Charsets.UTF_8));

            Assert.assertEquals(content,readFileContent);

            // read file use fileInputStream
            FileInputStream fileInputStream = null;
            String fileInputStreamContent = "";
            try {
                fileInputStream = new FileInputStream(testFile);
                byte bytes[]=new byte[1024];
                int n=0;//中间变量，记录实际读入的字节总数
                //循环读取
                while((n=fileInputStream.read(bytes))!=-1) {
                    //read方法：read(byte[] b),最多读取b.length个字节，返回值是实际读入缓冲区的字节总数，
                    //当没有更多的数据时。返回-1

                    fileInputStreamContent=new String(bytes,0,n);//表示从0~读入的总字节数
                    System.out.println(fileInputStreamContent);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }finally {
                //关闭文件流，必须放在这里。
                try {
                    fileInputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

            Assert.assertEquals(fileInputStreamContent,content);

        }
        catch (IOException fileIoEx){
            String ss = fileIoEx.toString();
            System.out.print(ss);

        }
    }

    @Test
    public void IOFileStreamReadWriteTest(){
        File testFile = new File(fileName);
        String copyFileName = "D:/java-training/test1_copy.md";
        String copyFileName2 = "D:/java-training/test1_copy2.md";
        File copyFile = new File(copyFileName);
        File copyFile2 = new File(copyFileName2);
        if(copyFile.exists())
            copyFile.delete();
        if(copyFile2.exists())
            copyFile2.delete();

        FileOutputStream fileOutputStream = null;
        try {
            Files.createParentDirs(copyFile);
            fileOutputStream = new FileOutputStream(copyFile);
            fileOutputStream.write(content.getBytes());
            fileOutputStream.flush();
        }catch (IOException e){
            e.printStackTrace();
        }finally {
            //关闭文件流
            try {
                fileOutputStream.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        FileOutputStream fos = null;
        try {
            FileInputStream fis = new FileInputStream(testFile);
            fos = new FileOutputStream(copyFileName2);
            byte[] buf = new byte[fis.available()];
            fis.read(buf);

            fos.write(buf);
            fos.flush();
        } catch (Exception e) {
            e.printStackTrace();
        }finally {
            //关闭文件流
            try {
                fos.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        Assert.assertTrue(new File(copyFileName).exists());
        Assert.assertTrue(new File(copyFileName2).exists());

    }
}
