package cn.freemud.demo;

import cn.freemud.demo.po.User;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import org.junit.Assert;
import org.junit.Test;

import java.util.*;

public class CollectionTests {

    User zs = new User(1L,"张三");
    User ls = new User(2L,"李四");
    User ww = new User(3L,"王五");
    User zl = new User(4L,"郑六");
    @Test
    public void LinkedListTest(){
        //LinkedList
        LinkedList<User> userLinkedList = Lists.newLinkedList();

        // LinkedList 可重复
        userLinkedList.add(zs);
        userLinkedList.add(zs);
        userLinkedList.add(ls);
        userLinkedList.add(ww);
        userLinkedList.add(zl);

        Integer i = 0;
        for (Iterator<User> iter = userLinkedList.iterator(); iter.hasNext();){
            User currentUser = iter.next();
            System.out.printf("index:%d,value:%s \r\n",i, JSON.toJSONString(currentUser));
            i++;
        }

        Assert.assertSame(userLinkedList.get(0),userLinkedList.get(1));


        // LinkedList 先后有序保存
        userLinkedList.removeFirst();
        userLinkedList.removeLast();
        LinkedList<User> ckUsers = Lists.newLinkedList();
        ckUsers.add(zs);
        ckUsers.add(ls);
        ckUsers.add(ww);

        Assert.assertEquals(JSON.toJSONString(userLinkedList),JSON.toJSONString(ckUsers));

        ckUsers.add(zl);
        Assert.assertNotEquals(JSON.toJSONString(userLinkedList),JSON.toJSONString(ckUsers));
    }

    @Test
    public void ArrayListTest(){

        //ArrayList

        ArrayList<User> userArrayList = Lists.newArrayList();

        userArrayList.add(zs);

        User ss = userArrayList.get(0);

        Assert.assertSame(zs,ss);




    }

    @Test
    public void HashSetTest(){
        //HashSet

        HashSet<Long> userHashSet = Sets.newHashSet();

        // HashSet 自动去重，并内部排序
        userHashSet.add(1L);
        userHashSet.add(2L);
        userHashSet.add(1L);

        System.out.println(JSON.toJSONString(userHashSet));

        Assert.assertEquals(JSON.toJSONString(userHashSet),"[1,2]");
    }
}
