/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.combobox;

import com.nepxion.swing.combobox.ComboBoxManager;
import com.nepxion.swing.dimension.DimensionManager;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicComboPopup;

public class JBasicComboBox
extends JComboBox {
    private int popupMenuWidth = 0;
    private boolean isPopupMenuShownUp = false;

    public JBasicComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.initComponents();
    }

    public JBasicComboBox(Object[] items) {
        super(items);
        this.initComponents();
    }

    public JBasicComboBox(Vector items) {
        super(items);
        this.initComponents();
    }

    public JBasicComboBox() {
        this.initComponents();
    }

    private void initComponents() {
        ComboBoxManager.setPreferenceStyle(this);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.setFocusable(true);
    }

    public int getPopupMenuWidth() {
        return this.popupMenuWidth;
    }

    public void setPopupMenuWidth(int popupMenuWidth) {
        this.popupMenuWidth = popupMenuWidth;
    }

    public boolean isPopupMenuShownUp() {
        return this.isPopupMenuShownUp;
    }

    public void setPopupMenuShownUp(boolean isPopupMenuShownUp) {
        this.isPopupMenuShownUp = isPopupMenuShownUp;
    }

    @Override
    public void firePopupMenuWillBecomeVisible() {
        if (this.popupMenuWidth > 0 || this.isPopupMenuShownUp) {
            BasicComboPopup comboPopup = (BasicComboPopup)this.getUI().getAccessibleChild(this, 0);
            JScrollPane scrollPane = (JScrollPane)comboPopup.getComponent(0);
            if (this.popupMenuWidth > 0) {
                Dimension popupSize = new Dimension(this.popupMenuWidth, comboPopup.getPreferredSize().height);
                DimensionManager.setDimension(scrollPane, popupSize);
            }
            if (this.isPopupMenuShownUp) {
                int height = comboPopup.getHeight();
                if (height == 0) {
                    height = comboPopup.getPreferredSize().height;
                }
                comboPopup.setLocation(this.getLocationOnScreen().x, this.getLocationOnScreen().y - height);
            }
        }
        super.firePopupMenuWillBecomeVisible();
    }
}

