/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.network.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import twaver.Grid;
import twaver.base.A.H.I;
import twaver.web.svg.network.SVGContext;
import twaver.web.svg.network.SVGStruct;
import twaver.web.svg.network.TSVGNetwork;
import twaver.web.svg.network.ui.NodeSVGUI;

public class GridSVGUI
extends NodeSVGUI {
    private static final String Z = "Grid";

    public GridSVGUI(TSVGNetwork network, Grid grid) {
        super(network, grid);
    }

    protected void prepareElementSVGHeader(SVGContext context, StringBuffer head) {
        super.prepareElementSVGHeader(context, head);
        this.appendClassName(head);
    }

    protected void appendClassName(StringBuffer head) {
        I.B(head, Z);
    }

    public Grid getGrid() {
        return (Grid)this.element;
    }

    protected SVGStruct toDefaultBodySVG(SVGContext context) {
        SVGStruct struct = super.toDefaultBodySVG(context);
        Grid grid = this.getGrid();
        Color elementBodyColor = this.getPaintBodyColor(grid.getBodyColor());
        if (elementBodyColor != null && grid.isPaintCell()) {
            int i2;
            int rowCount = grid.getRowCount();
            int columnCount = grid.getColumnCount();
            float alpha = this.getRenderAlpha();
            StringBuffer sb = new StringBuffer(struct.getSvg());
            for (i2 = 0; i2 < columnCount; ++i2) {
                for (int j2 = 0; j2 < rowCount; ++j2) {
                    Rectangle rect = grid.getCellRect(i2, j2);
                    I.A(context, sb, elementBodyColor, rect.x, rect.y, rect.width, rect.height, false, alpha);
                }
            }
            if (this.network.isResizable(grid)) {
                Rectangle rect;
                StringBuffer attribute;
                if (columnCount > 1) {
                    for (i2 = columnCount - 1; i2 >= 0; --i2) {
                        StringBuffer esb = new StringBuffer();
                        attribute = new StringBuffer();
                        attribute.append(" opacity='0' type='gridcellinduce'");
                        rect = this.A(grid, i2);
                        attribute.append(" rowIndex='-1' columnIndex='" + i2 + "' cx ='" + rect.x + "' cy='" + rect.y + "' cwidth = '" + rect.width + "' cheight='" + rect.height + "'");
                        rect = this.D(grid, i2);
                        esb.append(I.A(context, null, rect, (Object)Color.BLACK, (Object)Color.BLACK, (Object)new BasicStroke(3.0f), 1.0f, 0.0, null).append(attribute.toString()).append("/>\n"));
                        sb.append(esb);
                    }
                }
                if (rowCount > 1) {
                    for (i2 = rowCount - 1; i2 >= 0; --i2) {
                        StringBuffer esb = new StringBuffer();
                        attribute = new StringBuffer();
                        rect = this.B(grid, i2);
                        attribute.append(" opacity='0' type='gridcellinduce'");
                        attribute.append(" rowIndex='" + i2 + "' columnIndex='" + -1 + "' cx ='" + rect.x + "' cy='" + rect.y + "' cwidth = '" + rect.width + "' cheight='" + rect.height + "'");
                        rect = this.C(grid, i2);
                        esb.append(I.A(context, null, rect, (Object)Color.BLACK, (Object)Color.BLACK, (Object)new BasicStroke(3.0f), 1.0f, 0.0, null).append(attribute.toString()).append("/>\n"));
                        sb.append(esb);
                    }
                }
            }
            struct.setSvg(sb.toString());
        }
        return struct;
    }

    private Rectangle D(Grid grid, int columnIndex) {
        Rectangle2D.Double cellBounds = grid.getCellBounds(columnIndex, 0);
        Rectangle r2d = new Rectangle();
        r2d.x = (int)(cellBounds.x + cellBounds.width - 1.0);
        r2d.y = (int)cellBounds.y;
        Insets border = grid.getBorder();
        int h2 = grid.getHeight() - (border.top + border.bottom);
        r2d.width = 2;
        r2d.height = h2;
        return r2d;
    }

    private Rectangle C(Grid grid, int rowIndex) {
        int w;
        Rectangle2D.Double cellBounds = grid.getCellBounds(0, rowIndex);
        Rectangle r2d = new Rectangle();
        r2d.x = (int)cellBounds.x;
        r2d.y = (int)(cellBounds.y + cellBounds.height - 1.0);
        Insets border = grid.getBorder();
        r2d.width = w = grid.getWidth() - (border.left + border.right);
        r2d.height = 2;
        return r2d;
    }

    private Rectangle B(Grid grid, int rowIndex) {
        int w;
        Rectangle2D.Double cellBounds = grid.getCellBounds(0, rowIndex);
        Rectangle r2d = new Rectangle();
        r2d.x = (int)cellBounds.x;
        r2d.y = (int)cellBounds.y;
        Insets border = grid.getBorder();
        r2d.width = w = grid.getWidth() - (border.left + border.right);
        r2d.height = (int)cellBounds.height;
        return r2d;
    }

    private Rectangle A(Grid grid, int columnIndex) {
        Rectangle2D.Double cellBounds = grid.getCellBounds(columnIndex, 0);
        Rectangle r2d = new Rectangle();
        r2d.x = (int)cellBounds.x;
        r2d.y = (int)cellBounds.y;
        Insets border = grid.getBorder();
        int h2 = grid.getHeight() - (border.top + border.bottom);
        r2d.width = (int)cellBounds.width;
        r2d.height = h2;
        return r2d;
    }
}

