/*
 * Decompiled with CFR 0.152.
 */
package twaver.web.svg.chart;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import twaver.Element;
import twaver.TDataBox;
import twaver.TUIManager;
import twaver.base.A.H.I;
import twaver.chart.Marker;
import twaver.web.svg.chart.AbstractSVGChart;
import twaver.web.svg.network.SVGContext;

public abstract class AbstractSVGScaleChart
extends AbstractSVGChart {
    protected boolean xAxisVisible = TUIManager.getBoolean("tchart.xaxis.visible");
    protected Color xAxisFillColor = TUIManager.getColor("tchart.xaxis.fill.color");
    protected Color xAxisOutlineColor = TUIManager.getColor("tchart.xaxis.outline.color");
    protected Font xAxisTextFont = TUIManager.getFont("tchart.xaxis.text.font");
    protected Color xAxisTextColor = TUIManager.getColor("tchart.xaxis.text.color");
    protected String xAxisText = TUIManager.getString("tchart.xaxis.text");
    protected double xAxisValue = TUIManager.getDouble("tchart.xaxis.value");
    protected String xAxisStroke = TUIManager.getString("tchart.xaxis.stroke");
    protected boolean yAxisVisible = TUIManager.getBoolean("tchart.yaxis.visible");
    protected Color yAxisFillColor = TUIManager.getColor("tchart.yaxis.fill.color");
    protected Color yAxisOutlineColor = TUIManager.getColor("tchart.yaxis.outline.color");
    protected Font yAxisTextFont = TUIManager.getFont("tchart.yaxis.text.font");
    protected Color yAxisTextColor = TUIManager.getColor("tchart.yaxis.text.color");
    protected String yAxisText = TUIManager.getString("tchart.yaxis.text");
    protected int yAxisTextOrientation = 2;
    protected String yAxisStroke = TUIManager.getString("tchart.yaxis.stroke");
    protected int yAxisTextGap = 5;
    protected String yScaleLineStroke = TUIManager.getString("tchart.yscale.line.stroke");
    protected Color yScaleLineColor = TUIManager.getColor("tchart.yscale.line.color");
    protected boolean yScaleLineVisible = TUIManager.getBoolean("tchart.yscale.line.visible");
    protected int yScalePixelGap = TUIManager.getInt("tchart.yscale.pixel.gap");
    protected double yScaleValueGap = TUIManager.getDouble("tchart.yscale.value.gap");
    protected boolean yScaleMinTextVisible = TUIManager.getBoolean("tchart.yscale.min.text.visible");
    protected boolean yScaleTextVisible = TUIManager.getBoolean("tchart.yscale.text.visible");
    protected boolean yScaleTextInside = TUIManager.getBoolean("tchart.yscale.text.inside");
    protected NumberFormat yScaleTextFormat = TUIManager.getNumberFormat("tchart.yscale.text.format");
    protected Color yScaleTextColor = TUIManager.getColor("tchart.yscale.text.color");
    protected Font yScaleTextFont = TUIManager.getFont("tchart.yscale.text.font");
    protected Font xScaleTextFont = TUIManager.getFont("tchart.xscale.text.font");
    protected Color xScaleTextColor = TUIManager.getColor("tchart.xscale.text.color");
    protected boolean xScaleTextVisible = TUIManager.getBoolean("tchart.xscale.text.visible");
    protected int xScaleTextOrientation = TUIManager.getInt("tchart.xscale.text.orientation");
    protected List xScaleTextList = null;
    protected boolean yScaleValueGapAutoCalculate = TUIManager.getBoolean("tchart.yscale.value.gap.auto.calculate");
    protected boolean yscaleAutoCaculateFlag = false;
    protected int startIndex = 0;
    protected int endIndex = Integer.MAX_VALUE;
    protected int valueSpanCount = 1;
    protected int xScaleTextSpanCount = -1;
    protected List markers = null;
    boolean \u012f = true;

    public AbstractSVGScaleChart(TDataBox box) {
        super(box, null, null);
    }

    public AbstractSVGScaleChart(TDataBox box, String title, Color backgroundColor) {
        super(box, title, backgroundColor, null);
    }

    public AbstractSVGScaleChart(TDataBox box, String title, Color backgroundColor, Color foregroundColor) {
        super(box, title, backgroundColor, foregroundColor);
    }

    public StringBuffer toSVGContent(SVGContext context, int width, int height) {
        StringBuffer result = new StringBuffer();
        this.paintChart(context, result, width, height);
        return result;
    }

    public void paintChart(SVGContext context, StringBuffer result, int width, int height) {
        double valueGap;
        double pixelGap;
        int yAxisTextGapTemp;
        boolean drawYAxisText;
        int xAxisTextGap;
        boolean drawXAxisText;
        boolean bl = drawXAxisText = this.xAxisText != null && !this.xAxisText.trim().equals("");
        if (drawXAxisText) {
            Dimension size = this.A(this.xAxisText, this.xAxisTextFont);
            xAxisTextGap = size.height + this.getXAxisExtraGap();
        } else {
            xAxisTextGap = this.getXAxisExtraGap();
        }
        int baseLine = height - this.yGap - xAxisTextGap - this.shadowOffset;
        int yAxisHeight = height - 2 * this.yGap - this.shadowOffset - xAxisTextGap;
        boolean bl2 = drawYAxisText = this.yAxisText != null && !this.yAxisText.trim().equals("");
        if (drawYAxisText) {
            Dimension size = this.A(3, this.yAxisText, this.yAxisTextFont);
            yAxisTextGapTemp = size.width;
        } else {
            yAxisTextGapTemp = 0;
        }
        if (this.yScaleValueGap > 0.0) {
            pixelGap = Math.max(this.yScaleValueGap / this.range * this.toValidHeight(yAxisHeight), 1.0);
            valueGap = this.yScaleValueGap;
        } else {
            pixelGap = Math.max(this.yScalePixelGap, 1);
            valueGap = this.range * (pixelGap / this.toValidHeight(yAxisHeight));
        }
        int maxYScaleTextGap = 0;
        if (this.yScaleTextVisible && this.yScaleTextColor != null && this.yScaleTextFont != null) {
            String text;
            double value;
            double lineCursor;
            if (!this.yScaleTextInside) {
                lineCursor = this.yScaleMinTextVisible ? 0.0 : pixelGap;
                value = this.min + (this.yScaleMinTextVisible ? 0.0 : valueGap);
                while (lineCursor <= (double)(yAxisHeight + 1)) {
                    text = this.getFormatedYScaleText(value);
                    Dimension size = this.A(text, this.yScaleTextFont);
                    if (size.width > maxYScaleTextGap) {
                        maxYScaleTextGap = size.width;
                    }
                    lineCursor += pixelGap;
                    value += valueGap;
                }
            }
            lineCursor = this.yScaleMinTextVisible ? 0.0 : pixelGap;
            value = this.min + (this.yScaleMinTextVisible ? 0.0 : valueGap);
            while (lineCursor <= (double)(yAxisHeight + 1)) {
                int y;
                int x;
                text = this.getFormatedYScaleText(value);
                if (this.yScaleTextInside) {
                    x = this.xGap + yAxisTextGapTemp + this.shadowOffset;
                    y = baseLine - (int)lineCursor;
                    I.A(context, result, text, this.yScaleTextColor, this.yScaleTextFont, x + this.textGap, y + 2, 7);
                } else {
                    x = this.xGap + yAxisTextGapTemp + maxYScaleTextGap;
                    y = baseLine - (int)lineCursor + this.shadowOffset;
                    I.A(context, result, text, this.yScaleTextColor, this.yScaleTextFont, x - this.textGap, y, 4);
                }
                lineCursor += pixelGap;
                value += valueGap;
            }
        }
        int yAxisTextGap = yAxisTextGapTemp + maxYScaleTextGap;
        int xAxisWidth = width - 2 * this.xGap - this.shadowOffset - yAxisTextGap;
        this.backgroundBounds.x = this.xGap + yAxisTextGap + this.shadowOffset;
        this.backgroundBounds.y = this.yGap;
        this.backgroundBounds.width = xAxisWidth;
        this.backgroundBounds.height = yAxisHeight;
        this.paintBackground(context, result);
        if (drawYAxisText) {
            double yaxisTextWidth = this.A(this.yAxisText, this.yAxisTextFont).getWidth();
            int xText = (int)((double)this.xGap + this.A(this.yAxisText, this.yAxisTextFont).getHeight() - 2.0);
            int yText = (int)((double)(yAxisHeight / 2 + this.shadowOffset + this.yGap) + yaxisTextWidth / 2.0);
            I.A(context, result, this.yAxisText, this.yAxisTextColor, this.yAxisTextFont, xText, yText, 3, 5);
        }
        if (this.yAxisVisible) {
            GeneralPath yAxis = new GeneralPath();
            yAxis.moveTo(this.xGap + yAxisTextGap, this.yGap + this.shadowOffset);
            yAxis.lineTo(this.xGap + yAxisTextGap, height - this.yGap - xAxisTextGap);
            yAxis.lineTo(this.xGap + yAxisTextGap + this.shadowOffset, height - this.yGap - xAxisTextGap - this.shadowOffset);
            yAxis.lineTo(this.xGap + yAxisTextGap + this.shadowOffset, this.yGap);
            yAxis.closePath();
            if (this.yAxisFillColor != null && this.shadowOffset > 0) {
                I.A(context, result, yAxis, this.yAxisFillColor);
            }
            if (this.yAxisStroke != null && this.yAxisOutlineColor != null) {
                I.A(context, result, yAxis, this.yAxisOutlineColor, TUIManager.getStrokeByType(this.yAxisStroke));
            }
        }
        if (this.yScaleLineVisible && this.yScaleLineStroke != null && this.yScaleLineColor != null) {
            for (double lineCursor = 0.0; lineCursor <= (double)(yAxisHeight + 1); lineCursor += pixelGap) {
                Line2D.Double line = new Line2D.Double(this.xGap + yAxisTextGap + this.shadowOffset, baseLine - (int)lineCursor, width - this.xGap, baseLine - (int)lineCursor);
                I.A(context, result, line, this.yScaleLineColor, TUIManager.getStrokeByType(this.yScaleLineStroke));
                if (this.shadowOffset <= 0) continue;
                line = new Line2D.Double(this.xGap + yAxisTextGap + this.shadowOffset, baseLine - (int)lineCursor, this.xGap + yAxisTextGap, baseLine - (int)lineCursor + this.shadowOffset);
                I.A(context, result, line, this.yScaleLineColor, TUIManager.getStrokeByType(this.yScaleLineStroke));
            }
        }
        if (drawXAxisText) {
            int xText = xAxisWidth / 2 + this.xGap + yAxisTextGap;
            int yText = height - this.yGap;
            I.A(context, result, this.xAxisText, this.xAxisTextColor, this.xAxisTextFont, xText, yText, 2);
        }
        if (this.xAxisVisible && this.\u012f) {
            this.paintXAxis(context, result, null, width, height, yAxisTextGap, xAxisTextGap, pixelGap, valueGap);
        }
        if (this.markers != null) {
            Iterator it = this.markers.iterator();
            while (it.hasNext()) {
                Marker marker = (Marker)it.next();
                this.paintXAxis(context, result, marker, width, height, yAxisTextGap, xAxisTextGap, pixelGap, valueGap);
            }
        }
        this.paintContent(context, result, width, height, yAxisTextGap, xAxisTextGap, xAxisWidth, yAxisHeight, baseLine, pixelGap, valueGap);
    }

    protected abstract void paintContent(SVGContext var1, StringBuffer var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, double var10, double var12);

    protected void paintXAxis(SVGContext context, StringBuffer result, Marker marker, int width, int height, int xTextGap, int yTextGap, double pixelGap, double valueGap) {
        Color outlineColor;
        Color fillColor;
        Stroke stroke;
        double value;
        if (marker == null) {
            value = this.xAxisValue == -1.7976931348623157E308 ? this.min : this.xAxisValue;
            stroke = TUIManager.getStrokeByType(this.xAxisStroke);
            fillColor = this.xAxisFillColor;
            outlineColor = this.xAxisOutlineColor;
        } else {
            value = marker.getValue();
            stroke = TUIManager.getStrokeByType(marker.getStroke());
            fillColor = null;
            outlineColor = marker.getColor();
        }
        int h2 = -((int)((value - this.min) / valueGap * pixelGap));
        GeneralPath xAxis = new GeneralPath();
        xAxis.moveTo(this.xGap + xTextGap, height - this.yGap - yTextGap + h2);
        xAxis.lineTo(this.xGap + xTextGap + this.shadowOffset, height - this.yGap - yTextGap - this.shadowOffset + h2);
        xAxis.lineTo(width - this.xGap, height - this.yGap - yTextGap - this.shadowOffset + h2);
        xAxis.lineTo(width - this.xGap - this.shadowOffset, height - this.yGap - yTextGap + h2);
        xAxis.closePath();
        I.A(context, result, xAxis, (Object)fillColor, (Object)outlineColor, (Object)stroke, 0.3f, 0.0, null);
        if (marker != null) {
            int x = this.xGap + xTextGap + this.shadowOffset + marker.getXOffset();
            int y = height - this.yGap - yTextGap - this.shadowOffset + h2 + marker.getYOffset() + 2;
            I.A(context, result, marker.getText(), marker.getTextColor(), marker.getTextFont(), x, y, 1, 5);
        }
    }

    protected double toValidHeight(double height) {
        if (this.upperLimit == -1.7976931348623157E308) {
            return height * 0.9;
        }
        return height;
    }

    protected String getFormatedYScaleText(double value) {
        if (this.yScaleTextFormat != null) {
            String ret = this.yScaleTextFormat.format(value);
            if (this.unit != null) {
                ret = ret + this.unit;
            }
            return ret;
        }
        if (this.format != null) {
            String ret = this.format.format(value);
            if (this.unit != null) {
                ret = ret + this.unit;
            }
            return ret;
        }
        return value + (this.unit == null ? "" : this.unit);
    }

    public void setYScaleTextVisible(boolean yScaleTextVisible) {
        this.yScaleTextVisible = yScaleTextVisible;
    }

    public Color getYScaleTextColor() {
        return this.yScaleTextColor;
    }

    public void setYScaleTextColor(Color yScaleTextColor) {
        this.yScaleTextColor = yScaleTextColor;
    }

    public void setYScaleValueGap(double yScaleValueGap) {
        this.yScaleValueGap = yScaleValueGap;
    }

    public void setYScaleMinTextVisible(boolean yScaleMinTextVisible) {
        this.yScaleMinTextVisible = yScaleMinTextVisible;
    }

    protected void calculateValuesProportionsOfRange(boolean relativeMin, int categoryCount) {
        this.proportions.clear();
        int count = this.publishedElements.size();
        this.max = this.upperLimit;
        this.min = this.lowerLimit;
        if (this.upperLimit == -1.7976931348623157E308 || this.lowerLimit == Double.MAX_VALUE) {
            int i2;
            if (categoryCount >= 0) {
                for (i2 = 0; i2 < categoryCount; ++i2) {
                    int upSum = 0;
                    int lowSum = 0;
                    for (int j2 = 0; j2 < count; ++j2) {
                        Object obj;
                        Element element = (Element)this.publishedElements.get(j2);
                        List list = this.getValues(element);
                        if (list.size() <= i2 || !((obj = list.get(i2)) instanceof Double)) continue;
                        double value = (Double)obj;
                        if (value > 0.0) {
                            upSum = (int)((double)upSum + value);
                            continue;
                        }
                        lowSum = (int)((double)lowSum + value);
                    }
                    if (this.upperLimit == -1.7976931348623157E308 && (double)upSum > this.max) {
                        this.max = upSum;
                    }
                    if (this.lowerLimit != Double.MAX_VALUE || !((double)lowSum < this.min)) continue;
                    this.min = lowSum;
                }
            } else {
                for (i2 = 0; i2 < count; ++i2) {
                    Element element = (Element)this.publishedElements.get(i2);
                    List list = this.getValues(element);
                    int count2 = list.size();
                    if (this.endIndex < count2) {
                        count2 = this.endIndex;
                    }
                    for (int j3 = this.startIndex; j3 < count2; j3 += this.valueSpanCount) {
                        Object obj = list.get(j3);
                        if (!(obj instanceof Double)) continue;
                        double value = (Double)obj;
                        if (this.upperLimit == -1.7976931348623157E308 && value > this.max) {
                            this.max = value;
                        }
                        if (this.lowerLimit != Double.MAX_VALUE || !(value < this.min)) continue;
                        this.min = value;
                    }
                }
            }
        }
        if (this.lowerLimit == Double.MAX_VALUE) {
            this.min -= (this.max - this.min) * 0.1;
        }
        this.range = this.max - this.min;
        double relative = relativeMin ? this.min : 0.0;
        for (int i3 = 0; i3 < count; ++i3) {
            Element element = (Element)this.publishedElements.get(i3);
            List values = this.getValues(element);
            int count2 = values.size();
            for (int j4 = 0; j4 < count2; ++j4) {
                ArrayList<Double> list = (ArrayList<Double>)this.proportions.get(element);
                if (list == null) {
                    list = new ArrayList<Double>();
                    this.proportions.put(element, list);
                }
                if (this.range != 0.0 && j4 >= this.startIndex && j4 < this.endIndex && (j4 - this.startIndex) % this.valueSpanCount == 0) {
                    Object obj = values.get(j4);
                    if (obj == null) {
                        list.add(null);
                        continue;
                    }
                    double value = (Double)obj;
                    list.add(new Double((value - relative) / this.range));
                    continue;
                }
                list.add(null);
            }
        }
    }

    protected void calculateYScaleValueGap() {
        if (this.yScaleValueGap <= 0.0) {
            this.yscaleAutoCaculateFlag = true;
        }
        if (this.yScaleValueGapAutoCalculate && (this.yScaleValueGap <= 0.0 || this.yscaleAutoCaculateFlag)) {
            this.yScaleValueGap = this.getAutoScaleValueGap(this.range);
        }
    }

    protected double getAutoScaleValueGap(double range) {
        double gap = 0.0;
        double segment = 15.0;
        if (range <= 0.0) {
            return gap;
        }
        if (range < segment) {
            double rangeTemp;
            int ten = 10;
            if (range < 1.0) {
                String[] str = (range + "").split("\\.");
                String after = str[1];
                int length = after.length();
                for (int i2 = 0; i2 < length && "0".equals(after.substring(i2, i2 + 1)); ++i2) {
                    ten *= 10;
                }
            } else {
                ten = 1;
            }
            if ((rangeTemp = (double)ten * range) >= 4.0) {
                gap = 1.0 / (double)ten;
            } else if (rangeTemp >= segment / 10.0) {
                gap = 0.5 / (double)ten;
            } else if (rangeTemp < segment / 10.0) {
                gap = 0.1 / (double)ten;
            }
        }
        if (range < 25.0 && range >= segment) {
            gap = 5.0;
        }
        if (range >= 25.0) {
            int length = ((int)range + "").trim().length();
            int ten = 1;
            for (int i3 = 0; i3 < length - 1; ++i3) {
                ten *= 10;
            }
            gap = ten;
            double divisor = range / gap;
            if (divisor < 4.0 && (divisor = range / (gap = (double)(ten / 2))) < 4.0 && (divisor = range / (gap = (double)(ten / 5))) < 4.0) {
                gap = ten / 10;
            }
        }
        return gap;
    }

    public boolean isYScaleValueGapAutoCalculate() {
        return this.yScaleValueGapAutoCalculate;
    }

    public void setYScaleValueGapAutoCalculate(boolean scaleValueGapAutoCaculate) {
        this.yScaleValueGapAutoCalculate = scaleValueGapAutoCaculate;
    }

    public void setXScaleTextList(List xScaleTextList) {
        this.xScaleTextList = xScaleTextList;
        this.publishData();
    }

    public void addXScaleText(String text) {
        if (this.xScaleTextList == null) {
            this.xScaleTextList = new ArrayList();
        }
        this.xScaleTextList.add(text);
        this.publishData();
    }

    public String getXScaleText(int index) {
        if (this.xScaleTextList == null) {
            return null;
        }
        if (this.xScaleTextList.size() <= index || index < 0) {
            return null;
        }
        return (String)this.xScaleTextList.get(index);
    }

    public int getXScaleTextOrientation() {
        return this.xScaleTextOrientation;
    }

    public void setXScaleTextOrientation(int scaleTextOrientation) {
        this.xScaleTextOrientation = scaleTextOrientation;
    }

    public boolean isYScaleTextInside() {
        return this.yScaleTextInside;
    }

    public void setYScaleTextInside(boolean scaleTextInside) {
        this.yScaleTextInside = scaleTextInside;
    }

    protected int getXAxisExtraGap() {
        return 0;
    }

    public Color getXScaleTextColor() {
        return this.xScaleTextColor;
    }

    public void setXScaleTextColor(Color scaleTextColor) {
        this.xScaleTextColor = scaleTextColor;
    }

    public void removeMarker(Marker marker) {
        if (this.markers != null) {
            this.markers.remove(marker);
        }
    }

    public void addMarker(Marker marker) {
        if (marker == null) {
            return;
        }
        if (this.markers == null) {
            this.markers = new ArrayList();
        }
        this.markers.add(marker);
    }

    public boolean isXScaleTextVisible() {
        return this.xScaleTextVisible;
    }

    public void setXScaleTextVisible(boolean scaleTextVisible) {
        this.xScaleTextVisible = scaleTextVisible;
    }

    public String getXAxisText() {
        return this.xAxisText;
    }

    public void setXAxisText(String axisText) {
        this.xAxisText = axisText;
    }

    public Color getXAxisTextColor() {
        return this.xAxisTextColor;
    }

    public void setXAxisTextColor(Color xAxisTextColor) {
        this.xAxisTextColor = xAxisTextColor;
    }

    public String getYAxisText() {
        return this.yAxisText;
    }

    public void setYAxisText(String axisText) {
        this.yAxisText = axisText;
    }

    public int getYAxisTextGap() {
        return this.yAxisTextGap;
    }

    public void setYAxisTextGap(int axisTextGap) {
        this.yAxisTextGap = axisTextGap;
    }

    public int getYAxisTextOrientation() {
        return this.yAxisTextOrientation;
    }

    public void setYAxisTextOrientation(int axisTextOrientation) {
        this.yAxisTextOrientation = axisTextOrientation;
    }

    public boolean isXAxisVisible() {
        return this.xAxisVisible;
    }

    public void setXAxisVisible(boolean axisVisible) {
        this.xAxisVisible = axisVisible;
    }

    public Color getXAxisFillColor() {
        return this.xAxisFillColor;
    }

    public void setXAxisFillColor(Color axisFillColor) {
        this.xAxisFillColor = axisFillColor;
    }

    public Color getXAxisOutlineColor() {
        return this.xAxisOutlineColor;
    }

    public void setXAxisOutlineColor(Color axisOutlineColor) {
        this.xAxisOutlineColor = axisOutlineColor;
    }

    public Font getXAxisTextFont() {
        return this.xAxisTextFont;
    }

    public void setXAxisTextFont(Font axisTextFont) {
        this.xAxisTextFont = axisTextFont;
    }

    public double getXAxisValue() {
        return this.xAxisValue;
    }

    public void setXAxisValue(double axisValue) {
        this.xAxisValue = axisValue;
    }

    public String getXAxisStroke() {
        return this.xAxisStroke;
    }

    public void setXAxisStroke(String axisStroke) {
        this.xAxisStroke = axisStroke;
    }

    public boolean isYAxisVisible() {
        return this.yAxisVisible;
    }

    public void setYAxisVisible(boolean axisVisible) {
        this.yAxisVisible = axisVisible;
    }

    public Color getYAxisFillColor() {
        return this.yAxisFillColor;
    }

    public void setYAxisFillColor(Color axisFillColor) {
        this.yAxisFillColor = axisFillColor;
    }

    public Color getYAxisOutlineColor() {
        return this.yAxisOutlineColor;
    }

    public void setYAxisOutlineColor(Color axisOutlineColor) {
        this.yAxisOutlineColor = axisOutlineColor;
    }

    public Font getYAxisTextFont() {
        return this.yAxisTextFont;
    }

    public void setYAxisTextFont(Font axisTextFont) {
        this.yAxisTextFont = axisTextFont;
    }

    public Color getYAxisTextColor() {
        return this.yAxisTextColor;
    }

    public void setYAxisTextColor(Color axisTextColor) {
        this.yAxisTextColor = axisTextColor;
    }

    public String getYAxisStroke() {
        return this.yAxisStroke;
    }

    public void setYAxisStroke(String axisStroke) {
        this.yAxisStroke = axisStroke;
    }

    public String getYScaleLineStroke() {
        return this.yScaleLineStroke;
    }

    public void setYScaleLineStroke(String scaleLineStroke) {
        this.yScaleLineStroke = scaleLineStroke;
    }

    public Color getYScaleLineColor() {
        return this.yScaleLineColor;
    }

    public void setYScaleLineColor(Color scaleLineColor) {
        this.yScaleLineColor = scaleLineColor;
    }

    public boolean isYScaleLineVisible() {
        return this.yScaleLineVisible;
    }

    public void setYScaleLineVisible(boolean scaleLineVisible) {
        this.yScaleLineVisible = scaleLineVisible;
    }

    public int getYScalePixelGap() {
        return this.yScalePixelGap;
    }

    public void setYScalePixelGap(int scalePixelGap) {
        this.yScalePixelGap = scalePixelGap;
    }

    public NumberFormat getYScaleTextFormat() {
        return this.yScaleTextFormat;
    }

    public void setYScaleTextFormat(NumberFormat scaleTextFormat) {
        this.yScaleTextFormat = scaleTextFormat;
    }

    public Font getYScaleTextFont() {
        return this.yScaleTextFont;
    }

    public void setYScaleTextFont(Font scaleTextFont) {
        this.yScaleTextFont = scaleTextFont;
    }

    public Font getXScaleTextFont() {
        return this.xScaleTextFont;
    }

    public void setXScaleTextFont(Font scaleTextFont) {
        this.xScaleTextFont = scaleTextFont;
    }

    public double getYScaleValueGap() {
        return this.yScaleValueGap;
    }

    public boolean isYScaleMinTextVisible() {
        return this.yScaleMinTextVisible;
    }

    public boolean isYScaleTextVisible() {
        return this.yScaleTextVisible;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public int getValueSpanCount() {
        return this.valueSpanCount;
    }

    public void setValueSpanCount(int valueSpanCount) {
        this.valueSpanCount = valueSpanCount;
    }
}

