/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.swing.searcher.gis.google.loc;

import com.nepxion.swing.button.ButtonManager;
import com.nepxion.swing.button.JBasicButton;
import com.nepxion.swing.combobox.JBasicComboBox;
import com.nepxion.swing.dimension.DimensionManager;
import com.nepxion.swing.element.ElementNode;
import com.nepxion.swing.layout.toolbar.ToolBarLayout;
import com.nepxion.swing.locale.SwingLocale;
import com.nepxion.swing.scrollpane.JBasicScrollPane;
import com.nepxion.swing.searcher.gis.google.loc.JLocTable;
import com.nepxion.swing.searcher.gis.google.loc.LocController;
import com.nepxion.swing.textfield.JBasicTextField;
import com.nepxion.util.locale.LocaleConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JCellPanel
extends JPanel {
    private JBasicTextField cellIDTextField;
    private JBasicTextField lacTextField;
    private JBasicTextField mccTextField;
    private JBasicTextField mncTextField;
    private JBasicComboBox languageComboBox;
    private JLocTable table = new JLocTable();

    public JCellPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)new ToolBar(), "North");
        this.add((Component)new JBasicScrollPane(this.table), "Center");
    }

    public JLocTable getLocTable() {
        return this.table;
    }

    public int getCellID() {
        return Integer.parseInt(this.cellIDTextField.getText());
    }

    public void setCellID(int cellID) {
        this.cellIDTextField.setText(cellID + "");
    }

    public int getLac() {
        return Integer.parseInt(this.lacTextField.getText());
    }

    public void setLac(int lac) {
        this.lacTextField.setText(lac + "");
    }

    public int getMcc() {
        return Integer.parseInt(this.mccTextField.getText());
    }

    public void setMcc(int mcc) {
        this.mccTextField.setText(mcc + "");
    }

    public int getMnc() {
        return Integer.parseInt(this.mncTextField.getText());
    }

    public void setMnc(int mnc) {
        this.mncTextField.setText(mnc + "");
    }

    public String getLanguage() {
        ElementNode selectedElementNode = (ElementNode)this.languageComboBox.getSelectedItem();
        Locale locale = (Locale)selectedElementNode.getUserObject();
        return locale.toString();
    }

    public void setLanguage(String language) {
        for (int i = 0; i < this.languageComboBox.getItemCount(); ++i) {
            ElementNode selectedElementNode = (ElementNode)this.languageComboBox.getItemAt(i);
            Locale locale = (Locale)selectedElementNode.getUserObject();
            if (!locale.toString().equals(language)) continue;
            this.languageComboBox.setSelectedIndex(i);
            return;
        }
    }

    public class ToolBar
    extends JPanel {
        public ToolBar() {
            this.setLayout(new ToolBarLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            JCellPanel.this.cellIDTextField = new JBasicTextField();
            DimensionManager.setDimension(JCellPanel.this.cellIDTextField, new Dimension(100, 23));
            JCellPanel.this.lacTextField = new JBasicTextField();
            DimensionManager.setDimension(JCellPanel.this.lacTextField, new Dimension(100, 23));
            JCellPanel.this.mccTextField = new JBasicTextField();
            DimensionManager.setDimension(JCellPanel.this.mccTextField, new Dimension(100, 23));
            JCellPanel.this.mncTextField = new JBasicTextField();
            DimensionManager.setDimension(JCellPanel.this.mncTextField, new Dimension(100, 23));
            Locale[] locales = LocaleConstants.LOCALE_LIST;
            Object[] elementNodes = new ElementNode[locales.length];
            for (int i = 0; i < locales.length; ++i) {
                Locale locale = locales[i];
                String text = SwingLocale.getString(locale.toString().toLowerCase());
                elementNodes[i] = new ElementNode(text, null, text, locale);
            }
            JCellPanel.this.languageComboBox = new JBasicComboBox(elementNodes);
            DimensionManager.setDimension(JCellPanel.this.languageComboBox, new Dimension(90, 23));
            JBasicButton searchButton = new JBasicButton(LocController.getSearchAction(JCellPanel.this));
            JBasicButton clearButton = new JBasicButton(LocController.getClearAction(JCellPanel.this.table));
            this.add(new JLabel(SwingLocale.getString("cell_id")));
            this.add(JCellPanel.this.cellIDTextField);
            this.add(Box.createHorizontalStrut(5));
            this.add(new JLabel(SwingLocale.getString("lac")));
            this.add(JCellPanel.this.lacTextField);
            this.add(Box.createHorizontalStrut(5));
            this.add(new JLabel(SwingLocale.getString("mcc")));
            this.add(JCellPanel.this.mccTextField);
            this.add(Box.createHorizontalStrut(5));
            this.add(new JLabel(SwingLocale.getString("mnc")));
            this.add(JCellPanel.this.mncTextField);
            this.add(Box.createHorizontalStrut(5));
            this.add(new JLabel(SwingLocale.getString("language")));
            this.add(JCellPanel.this.languageComboBox);
            this.add(searchButton);
            this.add(clearButton);
            this.add(Box.createHorizontalGlue());
            ButtonManager.updateUI(this);
        }
    }
}

